/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EmergeGoal
extends Goal {
    private final SandSnapperEntity sandSnapper;
    private final float minDistanceFromPlayer;
    private final float minDistanceFromPlayerDuringSandstorm;
    private final float lookAtPlayerRange;
    private final int cooldown;
    private int ticksRunning;
    private int lastUseTime;

    public EmergeGoal(SandSnapperEntity sandSnapper, float minDistanceFromPlayer, float minDistanceFromPlayerDuringSandstorm, float lookAtPlayerRange, int cooldown) {
        this.sandSnapper = sandSnapper;
        this.minDistanceFromPlayer = minDistanceFromPlayer;
        this.minDistanceFromPlayerDuringSandstorm = minDistanceFromPlayerDuringSandstorm;
        this.lookAtPlayerRange = lookAtPlayerRange;
        this.cooldown = cooldown;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public void m_8037_() {
        ++this.ticksRunning;
        Player nearestPlayer = this.sandSnapper.m_9236_().m_45930_((Entity)this.sandSnapper, (double)this.lookAtPlayerRange);
        if (this.sandSnapper.isLookingAtPlayer() && nearestPlayer != null) {
            this.sandSnapper.m_21563_().m_148051_((Entity)nearestPlayer);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.ticksRunning = 0;
        this.sandSnapper.setEmerging(true);
        this.sandSnapper.setLookingAtPlayer(!this.getPlayersInRange(this.lookAtPlayerRange).isEmpty());
        this.sandSnapper.m_21573_().m_26573_();
    }

    public void m_8041_() {
        float dist;
        this.sandSnapper.setEmerging(false);
        this.sandSnapper.setDiving(true);
        this.lastUseTime = this.sandSnapper.f_19797_;
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.m_9236_()).getSandstormServerData();
        float f = dist = sandstormServerData.isSandstormActive() ? this.minDistanceFromPlayerDuringSandstorm : this.minDistanceFromPlayer;
        if (!this.getPlayersInRange(dist).isEmpty()) {
            this.sandSnapper.tryPlayPanicSound();
        }
    }

    public boolean m_8036_() {
        Vec3 endPos;
        if (!this.sandSnapper.isSubmerged() || !this.sandSnapper.canMove()) {
            return false;
        }
        if (this.sandSnapper.f_19797_ - this.lastUseTime < this.cooldown) {
            return false;
        }
        float halfWidth = 0.8f;
        Vec3 startPos = new Vec3(this.sandSnapper.m_20185_() - (double)halfWidth, this.sandSnapper.m_20186_() - 2.0, this.sandSnapper.m_20189_() - (double)halfWidth);
        boolean intersectsAir = BlockPos.m_121921_((AABB)new AABB(startPos, endPos = new Vec3(this.sandSnapper.m_20185_() + (double)halfWidth, this.sandSnapper.m_20186_() - (double)0.6f, this.sandSnapper.m_20189_() + (double)halfWidth))).anyMatch(pos -> this.sandSnapper.m_9236_().m_8055_(pos).m_60795_());
        if (intersectsAir) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.m_9236_()).getSandstormServerData();
        float dist = sandstormServerData.isSandstormActive() ? this.minDistanceFromPlayerDuringSandstorm : this.minDistanceFromPlayer;
        return this.getPlayersInRange(dist).isEmpty();
    }

    public boolean m_8045_() {
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.m_9236_()).getSandstormServerData();
        float dist = sandstormServerData.isSandstormActive() ? this.minDistanceFromPlayerDuringSandstorm : this.minDistanceFromPlayer;
        return this.getPlayersInRange(dist).isEmpty() && this.ticksRunning <= 57;
    }

    public boolean m_6767_() {
        return false;
    }

    private List<Player> getPlayersInRange(float range) {
        AABB searchBox = this.sandSnapper.m_20191_().m_82377_((double)range, 4.0, (double)range);
        return this.sandSnapper.m_9236_().m_45955_(TargetingConditions.f_26872_, (LivingEntity)this.sandSnapper, searchBox);
    }
}

