/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import org.violetmoon.zeta.api.IMutableAdvancement;

public class MutableAdvancement
implements IMutableAdvancement {
    final Advancement advancement;
    public Map<String, Criterion> criteria;
    public List<List<String>> requirements;

    public MutableAdvancement(Advancement advancement) {
        this.advancement = advancement;
        this.mutabilize();
    }

    @Override
    public void addRequiredCriterion(String name, Criterion criterion) {
        this.criteria.put(name, criterion);
        this.requirements.add(Lists.newArrayList((Object[])new String[]{name}));
    }

    @Override
    public void addOrCriterion(String name, Criterion criterion) {
        this.criteria.put(name, criterion);
        this.requirements.get(0).add(name);
    }

    @Override
    public Criterion getCriterion(String title) {
        return this.criteria.get(title);
    }

    private void mutabilize() {
        String[][] arr;
        this.criteria = Maps.newHashMap((Map)this.advancement.f_138302_);
        this.requirements = new ArrayList<List<String>>();
        for (String[] req : arr = this.advancement.f_138303_) {
            ArrayList<String> reqList = new ArrayList<String>(Arrays.asList(req));
            this.requirements.add(reqList);
        }
    }

    public void commit() {
        this.advancement.f_138302_ = ImmutableMap.copyOf(this.criteria);
        ArrayList<String[]> requirementArrays = new ArrayList<String[]>();
        for (List<String> list : this.requirements) {
            String[] arr = list.toArray(new String[list.size()]);
            requirementArrays.add(arr);
        }
        String[][] arr = (String[][])requirementArrays.toArray((T[])new String[0][requirementArrays.size()]);
        this.advancement.f_138303_ = arr;
    }
}

