/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block.ext;

import com.google.common.collect.BiMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public interface IZetaBlockExtensions {
    public static final IZetaBlockExtensions DEFAULT = new IZetaBlockExtensions(){};

    default public int getLightEmissionZeta(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60791_();
    }

    default public boolean isLadderZeta(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.m_204336_(BlockTags.f_13082_);
    }

    default public boolean makesOpenTrapdoorAboveClimbableZeta(BlockState state, LevelReader level, BlockPos pos, BlockState trapdoorState) {
        return state.m_60734_() instanceof LadderBlock && state.m_61143_((Property)LadderBlock.f_54337_) == trapdoorState.m_61143_((Property)TrapDoorBlock.f_54117_);
    }

    default public boolean canSustainPlantZeta(BlockState state, BlockGetter level, BlockPos pos, Direction facing, String plantabletype) {
        return false;
    }

    default public boolean isConduitFrameZeta(BlockState state, LevelReader level, BlockPos pos, BlockPos conduit) {
        return state.m_60734_() == Blocks.f_50377_ || state.m_60734_() == Blocks.f_50378_ || state.m_60734_() == Blocks.f_50386_ || state.m_60734_() == Blocks.f_50379_;
    }

    default public float getEnchantPowerBonusZeta(BlockState state, LevelReader level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50078_) ? 1.0f : 0.0f;
    }

    default public SoundType getSoundTypeZeta(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return state.m_60827_();
    }

    default public float[] getBeaconColorMultiplierZeta(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        Block block = state.m_60734_();
        if (block instanceof BeaconBeamBlock) {
            BeaconBeamBlock bbeam = (BeaconBeamBlock)block;
            return bbeam.m_7988_().m_41068_();
        }
        return null;
    }

    default public boolean isStickyBlockZeta(BlockState state) {
        return state.m_60734_() == Blocks.f_50374_ || state.m_60734_() == Blocks.f_50719_;
    }

    default public boolean canStickToZeta(BlockState state, BlockState other) {
        if (state.m_60734_() == Blocks.f_50719_ && other.m_60734_() == Blocks.f_50374_) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_50374_ && other.m_60734_() == Blocks.f_50719_) {
            return false;
        }
        return state.isStickyBlock() || other.isStickyBlock();
    }

    default public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.f_50083_).m_221164_(state);
    }

    default public boolean isFlammableZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.getFlammabilityZeta(state, world, pos, face) > 0;
    }

    default public int getFireSpreadSpeedZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.f_50083_).m_221166_(state);
    }

    default public boolean collisionExtendsVerticallyZeta(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return state.m_204336_(BlockTags.f_13039_) || state.m_204336_(BlockTags.f_13032_) || state.m_60734_() instanceof FenceGateBlock;
    }

    default public boolean shouldDisplayFluidOverlayZeta(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return state.m_60734_() instanceof HalfTransparentBlock || state.m_60734_() instanceof LeavesBlock;
    }

    @Nullable
    default public BlockState getToolModifiedStateZeta(BlockState state, UseOnContext context, String toolActionType, boolean simulate) {
        return switch (toolActionType) {
            case "axe_strip" -> AxeItem.getAxeStrippingState((BlockState)state);
            case "axe_scrape" -> WeatheringCopper.m_154899_((BlockState)state).orElse(null);
            case "axe_wax_off" -> Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(block -> block.m_152465_(state)).orElse(null);
            case "shovel_flatten" -> ShovelItem.getShovelPathingState((BlockState)state);
            case "hoe_till" -> {
                Block block = state.m_60734_();
                if (block == Blocks.f_152549_) {
                    if (!simulate && !context.m_43725_().f_46443_) {
                        Block.m_152435_((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_(), (ItemStack)new ItemStack((ItemLike)Items.f_151017_));
                    }
                    yield Blocks.f_50493_.m_49966_();
                }
                if ((block == Blocks.f_50440_ || block == Blocks.f_152481_ || block == Blocks.f_50493_ || block == Blocks.f_50546_) && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
                    if (block == Blocks.f_50546_) {
                        yield Blocks.f_50493_.m_49966_();
                    }
                    yield Blocks.f_50093_.m_49966_();
                }
                yield null;
            }
            default -> null;
        };
    }

    default public boolean isScaffoldingZeta(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.m_60713_(Blocks.f_50616_);
    }
}

