/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.feature.common.mods.minecraft;

import dev.uncandango.alltheleaks.annotation.Issue;
import dev.uncandango.alltheleaks.mixin.Lockable;
import dev.uncandango.alltheleaks.mixin.core.main.IngredientMixin;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fml.loading.LoadingModList;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Issue(modId="minecraft", issueId="Ingredient Deduplication", versionRange="1.20.1", mixins={"main.IngredientMixin", "main.IngredientMixin$IngredientAccessor", "main.IngredientMixin$TagValueMixin", "main.IngredientMixin$TagValueAccessor", "main.IngredientMixin$ItemValueAccessor", "main.IngredientLockMixin", "main.ItemStackLockMixin", "main.CompoundLockMixin", "main.ListTagLockMixin", "main.IntArrayTagMixin", "main.LongArrayTagMixin", "main.ByteArrayTagMixin", "main.IngredientItemValueMixin", "main.CapabilityProviderAccessor"}, config="ingredientDedupe", configActivated=false, description="Deduplicates VANILLA ingredients to reduce memory usage")
public class IngredientDedupe {
    private static final ObjectOpenCustomHashSet<Ingredient> INGREDIENT_CACHE;
    public static final boolean MODERNFIX_DEDUPLICATION;

    public static synchronized Ingredient intern(Ingredient ingredient) {
        Ingredient deduped = (Ingredient)INGREDIENT_CACHE.addOrGet((Object)ingredient);
        if (!((Lockable)deduped).atl$isLocked()) {
            ((Lockable)deduped).atl$setLocked(true);
        }
        return deduped;
    }

    static {
        Hash.Strategy<Ingredient> BASIC_HASH_STRATEGY = new Hash.Strategy<Ingredient>(){

            public int hashCode(Ingredient o) {
                if (o.isVanilla() && o instanceof IngredientMixin.IngredientAccessor) {
                    IngredientMixin.IngredientAccessor accessor = (IngredientMixin.IngredientAccessor)o;
                    if (o == null) {
                        return 0;
                    }
                    int result = 1;
                    for (Ingredient.Value element : accessor.getValues()) {
                        if (element instanceof IngredientMixin.ItemValueAccessor) {
                            IngredientMixin.ItemValueAccessor iv = (IngredientMixin.ItemValueAccessor)element;
                            result = 31 * result + ItemStackLinkedSet.f_260558_.hashCode((Object)iv.getItem()) + iv.getItem().m_41613_();
                            continue;
                        }
                        result = 31 * result + (element == null ? 0 : element.hashCode());
                    }
                    return result;
                }
                return Objects.hashCode(o);
            }

            public boolean equals(Ingredient a, Ingredient b) {
                Ingredient.Value[] bValues;
                if (b == null) {
                    return false;
                }
                Ingredient.Value[] aValues = ((IngredientMixin.IngredientAccessor)a).getValues();
                if (aValues.length != (bValues = ((IngredientMixin.IngredientAccessor)b).getValues()).length) {
                    return false;
                }
                for (int i = 0; i < aValues.length; ++i) {
                    Ingredient.Value aValue = aValues[i];
                    Ingredient.Value bValue = bValues[i];
                    if (aValue.getClass() != bValue.getClass()) {
                        return false;
                    }
                    if (aValue.getClass() == Ingredient.TagValue.class) {
                        if (aValue.equals(bValue)) continue;
                        return false;
                    }
                    if (aValue.getClass() == Ingredient.ItemValue.class) {
                        ItemStack bItem;
                        ItemStack aItem;
                        if (!(MODERNFIX_DEDUPLICATION ? aValue != bValue : !ItemStack.m_150942_((ItemStack)(aItem = ((IngredientMixin.ItemValueAccessor)aValue).getItem()), (ItemStack)(bItem = ((IngredientMixin.ItemValueAccessor)bValue).getItem())) || aItem.m_41613_() != bItem.m_41613_())) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        };
        INGREDIENT_CACHE = new ObjectOpenCustomHashSet((Hash.Strategy)BASIC_HASH_STRATEGY);
        MODERNFIX_DEDUPLICATION = LoadingModList.get().getModFileById("modernfix") != null ? ModernFixMixinPlugin.instance.isOptionEnabled("perf.ingredient_item_deduplication.IngredientMixin") : false;
    }
}

