/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.util.SettingsFrom;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PatternProviderBlockEntity
extends AENetworkBlockEntity
implements PatternProviderLogicHost {
    protected final PatternProviderLogic logic = this.createLogic();
    @Nullable
    private PushDirection pendingPushDirectionChange;

    public PatternProviderBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    protected PatternProviderLogic createLogic() {
        return new PatternProviderLogic(this.getMainNode(), this);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.logic.onMainNodeStateChanged();
    }

    private PushDirection getPushDirection() {
        return (PushDirection)((Object)this.m_58900_().m_61143_(PatternProviderBlock.PUSH_DIRECTION));
    }

    @Override
    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        Direction pushDirection = this.getPushDirection().getDirection();
        if (pushDirection == null) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.complementOf(EnumSet.of(pushDirection));
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        this.logic.addDrops(drops);
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.logic.clearContent();
    }

    @Override
    public void onReady() {
        if (this.pendingPushDirectionChange != null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(PatternProviderBlock.PUSH_DIRECTION, (Comparable)((Object)this.pendingPushDirectionChange)));
            this.pendingPushDirectionChange = null;
            this.onGridConnectableSidesChanged();
        }
        super.onReady();
        this.logic.updatePatterns();
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.logic.writeToNBT(data);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        if (data.m_128471_("omniDirectional")) {
            this.pendingPushDirectionChange = PushDirection.ALL;
        } else if (data.m_128425_("forward", 8)) {
            try {
                Direction forward = Direction.valueOf((String)data.m_128461_("forward").toUpperCase(Locale.ROOT));
                this.pendingPushDirectionChange = PushDirection.fromDirection(forward);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.logic.readFromNBT(data);
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public PatternProviderLogic getLogic() {
        return this.logic;
    }

    @Override
    public EnumSet<Direction> getTargets() {
        PushDirection pushDirection = this.getPushDirection();
        if (pushDirection.getDirection() == null) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.of(pushDirection.getDirection());
    }

    @Override
    public AEItemKey getTerminalIcon() {
        return AEItemKey.of(AEBlocks.PATTERN_PROVIDER.stack());
    }

    @Override
    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(output);
            PushDirection pushDirection = this.getPushDirection();
            output.m_128344_("push_direction", (byte)pushDirection.ordinal());
        }
    }

    @Override
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            Level level;
            byte pushDirection;
            this.logic.importSettings(input, player);
            if (input.m_128425_(PatternProviderBlock.PUSH_DIRECTION.m_61708_(), 1) && (pushDirection = input.m_128445_(PatternProviderBlock.PUSH_DIRECTION.m_61708_())) >= 0 && pushDirection < PushDirection.values().length && (level = this.m_58904_()) != null) {
                level.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(PatternProviderBlock.PUSH_DIRECTION, (Comparable)((Object)PushDirection.values()[pushDirection])));
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @javax.annotation.Nullable Direction side) {
        LazyOptional<T> lo = this.logic.getCapability(cap);
        if (lo.isPresent()) {
            return lo;
        }
        return super.getCapability(cap, side);
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return AEBlocks.PATTERN_PROVIDER.stack();
    }

    @Override
    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.onGridConnectableSidesChanged();
    }
}

