/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.util.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class InventoryActionPacket
extends BasePacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final ItemStack slotItem;

    public InventoryActionPacket(FriendlyByteBuf stream) {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        this.slotItem = stream.m_130267_();
    }

    public InventoryActionPacket(InventoryAction action, int slot, ItemStack slotItem) {
        if (Platform.isClient() && action != InventoryAction.SET_FILTER) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem.m_41777_();
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        data.m_130055_(this.slotItem);
        this.configureWrite(data);
    }

    public InventoryActionPacket(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.m_130055_(ItemStack.f_41583_);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof AEBaseMenu) {
            AEBaseMenu baseMenu = (AEBaseMenu)abstractContainerMenu;
            if (this.action == InventoryAction.SET_FILTER) {
                baseMenu.setFilter(this.slot, this.slotItem);
            } else {
                baseMenu.doAction(player, this.action, this.slot, this.id);
            }
        }
    }
}

