/*
 * Decompiled with CFR 0.152.
 */
package appeng.init;

import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.items.parts.FacadeItem;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.game.FacadeRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.ChargerRecipeSerializer;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.handlers.InscriberRecipeSerializer;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.recipes.mattercannon.MatterCannonAmmoSerializer;
import appeng.recipes.transform.TransformRecipe;
import appeng.recipes.transform.TransformRecipeSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.IForgeRegistry;

public final class InitRecipeSerializers {
    private InitRecipeSerializers() {
    }

    public static void init(IForgeRegistry<RecipeSerializer<?>> registry) {
        FacadeItem facadeItem = AEItems.FACADE.m_5456_();
        InitRecipeSerializers.register(registry, InscriberRecipe.TYPE_ID, InscriberRecipeSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, AppEng.makeId("facade"), FacadeRecipe.getSerializer(facadeItem));
        InitRecipeSerializers.register(registry, EntropyRecipe.TYPE_ID, EntropyRecipeSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, MatterCannonAmmo.TYPE_ID, MatterCannonAmmoSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, TransformRecipe.TYPE_ID, TransformRecipeSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, ChargerRecipe.TYPE_ID, ChargerRecipeSerializer.INSTANCE);
    }

    private static void register(IForgeRegistry<RecipeSerializer<?>> registry, ResourceLocation id, RecipeSerializer<?> serializer) {
        registry.register(id, serializer);
    }
}

