/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.rei.FluidBlockRenderer;
import appeng.integration.modules.rei.TransformRecipeWrapper;
import appeng.recipes.transform.TransformCircumstance;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;

public class TransformCategory
implements DisplayCategory<TransformRecipeWrapper> {
    public static final CategoryIdentifier<TransformRecipeWrapper> ID = CategoryIdentifier.of((ResourceLocation)AppEng.makeId("item_transformation"));
    private final Renderer icon = EntryStacks.of(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED);

    public Renderer getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return ItemModText.TRANSFORM_CATEGORY.text();
    }

    public CategoryIdentifier<TransformRecipeWrapper> getCategoryIdentifier() {
        return ID;
    }

    public List<Widget> setupDisplay(TransformRecipeWrapper display, Rectangle bounds) {
        int col1;
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int x = col1 = bounds.x + 10;
        int y = bounds.y + 10;
        int nInputs = display.getInputEntries().size();
        if (nInputs < 3) {
            y += 9 * (3 - nInputs);
        }
        int yOffset = bounds.y + 28;
        int col2 = col1 + 25;
        Arrow arrow1 = Widgets.createArrow((Point)new Point(col2, yOffset));
        widgets.add((Widget)arrow1);
        return widgets;
    }

    private Collection<? extends EntryStack<?>> getCatalystForRendering(TransformRecipeWrapper display) {
        TransformCircumstance circumstance = display.getTransformCircumstance();
        if (circumstance.isFluid()) {
            return circumstance.getFluidsForRendering().stream().map(TransformCategory::makeCustomRenderingFluidEntry).toList();
        }
        if (circumstance.isExplosion()) {
            return List.of(EntryStacks.of(AEBlocks.TINY_TNT), EntryStacks.of((ItemLike)Blocks.f_50077_));
        }
        return List.of();
    }

    private static EntryStack<FluidStack> makeCustomRenderingFluidEntry(Fluid fluid) {
        EntryStack fluidStack = EntryStacks.of((Fluid)fluid);
        ClientEntryStacks.setRenderer((EntryStack)fluidStack, entryStack -> new FluidBlockRenderer());
        return fluidStack;
    }

    public int getDisplayHeight() {
        return 72;
    }
}

