/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.integration.ShaderMod;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.monitor.MonitorRenderState;
import dan200.computercraft.client.render.monitor.MonitorTextureBufferShader;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.client.render.vbo.DirectBuffers;
import dan200.computercraft.client.render.vbo.DirectVertexBuffer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.jspecify.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class MonitorBlockEntityRenderer
implements BlockEntityRenderer<MonitorBlockEntity> {
    private static final float MARGIN = 0.034375f;
    private static final Matrix3f IDENTITY_NORMAL = new Matrix3f().identity();
    private static @Nullable ByteBuffer backingBuffer;
    private static long lastFrame;

    public MonitorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MonitorBlockEntity monitor, float partialTicks, PoseStack transform, MultiBufferSource bufferSource, int lightmapCoord, int overlayLight) {
        ClientMonitor originTerminal = monitor.getOriginClientMonitor();
        if (originTerminal == null) {
            return;
        }
        MonitorBlockEntity origin = originTerminal.getOrigin();
        MonitorRenderState renderState = originTerminal.getRenderState(MonitorRenderState::new);
        BlockPos monitorPos = monitor.m_58899_();
        long renderFrame = FrameInfo.getRenderFrame();
        if (renderState.lastRenderFrame == renderFrame && !monitorPos.equals((Object)renderState.lastRenderPos)) {
            return;
        }
        lastFrame = renderFrame;
        renderState.lastRenderFrame = renderFrame;
        renderState.lastRenderPos = monitorPos;
        BlockPos originPos = origin.m_58899_();
        Direction dir = origin.getDirection();
        Direction front = origin.getFront();
        float yaw = dir.m_122435_();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.m_85836_();
        transform.m_85837_((double)(originPos.m_123341_() - monitorPos.m_123341_()) + 0.5, (double)(originPos.m_123342_() - monitorPos.m_123342_()) + 0.5, (double)(originPos.m_123343_() - monitorPos.m_123343_()) + 0.5);
        transform.m_252781_(Axis.f_252392_.m_252977_(yaw));
        transform.m_252781_(Axis.f_252529_.m_252977_(pitch));
        transform.m_85837_(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null && !ShaderMod.get().isRenderingShadowPass()) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.m_85836_();
            transform.m_85841_((float)xScale, (float)(-yScale), 1.0f);
            Matrix4f matrix = transform.m_85850_().m_252922_();
            MonitorBlockEntityRenderer.renderTerminal(matrix, originTerminal, renderState, terminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            transform.m_85849_();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.m_6299_(RenderTypes.TERMINAL)), -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        transform.m_85849_();
    }

    private static void renderTerminal(Matrix4f matrix, ClientMonitor monitor, MonitorRenderState renderState, Terminal terminal, float xMargin, float yMargin) {
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int pixelWidth = width * 6;
        int pixelHeight = height * 9;
        MonitorRenderer renderType = MonitorBlockEntityRenderer.currentRenderer();
        boolean redraw = monitor.pollTerminalChanged();
        if (renderState.createBuffer(renderType)) {
            redraw = true;
        }
        switch (renderType) {
            case TBO: {
                if (redraw) {
                    ByteBuffer terminalBuffer = MonitorBlockEntityRenderer.getBuffer(width * height * 3);
                    MonitorTextureBufferShader.setTerminalData(terminalBuffer, terminal);
                    DirectBuffers.setBufferData(35882, renderState.tboBuffer, terminalBuffer, 35044);
                    ByteBuffer uniformBuffer = MonitorBlockEntityRenderer.getBuffer(276);
                    MonitorTextureBufferShader.setUniformData(uniformBuffer, terminal);
                    DirectBuffers.setBufferData(35345, renderState.tboUniform, uniformBuffer, 35044);
                }
                int active = GlStateManager._getActiveTexture();
                RenderSystem.activeTexture((int)33987);
                GL11.glBindTexture((int)35882, (int)renderState.tboTexture);
                RenderSystem.activeTexture((int)active);
                MonitorTextureBufferShader shader = RenderTypes.getMonitorTextureBufferShader();
                shader.setupUniform(renderState.tboUniform);
                BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                buffer.m_166779_(RenderTypes.MONITOR_TBO.m_173186_(), RenderTypes.MONITOR_TBO.m_110508_());
                MonitorBlockEntityRenderer.tboVertex((VertexConsumer)buffer, matrix, -xMargin, -yMargin);
                MonitorBlockEntityRenderer.tboVertex((VertexConsumer)buffer, matrix, -xMargin, (float)pixelHeight + yMargin);
                MonitorBlockEntityRenderer.tboVertex((VertexConsumer)buffer, matrix, (float)pixelWidth + xMargin, -yMargin);
                MonitorBlockEntityRenderer.tboVertex((VertexConsumer)buffer, matrix, (float)pixelWidth + xMargin, (float)pixelHeight + yMargin);
                RenderTypes.MONITOR_TBO.m_276775_(buffer, VertexSorting.f_276450_);
                break;
            }
            case VBO: {
                DirectVertexBuffer backgroundBuffer = Nullability.assertNonNull(renderState.backgroundBuffer);
                DirectVertexBuffer foregroundBuffer = Nullability.assertNonNull(renderState.foregroundBuffer);
                if (redraw) {
                    int size = DirectFixedWidthFontRenderer.getVertexCount(terminal);
                    MonitorBlockEntityRenderer.renderToBuffer(backgroundBuffer, size, sink -> DirectFixedWidthFontRenderer.drawTerminalBackground(sink, 0.0f, 0.0f, terminal, yMargin, yMargin, xMargin, xMargin));
                    MonitorBlockEntityRenderer.renderToBuffer(foregroundBuffer, size, sink -> {
                        DirectFixedWidthFontRenderer.drawTerminalForeground(sink, 0.0f, 0.0f, terminal);
                        DirectFixedWidthFontRenderer.drawCursor(sink, 0.0f, 0.0f, terminal);
                    });
                }
                Matrix3f oldInverseRotation = RenderSystem.getInverseViewRotationMatrix();
                RenderSystem.setInverseViewRotationMatrix((Matrix3f)IDENTITY_NORMAL);
                RenderTypes.TERMINAL.m_110185_();
                backgroundBuffer.m_85921_();
                backgroundBuffer.m_253207_(matrix, RenderSystem.getProjectionMatrix(), RenderTypes.getTerminalShader());
                RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
                RenderSystem.enablePolygonOffset();
                foregroundBuffer.m_85921_();
                foregroundBuffer.drawWithShader(matrix, RenderSystem.getProjectionMatrix(), RenderTypes.getTerminalShader(), FixedWidthFontRenderer.isCursorVisible(terminal) && !FrameInfo.getGlobalCursorBlink() ? foregroundBuffer.getIndexCount() - RenderTypes.TERMINAL.m_173186_().m_166958_(4) : foregroundBuffer.getIndexCount());
                RenderSystem.polygonOffset((float)0.0f, (float)-0.0f);
                RenderSystem.disablePolygonOffset();
                RenderTypes.TERMINAL.m_110188_();
                VertexBuffer.m_85931_();
                RenderSystem.setInverseViewRotationMatrix((Matrix3f)oldInverseRotation);
                break;
            }
            case BEST: {
                throw new IllegalStateException("Impossible: Should never use BEST renderer");
            }
        }
    }

    private static void renderToBuffer(DirectVertexBuffer vbo, int size, Consumer<DirectFixedWidthFontRenderer.QuadEmitter> draw) {
        DirectFixedWidthFontRenderer.QuadEmitter sink = ShaderMod.get().getQuadEmitter(size, MonitorBlockEntityRenderer::getBuffer);
        ByteBuffer buffer = sink.buffer();
        draw.accept(sink);
        buffer.flip();
        vbo.upload(buffer.limit() / sink.format().m_86020_(), RenderTypes.TERMINAL.m_173186_(), sink.format(), buffer);
    }

    private static void tboVertex(VertexConsumer builder, Matrix4f matrix, float x, float y) {
        builder.m_252986_(matrix, x, y, 0.0f).m_7421_(x, y).m_5752_();
    }

    private static ByteBuffer getBuffer(int capacity) {
        ByteBuffer buffer = backingBuffer;
        if (buffer == null || buffer.capacity() < capacity) {
            backingBuffer = buffer == null ? MemoryTracker.m_182527_((int)capacity) : MemoryTracker.m_182529_((ByteBuffer)buffer, (int)capacity);
            buffer = backingBuffer;
        }
        buffer.clear();
        return buffer;
    }

    public int m_142163_() {
        return Config.monitorDistance;
    }

    public static boolean hasRenderedThisFrame() {
        return FrameInfo.getRenderFrame() == lastFrame;
    }

    public static MonitorRenderer currentRenderer() {
        MonitorRenderer current = Config.monitorRenderer;
        if (current == MonitorRenderer.BEST) {
            current = Config.monitorRenderer = MonitorBlockEntityRenderer.bestRenderer();
        }
        return current;
    }

    private static MonitorRenderer bestRenderer() {
        return MonitorRenderer.VBO;
    }

    static {
        lastFrame = -1L;
    }
}

