/*
 * Decompiled with CFR 0.152.
 */
package de.presti.ccbx.ccbx;

import ballistix.common.tile.TileMissileSilo;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import de.presti.ccbx.ccbx.BallistixUtil;
import de.presti.ccbx.ccbx.CCBXItemStackHandler;
import de.presti.ccbx.ccbx.CCBallistiXPeripheral;
import de.presti.ccbx.ccbx.Registration;
import electrodynamics.prefab.tile.components.CapabilityInputType;
import electrodynamics.prefab.tile.components.IComponent;
import electrodynamics.prefab.tile.components.IComponentType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CCBallistiXTileEntity
extends BlockEntity {
    private int tickCounter = 0;
    private final ItemStackHandler inventory = new CCBXItemStackHandler(this);
    private final LazyOptional<ItemStackHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    protected CCBallistiXPeripheral peripheral = new CCBallistiXPeripheral(this);
    private LazyOptional<IPeripheral> peripheralCap;

    public CCBallistiXTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CC_TILEENTITY.get(), pos, state);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        try {
            CompoundTag data = nbt.m_128469_("Buffer");
            this.inventory.deserializeNBT(data.m_128469_("Inventory"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag data = new CompoundTag();
        data.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128365_("Buffer", (Tag)data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction direction) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> this.peripheral);
            }
            return this.peripheralCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter % 10 != 0 || this.inventory.getStackInSlot(0).m_41619_() && this.inventory.getStackInSlot(1).m_41619_()) {
            return;
        }
        TileMissileSilo silo = BallistixUtil.getMissileSilo(this.m_58904_(), this.m_58899_().m_7494_());
        if (silo == null) {
            return;
        }
        IComponent inventoryComponent = silo.getComponent(IComponentType.Inventory);
        if (inventoryComponent == null) {
            return;
        }
        inventoryComponent.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP, CapabilityInputType.INPUT).ifPresent(wrapper -> {
            ItemStack newStack;
            ItemStack ourMissileStack = this.inventory.getStackInSlot(0);
            ItemStack ourExplosiveStack = this.inventory.getStackInSlot(1);
            ItemStack theirMissileStack = wrapper.getStackInSlot(0);
            ItemStack theirExplosiveStack = wrapper.getStackInSlot(1);
            if (theirMissileStack.m_41619_() || ourMissileStack.m_41720_() == theirMissileStack.m_41720_()) {
                newStack = wrapper.insertItem(0, ourMissileStack, false);
                this.inventory.setStackInSlot(0, newStack);
            }
            if (theirExplosiveStack.m_41619_() || ourExplosiveStack.m_41720_() == theirExplosiveStack.m_41720_()) {
                newStack = wrapper.insertItem(1, ourExplosiveStack, false);
                this.inventory.setStackInSlot(1, newStack);
            }
        });
    }
}

