/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation.peripherals;

import com.simibubi.create.AllPackets;
import com.simibubi.create.compat.computercraft.implementation.CreateLuaTable;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.foundation.utility.StringHelper;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class StationPeripheral
extends SyncedPeripheral<StationBlockEntity> {
    public StationPeripheral(StationBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction(mainThread=true)
    public final void assemble() throws LuaException {
        if (!((StationBlockEntity)this.blockEntity).isAssembling()) {
            throw new LuaException("station must be in assembly mode");
        }
        ((StationBlockEntity)this.blockEntity).assemble(null);
        if (((StationBlockEntity)this.blockEntity).getStation() == null || ((StationBlockEntity)this.blockEntity).getStation().getPresentTrain() == null) {
            throw new LuaException("failed to assemble train");
        }
        if (!((StationBlockEntity)this.blockEntity).exitAssemblyMode()) {
            throw new LuaException("failed to exit assembly mode");
        }
    }

    @LuaFunction(mainThread=true)
    public final void disassemble() throws LuaException {
        if (((StationBlockEntity)this.blockEntity).isAssembling()) {
            throw new LuaException("station must not be in assembly mode");
        }
        this.getTrainOrThrow();
        if (!((StationBlockEntity)this.blockEntity).enterAssemblyMode(null)) {
            throw new LuaException("could not disassemble train");
        }
    }

    @LuaFunction(mainThread=true)
    public final void setAssemblyMode(boolean assemblyMode) throws LuaException {
        if (assemblyMode) {
            if (!((StationBlockEntity)this.blockEntity).enterAssemblyMode(null)) {
                throw new LuaException("failed to enter assembly mode");
            }
        } else if (!((StationBlockEntity)this.blockEntity).exitAssemblyMode()) {
            throw new LuaException("failed to exit assembly mode");
        }
    }

    @LuaFunction
    public final boolean isInAssemblyMode() {
        return ((StationBlockEntity)this.blockEntity).isAssembling();
    }

    @LuaFunction
    public final String getStationName() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.name;
    }

    @LuaFunction(mainThread=true)
    public final void setStationName(String name) throws LuaException {
        if (!((StationBlockEntity)this.blockEntity).updateName(name)) {
            throw new LuaException("could not set station name");
        }
    }

    @LuaFunction
    public final boolean isTrainPresent() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.getPresentTrain() != null;
    }

    @LuaFunction
    public final boolean isTrainImminent() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.getImminentTrain() != null;
    }

    @LuaFunction
    public final boolean isTrainEnroute() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.getNearestTrain() != null;
    }

    @LuaFunction
    public final String getTrainName() throws LuaException {
        Train train = this.getTrainOrThrow();
        return train.name.getString();
    }

    @LuaFunction(mainThread=true)
    public final void setTrainName(String name) throws LuaException {
        Train train = this.getTrainOrThrow();
        train.name = Component.m_237113_((String)name);
        AllPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new TrainEditPacket.TrainEditReturnPacket(train.id, name, train.icon.getId(), train.mapColorIndex));
    }

    @LuaFunction
    public final boolean hasSchedule() throws LuaException {
        Train train = this.getTrainOrThrow();
        return train.runtime.getSchedule() != null;
    }

    @LuaFunction
    public final CreateLuaTable getSchedule() throws LuaException {
        Train train = this.getTrainOrThrow();
        Schedule schedule = train.runtime.getSchedule();
        if (schedule == null) {
            throw new LuaException("train doesn't have a schedule");
        }
        return StationPeripheral.fromCompoundTag(schedule.write());
    }

    @LuaFunction(mainThread=true)
    public final void setSchedule(IArguments arguments) throws LuaException {
        Train train = this.getTrainOrThrow();
        Schedule schedule = Schedule.fromTag(StationPeripheral.toCompoundTag(new CreateLuaTable(arguments.getTable(0))));
        if (schedule.entries.isEmpty()) {
            throw new LuaException("Schedule must have at least one entry");
        }
        boolean autoSchedule = train.runtime.getSchedule() == null || train.runtime.isAutoSchedule;
        train.runtime.setSchedule(schedule, autoSchedule);
    }

    @NotNull
    private Train getTrainOrThrow() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        Train train = station.getPresentTrain();
        if (train == null) {
            throw new LuaException("there is no train present");
        }
        return train;
    }

    @NotNull
    private static CreateLuaTable fromCompoundTag(CompoundTag tag) throws LuaException {
        return (CreateLuaTable)StationPeripheral.fromNBTTag(null, (Tag)tag);
    }

    @NotNull
    private static Object fromNBTTag(@Nullable String key, Tag tag) throws LuaException {
        byte type = tag.m_7060_();
        if (type == 1 && key != null && key.equals("Count")) {
            return ((NumericTag)tag).m_7063_();
        }
        if (type == 1) {
            return ((NumericTag)tag).m_7063_() != 0;
        }
        if (type == 2 || type == 3 || type == 4) {
            return ((NumericTag)tag).m_7046_();
        }
        if (type == 5 || type == 6) {
            return ((NumericTag)tag).m_7061_();
        }
        if (type == 8) {
            return tag.m_7916_();
        }
        if (type == 9 || type == 7 || type == 11 || type == 12) {
            CreateLuaTable list = new CreateLuaTable();
            CollectionTag listTag = (CollectionTag)tag;
            for (int i = 0; i < listTag.size(); ++i) {
                list.put(i + 1, StationPeripheral.fromNBTTag(null, (Tag)listTag.get(i)));
            }
            return list;
        }
        if (type == 10) {
            CreateLuaTable table = new CreateLuaTable();
            CompoundTag compoundTag = (CompoundTag)tag;
            for (String compoundKey : compoundTag.m_128431_()) {
                table.put(StringHelper.camelCaseToSnakeCase(compoundKey), StationPeripheral.fromNBTTag(compoundKey, compoundTag.m_128423_(compoundKey)));
            }
            return table;
        }
        throw new LuaException("unknown tag type " + tag.m_6458_().m_5987_());
    }

    @NotNull
    private static CompoundTag toCompoundTag(CreateLuaTable table) throws LuaException {
        return (CompoundTag)StationPeripheral.toNBTTag(null, table.getMap());
    }

    @NotNull
    private static Tag toNBTTag(@Nullable String key, Object value) throws LuaException {
        Map v;
        if (value instanceof Boolean) {
            Boolean v2 = (Boolean)value;
            return ByteTag.m_128273_((boolean)v2);
        }
        if (value instanceof Byte || key != null && key.equals("count")) {
            return ByteTag.m_128266_((byte)((Number)value).byteValue());
        }
        if (value instanceof Number) {
            Number v3 = (Number)value;
            if ((double)v3.intValue() == v3.doubleValue()) {
                return IntTag.m_128679_((int)v3.intValue());
            }
            return DoubleTag.m_128500_((double)v3.doubleValue());
        }
        if (value instanceof String) {
            String v4 = (String)value;
            return StringTag.m_129297_((String)v4);
        }
        if (value instanceof Map && (v = (Map)value).containsKey(1.0)) {
            ListTag list = new ListTag();
            for (double i = 1.0; i <= (double)v.size(); i += 1.0) {
                if (v.get(i) == null) continue;
                list.add((Object)StationPeripheral.toNBTTag(null, v.get(i)));
            }
            return list;
        }
        if (value instanceof Map) {
            Map v5 = (Map)value;
            CompoundTag compound = new CompoundTag();
            for (Object objectKey : v5.keySet()) {
                if (!(objectKey instanceof String)) {
                    throw new LuaException("table key is not of type string");
                }
                String compoundKey = (String)objectKey;
                compound.m_128365_(compoundKey.equals("id") && v5.containsKey("count") ? "id" : StringHelper.snakeCaseToCamelCase(compoundKey), StationPeripheral.toNBTTag(compoundKey, v5.get(compoundKey)));
            }
            return compound;
        }
        throw new LuaException("unknown object type " + value.getClass().getName());
    }

    @NotNull
    public String getType() {
        return "Create_Station";
    }
}

