/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DivingHelmetItem
extends BaseArmorItem {
    public static final EquipmentSlot SLOT = EquipmentSlot.HEAD;
    public static final ArmorItem.Type TYPE = ArmorItem.Type.HELMET;

    public DivingHelmetItem(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc) {
        super(material, TYPE, properties, textureLoc);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44971_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44971_) {
            return 1;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map map = super.getAllEnchantments(stack);
        map.put(Enchantments.f_44971_, 1);
        return map;
    }

    public static boolean isWornBy(Entity entity) {
        return !DivingHelmetItem.getWornItem(entity).m_41619_();
    }

    public static ItemStack getWornItem(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return ItemStack.f_41583_;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = livingEntity.m_6844_(SLOT);
        if (!(stack.m_41720_() instanceof DivingHelmetItem)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @SubscribeEvent
    public static void breatheUnderwater(LivingBreatheEvent event) {
        Player player;
        ItemStack helmet;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            entity.getPersistentData().m_128473_("VisualBacktankAir");
        }
        if ((helmet = DivingHelmetItem.getWornItem((Entity)entity)).m_41619_()) {
            return;
        }
        boolean lavaDiving = entity.m_20077_();
        if (!helmet.m_41720_().m_41475_() && lavaDiving) {
            return;
        }
        if (!entity.canDrownInFluidType(entity.getEyeInFluidType()) && !lavaDiving) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_5833_() || player.m_7500_())) {
            return;
        }
        List<ItemStack> backtanks = BacktankUtil.getAllWithAir(entity);
        if (backtanks.isEmpty()) {
            return;
        }
        if (lavaDiving) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entity;
                AllAdvancements.DIVING_SUIT_LAVA.awardTo((Player)sp);
            }
            if (backtanks.stream().noneMatch(backtank -> backtank.m_41720_().m_41475_())) {
                return;
            }
        }
        float visualBacktankAir = 0.0f;
        for (ItemStack stack : backtanks) {
            visualBacktankAir += BacktankUtil.getAir(stack);
        }
        if (level.f_46443_) {
            entity.getPersistentData().m_128405_("VisualBacktankAir", Math.round(visualBacktankAir));
        }
        if (level.m_46467_() % 20L == 0L) {
            BacktankUtil.consumeAir(entity, backtanks.get(0), 1.0f);
        }
        if (lavaDiving) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            AllAdvancements.DIVING_SUIT.awardTo((Player)sp);
        }
        event.setCanBreathe(true);
        event.setCanRefillAir(true);
    }
}

