/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.google.common.base.Objects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TrackTargetingClient {
    static BlockPos lastHovered;
    static boolean lastDirection;
    static EdgePointType<?> lastType;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static TrackTargetingBlockItem.OverlapResult lastResult;
    static TrackGraphLocation lastLocation;

    public static void clientTick() {
        boolean alreadySelected;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Vec3 lookAngle = player.m_20154_();
        BlockPos hovered = null;
        boolean direction = false;
        EdgePointType<?> type = null;
        BezierTrackPointLocation hoveredBezier = null;
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof TrackTargetingBlockItem) {
            TrackTargetingBlockItem ttbi = (TrackTargetingBlockItem)item;
            type = ttbi.getType(stack);
        }
        if (type == EdgePointType.SIGNAL) {
            Create.RAILWAYS.sided(null).tickSignalOverlay();
        }
        boolean bl = alreadySelected = stack.m_41782_() && stack.m_41783_().m_128441_("SelectedPos");
        if (type != null) {
            TrackBlockOutline.BezierPointSelection bezierSelection = TrackBlockOutline.result;
            if (alreadySelected) {
                CompoundTag tag = stack.m_41783_();
                hovered = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("SelectedPos"));
                direction = tag.m_128471_("SelectedDirection");
                if (tag.m_128441_("Bezier")) {
                    CompoundTag bezierNbt = tag.m_128469_("Bezier");
                    BlockPos key = NbtUtils.m_129239_((CompoundTag)bezierNbt.m_128469_("Key"));
                    hoveredBezier = new BezierTrackPointLocation(key, bezierNbt.m_128451_("Segment"));
                }
            } else if (bezierSelection != null) {
                hovered = bezierSelection.blockEntity().m_58899_();
                hoveredBezier = bezierSelection.loc();
                direction = lookAngle.m_82526_(bezierSelection.direction()) < 0.0;
            } else {
                BlockHitResult blockHitResult;
                BlockPos pos;
                BlockState blockState;
                Block block;
                HitResult hitResult = mc.f_91077_;
                if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK && (block = (blockState = mc.f_91073_.m_8055_(pos = (blockHitResult = (BlockHitResult)hitResult).m_82425_())).m_60734_()) instanceof ITrackBlock) {
                    ITrackBlock track = (ITrackBlock)block;
                    direction = track.getNearestTrackAxis((BlockGetter)mc.f_91073_, pos, blockState, lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
                    hovered = pos;
                }
            }
        }
        if (hovered == null) {
            lastHovered = null;
            lastResult = null;
            lastLocation = null;
            lastHoveredBezierSegment = null;
            return;
        }
        if (Objects.equal(hovered, (Object)lastHovered) && Objects.equal(hoveredBezier, (Object)lastHoveredBezierSegment) && direction == lastDirection && type == lastType) {
            return;
        }
        lastType = type;
        lastHovered = hovered;
        lastDirection = direction;
        lastHoveredBezierSegment = hoveredBezier;
        TrackTargetingBlockItem.withGraphLocation((Level)mc.f_91073_, hovered, direction, hoveredBezier, type, (result, location) -> {
            lastResult = result;
            lastLocation = location;
        });
    }

    public static void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        Direction.AxisDirection direction;
        if (lastLocation == null || TrackTargetingClient.lastResult.feedback != null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockPos pos = lastHovered;
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)pos);
        Direction.AxisDirection axisDirection = direction = lastDirection ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        TrackTargetingBehaviour.RenderedTrackOverlayType type = lastType == EdgePointType.SIGNAL ? TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL : (lastType == EdgePointType.OBSERVER ? TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER : TrackTargetingBehaviour.RenderedTrackOverlayType.STATION);
        ms.m_85836_();
        TransformStack.of((PoseStack)ms).translate(Vec3.m_82528_((Vec3i)pos).m_82546_(camera));
        TrackTargetingBehaviour.render((LevelAccessor)mc.f_91073_, pos, direction, lastHoveredBezierSegment, ms, (MultiBufferSource)buffer, light, OverlayTexture.f_118083_, type, 1.0625f);
        ms.m_85849_();
    }
}

