/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.motors.extension;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

public class MotorExtensionScrollValueBehaviour
extends ScrollValueBehaviour {
    protected int step;

    public MotorExtensionScrollValueBehaviour(Component label, SmartBlockEntity be, ValueBoxTransform slot, int step) {
        super(label, be, slot);
        this.step = step;
        this.withFormatter(v -> String.valueOf(Math.abs(v)));
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Component.m_237113_((String)"%").m_130940_(ChatFormatting.BOLD));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        this.value /= this.step;
        return new ValueSettingsBoard(this.label, this.max / this.step, 100, (List)rows, formatter);
    }

    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        int value = Math.max(1, valueSetting.value());
        if (!valueSetting.equals((Object)this.getValueSettings())) {
            this.playFeedbackSound((BlockEntityBehaviour)this);
        }
        this.setValue(value * this.step);
    }

    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(0, Math.abs(this.value));
    }

    public MutableComponent formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
        return CreateLang.number((double)Math.max(1, Math.abs(settings.value() * this.step))).add(CreateLang.text((String)"%").style(ChatFormatting.BOLD)).component();
    }

    public void betweenValidated(int min, int max) {
        this.between(min, max);
        if (this.value > max) {
            this.value = max;
        } else if (this.value < min) {
            this.value = min;
        }
    }

    public String getClipboardKey() {
        return "Stress Multiplier";
    }
}

