/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.reactor.reactorrod;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.newage.NewAgeBlockEntityTypes;
import org.antarcticgardens.newage.NewAgeBlocks;
import org.antarcticgardens.newage.content.reactor.ReactorBlock;
import org.antarcticgardens.newage.content.reactor.reactorrod.ReactorRodBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorRodBlock
extends ReactorBlock
implements EntityBlock {
    protected static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)4.5, (double)4.5, (double)0.0, (double)11.5, (double)11.5, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)4.5, (double)4.5, (double)16.0, (double)11.5, (double)11.5);
    public static final BooleanProperty ACTIVE = BlockStateProperties.f_61443_;
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.m_61587_((String)"axis", Direction.Axis.class);

    public ReactorRodBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60971_((blockState, blockGetter, blockPos) -> false).m_60953_(state -> (Boolean)state.m_61143_((Property)ACTIVE) != false ? 12 : 0));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_());
    }

    public VoxelShape m_5940_(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return switch ((Direction.Axis)arg.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
        };
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            level.m_7731_(pos, NewAgeBlocks.CORIUM.getDefaultState(), 3);
            if (level instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                lvl.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.0f, true, Level.ExplosionInteraction.TNT);
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? new ArrayList() : super.m_49635_(state, params);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            return InteractionResult.PASS;
        }
        return super.onSneakWrenched(state, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE}).m_61104_(new Property[]{AXIS});
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return NewAgeBlockEntityTypes.REACTOR_ROD.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState, blockEntity) -> {
            if (!(blockEntity instanceof ReactorRodBlockEntity)) {
                return;
            }
            ReactorRodBlockEntity ent = (ReactorRodBlockEntity)blockEntity;
            ent.tick(blockPos, level1, blockState);
        };
    }
}

