/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.TubeBlockEntity;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HypertubeBlockEntity
extends TubeBlockEntity {
    private IConnection connectionOne;
    private IConnection connectionTwo;

    public HypertubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("ConnectionTo")) {
            this.connectionOne = this.getConnection(compound, "ConnectionTo");
        }
        if (compound.m_128441_("ConnectionFrom")) {
            this.connectionTwo = this.getConnection(compound, "ConnectionFrom");
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeConnection(compound, new Tuple[]{new Tuple((Object)this.connectionOne, (Object)"ConnectionTo"), new Tuple((Object)this.connectionTwo, (Object)"ConnectionFrom")});
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            if (this.connectionOne != null) {
                this.connectionOne.updateTubeSegments(this.f_58857_);
            }
            if (this.connectionTwo != null) {
                this.connectionTwo.updateTubeSegments(this.f_58857_);
            }
            return true;
        }
        connectionInDirection.updateTubeSegments(this.f_58857_);
        return true;
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connectionOne != null) {
            connections.add(this.connectionOne);
        }
        if (this.connectionTwo != null) {
            connections.add(this.connectionTwo);
        }
        return connections;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        BlockState blockState;
        Block block;
        if (this.connectionOne == null) {
            this.connectionOne = connection;
        } else if (this.connectionTwo == null) {
            this.connectionTwo = connection;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (block = (blockState = this.f_58857_.m_8055_(this.f_58858_)).m_60734_()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.f_58857_, this.f_58858_);
            if (thisConnectionDir != null) {
                BlockState state = hypertubeBlock.getState(blockState, List.of(thisConnectionDir), true);
                hypertubeBlock.updateBlockState(this.f_58857_, this.f_58858_, state);
            }
        }
        this.m_6596_();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        BlockState blockState;
        Block block;
        if (this.connectionOne != null && this.connectionOne.isSameConnection(connection)) {
            this.connectionOne = null;
        } else if (this.connectionTwo != null && this.connectionTwo.isSameConnection(connection)) {
            this.connectionTwo = null;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (block = (blockState = this.f_58857_.m_8055_(this.f_58858_)).m_60734_()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.f_58857_, this.f_58858_);
        }
        this.m_6596_();
        this.sync();
    }

    @Override
    protected int getConnectionCount() {
        return 2;
    }

    @Override
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(512.0);
    }

    public IConnection getConnectionOne() {
        return this.connectionOne;
    }

    public IConnection getConnectionTwo() {
        return this.connectionTwo;
    }
}

