/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.mixin.core;

import com.pedrorok.hypertube.config.ClientConfig;
import com.pedrorok.hypertube.core.camera.DetachedCameraController;
import com.pedrorok.hypertube.core.camera.DetachedPlayerDirController;
import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.mixin.core.CameraAccessorMixin;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public class CameraMixin {
    @Shadow
    private boolean f_90560_;
    @Shadow
    private Entity f_90551_;
    @Unique
    private long createHypertube$lastTickTime = 0L;
    @Unique
    private static final long createHypertube$TICK_INTERVAL_NS = 16666666L;

    @Unique
    public void createHypertube$setDetachedExternal(boolean newDetached) {
        this.f_90560_ = newDetached;
    }

    @Inject(method={"setup"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetup(BlockGetter p_90576_, Entity renderViewEntity, boolean isFrontView, boolean flipped, float PartialTicks, CallbackInfo ci) {
        long currentTime;
        boolean hasHypertubeData;
        Options options = Minecraft.m_91087_().f_91066_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (renderViewEntity != player) {
            return;
        }
        boolean bl = hasHypertubeData = !TravelManager.hasHyperTubeData(renderViewEntity);
        if (hasHypertubeData || options.m_92176_().m_90612_() && ((Boolean)ClientConfig.get().ALLOW_FPV_INSIDE_TUBE.get()).booleanValue()) {
            DetachedCameraController.get().setDetached(false);
            if (hasHypertubeData) {
                DetachedPlayerDirController.get().setDetached(false);
            }
            return;
        }
        if (!((Boolean)ClientConfig.get().ALLOW_FPV_INSIDE_TUBE.get()).booleanValue()) {
            options.m_92157_(CameraType.THIRD_PERSON_BACK);
        }
        Camera cameraObj = (Camera)this;
        CameraAccessorMixin camera = (CameraAccessorMixin)cameraObj;
        if (!DetachedCameraController.get().isDetached()) {
            DetachedCameraController.get().startCamera(renderViewEntity);
            DetachedCameraController.get().setDetached(true);
            this.createHypertube$setDetachedExternal(true);
        }
        if ((currentTime = System.nanoTime()) - this.createHypertube$lastTickTime >= 16666666L) {
            DetachedCameraController.get().tickCamera(renderViewEntity);
            this.createHypertube$lastTickTime = currentTime;
        }
        camera.callSetRotation(DetachedCameraController.get().getYaw() * (float)(flipped ? -1 : 1), DetachedCameraController.get().getPitch());
        camera.callSetPosition(Mth.m_14139_((double)PartialTicks, (double)renderViewEntity.f_19854_, (double)renderViewEntity.m_20185_()), Mth.m_14139_((double)PartialTicks, (double)renderViewEntity.f_19855_, (double)renderViewEntity.m_20186_()), Mth.m_14139_((double)PartialTicks, (double)renderViewEntity.f_19856_, (double)renderViewEntity.m_20189_()));
        camera.callMove(-camera.callGetMaxZoom(4.0), 0.0, 0.0);
        ci.cancel();
    }
}

