/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_loading;

import com.simibubi.create.AllContraptionTypes;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.Contraption;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import rbasamoyai.createbigcannons.cannon_loading.CanLoadBigCannon;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;
import rbasamoyai.createbigcannons.remix.HasFragileContraption;

public class CBCModifiedContraptionRegistry {
    private static final ReferenceOpenHashSet<ContraptionType> CANNON_LOADER_TYPES = new ReferenceOpenHashSet();
    private static final ReferenceOpenHashSet<ContraptionType> FRAGILE_TYPES = new ReferenceOpenHashSet();

    public static void registerCannonLoaderType(ContraptionType type) {
        if (CANNON_LOADER_TYPES.contains((Object)type)) {
            throw new IllegalStateException("Already registered big cannon loader contraption type");
        }
        CANNON_LOADER_TYPES.add((Object)type);
    }

    public static void registerFragileType(ContraptionType type) {
        if (FRAGILE_TYPES.contains((Object)type)) {
            throw new IllegalStateException("Already registered fragile contraption type");
        }
        FRAGILE_TYPES.add((Object)type);
    }

    public static boolean canLoadBigCannon(Contraption contraption) {
        return CANNON_LOADER_TYPES.contains((Object)contraption.getType()) && contraption instanceof CanLoadBigCannon;
    }

    public static boolean isFragileContraption(Contraption contraption) {
        return FRAGILE_TYPES.contains((Object)contraption.getType()) && contraption instanceof HasFragileContraption;
    }

    public static void registerDefaults() {
        CBCModifiedContraptionRegistry.registerCannonLoaderType((ContraptionType)CBCContraptionTypes.CANNON_LOADER.m_203334_());
        CBCModifiedContraptionRegistry.registerCannonLoaderType((ContraptionType)AllContraptionTypes.PISTON.m_203334_());
        CBCModifiedContraptionRegistry.registerCannonLoaderType((ContraptionType)AllContraptionTypes.GANTRY.m_203334_());
        CBCModifiedContraptionRegistry.registerCannonLoaderType((ContraptionType)AllContraptionTypes.PULLEY.m_203334_());
        CBCModifiedContraptionRegistry.registerFragileType((ContraptionType)CBCContraptionTypes.CANNON_LOADER.m_203334_());
        CBCModifiedContraptionRegistry.registerFragileType((ContraptionType)AllContraptionTypes.PISTON.m_203334_());
        CBCModifiedContraptionRegistry.registerFragileType((ContraptionType)AllContraptionTypes.GANTRY.m_203334_());
        CBCModifiedContraptionRegistry.registerFragileType((ContraptionType)AllContraptionTypes.PULLEY.m_203334_());
    }
}

