/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.material;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import rbasamoyai.createbigcannons.CreateBigCannons;

public record BigCannonMaterialProperties(double minimumVelocityPerBarrel, float weight, int maxSafePropellantStress, FailureMode failureMode, boolean connectsInSurvival, boolean isWeldable, int weldDamage, int weldStressPenalty, float minimumSpread, float spreadReductionPerBarrel) {
    public BigCannonMaterialProperties {
        Objects.requireNonNull(failureMode, "property :failureMode is required");
    }

    public boolean mayGetStuck(float chargesUsed, int barrelTravelled) {
        if (this.minimumVelocityPerBarrel < 0.0) {
            return true;
        }
        if (barrelTravelled < 1) {
            return false;
        }
        return this.minimumVelocityPerBarrel > (double)(chargesUsed / (float)barrelTravelled);
    }

    public static BigCannonMaterialProperties fromJson(ResourceLocation id, JsonObject obj) {
        double minimumVelocityPerBarrel = GsonHelper.m_144742_((JsonObject)obj, (String)"minimum_velocity_per_barrel", (double)1.0);
        if (GsonHelper.m_144762_((JsonObject)obj, (String)"squib_ratio_barrels") && GsonHelper.m_144762_((JsonObject)obj, (String)"squib_ratio_propellant")) {
            float ratio;
            float barrels = GsonHelper.m_13927_((JsonObject)obj, (String)"squib_ratio_barrels");
            float propellant = GsonHelper.m_13927_((JsonObject)obj, (String)"squib_ratio_propellant");
            float f = ratio = propellant <= 0.0f ? -1.0f : barrels / propellant;
            if (ratio < 0.0f) {
                ratio = -1.0f;
            }
            CreateBigCannons.LOGGER.warn("Legacy values \"squib_ratio_barrels\" and \"squib_ratio_propellant\" found in config for {}, please change to \"max_safe_propellant_stress\". Recommended value: {}", (Object)id, (Object)String.format(".%2f", Float.valueOf(ratio)));
            if (!GsonHelper.m_144762_((JsonObject)obj, (String)"minimum_velocity_per_barrel")) {
                minimumVelocityPerBarrel = ratio;
            }
        }
        minimumVelocityPerBarrel = Math.max(-1.0, minimumVelocityPerBarrel);
        float weight = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"weight", (float)2.0f));
        int maxSafeBaseCharges = GsonHelper.m_13824_((JsonObject)obj, (String)"max_safe_propellant_stress", (int)2);
        if (GsonHelper.m_144762_((JsonObject)obj, (String)"max_safe_charges")) {
            CreateBigCannons.LOGGER.warn("Legacy value \"max_safe_charges\" found in config for {}, please change to \"max_safe_propellant_stress\"", (Object)id);
            if (!GsonHelper.m_144762_((JsonObject)obj, (String)"max_safe_propellant_stress")) {
                maxSafeBaseCharges = GsonHelper.m_13927_((JsonObject)obj, (String)"max_safe_charges");
            }
        }
        maxSafeBaseCharges = Math.max(0, maxSafeBaseCharges);
        FailureMode failureMode = FailureMode.byId(GsonHelper.m_13906_((JsonObject)obj, (String)"failure_mode"));
        boolean connectsInSurvival = GsonHelper.m_13855_((JsonObject)obj, (String)"connects_in_survival", (boolean)false);
        boolean isWeldable = GsonHelper.m_13855_((JsonObject)obj, (String)"is_weldable", (boolean)false);
        int weldDamage = Math.max(GsonHelper.m_13824_((JsonObject)obj, (String)"weld_damage", (int)0), 0);
        int weldStressPenalty = Math.max(GsonHelper.m_13824_((JsonObject)obj, (String)"weld_stress_penalty", (int)0), 0);
        float minimumSpread = Math.max(GsonHelper.m_13820_((JsonObject)obj, (String)"minimum_spread", (float)0.05f), 0.0f);
        float spreadReductionPerBarrel = Math.max(GsonHelper.m_13820_((JsonObject)obj, (String)"spread_reduction_per_barrel", (float)1.0f), 0.0f);
        return new BigCannonMaterialProperties(minimumVelocityPerBarrel, weight, maxSafeBaseCharges, failureMode, connectsInSurvival, isWeldable, weldDamage, weldStressPenalty, minimumSpread, spreadReductionPerBarrel);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("minimum_velocity_per_barrel", (Number)this.minimumVelocityPerBarrel);
        obj.addProperty("weight", (Number)Float.valueOf(this.weight));
        obj.addProperty("max_safe_propellant_stress", (Number)this.maxSafePropellantStress);
        obj.addProperty("failure_mode", this.failureMode.toString());
        obj.addProperty("connects_in_survival", Boolean.valueOf(this.connectsInSurvival));
        obj.addProperty("is_weldable", Boolean.valueOf(this.isWeldable));
        obj.addProperty("weld_damage", (Number)this.weldDamage);
        obj.addProperty("weld_stress_penalty", (Number)this.weldStressPenalty);
        obj.addProperty("minimum_spread", (Number)Float.valueOf(this.minimumSpread));
        obj.addProperty("spread_reduction_per_barrel", (Number)Float.valueOf(this.spreadReductionPerBarrel));
        return obj;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeDouble(this.minimumVelocityPerBarrel).writeFloat(this.weight);
        buf.m_130130_(this.maxSafePropellantStress).m_130130_(this.failureMode.ordinal()).writeBoolean(this.connectsInSurvival).writeBoolean(this.isWeldable);
        buf.m_130130_(this.weldDamage).m_130130_(this.weldStressPenalty).writeFloat(this.minimumSpread).writeFloat(this.spreadReductionPerBarrel);
    }

    public static BigCannonMaterialProperties fromBuf(FriendlyByteBuf buf) {
        double minimumVelocityPerBarrel = buf.readDouble();
        float weight = buf.readFloat();
        int maxSafeBaseCharges = buf.m_130242_();
        FailureMode mode = FailureMode.values()[buf.m_130242_()];
        boolean connectsInSurvival = buf.readBoolean();
        boolean isWeldable = buf.readBoolean();
        int weldDamage = buf.m_130242_();
        int weldStressPenalty = buf.m_130242_();
        float minimumSpread = buf.readFloat();
        float spreadReductionPerBarrel = buf.readFloat();
        return new BigCannonMaterialProperties(minimumVelocityPerBarrel, weight, maxSafeBaseCharges, mode, connectsInSurvival, isWeldable, weldDamage, weldStressPenalty, minimumSpread, spreadReductionPerBarrel);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum FailureMode implements StringRepresentable
    {
        RUPTURE,
        FRAGMENT;

        private static final Map<String, FailureMode> BY_ID;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.name;
        }

        public static FailureMode byId(String id) {
            return BY_ID.getOrDefault(id, RUPTURE);
        }

        static {
            BY_ID = Arrays.stream(FailureMode.values()).collect(Collectors.toMap(StringRepresentable::m_7912_, Function.identity()));
        }
    }

    public static final class Builder {
        private double minimumVelocityPerBarrel;
        private float weight;
        private int maxSafePropellantStress;
        private FailureMode failureMode = FailureMode.FRAGMENT;
        private boolean connectsInSurvival;
        private boolean isWeldable;
        private int weldDamage;
        private int weldStressPenalty;
        private float minimumSpread;
        private float spreadReductionPerBarrel;

        private Builder() {
        }

        public Builder minimumVelocityPerBarrel(double minimumVelocityPerBarrel) {
            this.minimumVelocityPerBarrel = minimumVelocityPerBarrel;
            return this;
        }

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        public Builder maxSafePropellantStress(int maxSafePropellantStress) {
            this.maxSafePropellantStress = maxSafePropellantStress;
            return this;
        }

        public Builder failureMode(FailureMode failureMode) {
            this.failureMode = Objects.requireNonNull(failureMode, "Null failureMode");
            return this;
        }

        public Builder connectsInSurvival(boolean connectsInSurvival) {
            this.connectsInSurvival = connectsInSurvival;
            return this;
        }

        public Builder isWeldable(boolean isWeldable) {
            this.isWeldable = isWeldable;
            return this;
        }

        public Builder weldDamage(int weldDamage) {
            this.weldDamage = weldDamage;
            return this;
        }

        public Builder weldStressPenalty(int weldStressPenalty) {
            this.weldStressPenalty = weldStressPenalty;
            return this;
        }

        public Builder minimumSpread(float minimumSpread) {
            this.minimumSpread = minimumSpread;
            return this;
        }

        public Builder spreadReductionPerBarrel(float spreadReductionPerBarrel) {
            this.spreadReductionPerBarrel = spreadReductionPerBarrel;
            return this;
        }

        public BigCannonMaterialProperties build() {
            if (this.failureMode == null) {
                throw new IllegalStateException("Missing required property: failureMode");
            }
            return new BigCannonMaterialProperties(this.minimumVelocityPerBarrel, this.weight, this.maxSafePropellantStress, this.failureMode, this.connectsInSurvival, this.isWeldable, this.weldDamage, this.weldStressPenalty, this.minimumSpread, this.spreadReductionPerBarrel);
        }
    }
}

