/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.compat.kubejs.GetChunkOilAmountEventJS;
import com.jesz.createdieselgenerators.compat.kubejs.LighterSkinsEventJS;
import com.jesz.createdieselgenerators.compat.kubejs.MoldEventJS;
import com.jesz.createdieselgenerators.content.tools.lighter.LighterModel;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ClassFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;

public class CDGKubeJSPlugin
extends KubeJSPlugin {
    public static EventGroup GROUP = EventGroup.of((String)"CDGEvents");
    public static EventHandler MOLDS = GROUP.startup("molds", () -> MoldEventJS.class);
    public static EventHandler OIL_CHUNKS = GROUP.server("oilAmount", () -> GetChunkOilAmountEventJS.class);
    public static EventHandler LIGHTER_SKINS = GROUP.client("lighterSkins", () -> LighterSkinsEventJS.class);

    public void registerEvents() {
        GROUP.register();
    }

    public void registerClasses(ScriptType type, ClassFilter filter) {
        filter.allow("com.jesz.createdieselgenerators");
        filter.deny("com.jesz.createdieselgenerators.mixins");
        filter.deny(CDGKubeJSPlugin.class);
    }

    public static void registerMolds() {
        MoldEventJS event = new MoldEventJS();
        MOLDS.post((EventJS)event);
    }

    public void initStartup() {
        CDGKubeJSPlugin.registerMolds();
    }

    public static int calculateOilChunks(List<Holder<Biome>> biomes, ChunkPos chunkPos, long seed) {
        if (!OIL_CHUNKS.hasListeners()) {
            return -1;
        }
        GetChunkOilAmountEventJS event = new GetChunkOilAmountEventJS();
        event.chunkPos = chunkPos;
        event.seed = seed;
        String[] stringBiomes = new String[biomes.size()];
        for (int i = 0; i < stringBiomes.length; ++i) {
            stringBiomes[i] = biomes.stream().map(b -> ((Holder.Reference)b).m_205785_().m_135782_().toString()).toList().get(i);
        }
        event.biomes = stringBiomes;
        return ((Double)OIL_CHUNKS.post((EventJS)event).value()).intValue();
    }

    public static void registerLighterSkins() {
        LighterSkinsEventJS event = new LighterSkinsEventJS();
        LIGHTER_SKINS.post((EventJS)event);
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        CDGKubeJSPlugin.registerLighterSkins();
        MoldEventJS.addedMolds.forEach((rl, name) -> generator.json(new ResourceLocation(rl.m_135827_(), "models/item/mold/" + rl.m_135815_()), this.generateTextureModel(new ResourceLocation(rl.m_135827_(), "item/mold/" + rl.m_135815_()))));
        LighterSkinsEventJS.addedIds.forEach((name, id) -> {
            generator.json(CreateDieselGenerators.rl("models/item/lighter/" + id), this.generateLighterSkinModel((String)id, LighterModel.LighterState.CLOSED));
            generator.json(CreateDieselGenerators.rl("models/item/lighter/" + id + "_open"), this.generateLighterSkinModel((String)id, LighterModel.LighterState.OPEN));
            generator.json(CreateDieselGenerators.rl("models/item/lighter/" + id + "_ignited"), this.generateLighterSkinModel((String)id, LighterModel.LighterState.IGNITED));
        });
    }

    public void generateLang(LangEventJS event) {
        MoldEventJS.addedMolds.forEach((rl, name) -> event.add("mold." + rl.m_135827_() + "." + rl.m_135815_(), name));
    }

    JsonElement generateTextureModel(ResourceLocation rl) {
        JsonObject object = new JsonObject();
        object.add("parent", (JsonElement)new JsonPrimitive("minecraft:item/generated"));
        JsonObject texturesObject = new JsonObject();
        texturesObject.add("layer0", (JsonElement)new JsonPrimitive(rl.toString()));
        object.add("textures", (JsonElement)texturesObject);
        return object;
    }

    JsonElement generateLighterSkinModel(String id, LighterModel.LighterState state) {
        JsonObject object = new JsonObject();
        object.add("parent", (JsonElement)new JsonPrimitive("minecraft:item/generated"));
        JsonObject texturesObject = new JsonObject();
        texturesObject.add("layer0", (JsonElement)new JsonPrimitive("kubejs:item/lighter/" + id + state.getSuffix()));
        object.add("textures", (JsonElement)texturesObject);
        return object;
    }

    static {
        OIL_CHUNKS.hasResult();
    }
}

