/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.entity_filter.ReverseLootTable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;

public interface EntityAttribute {
    public static final List<EntityAttribute> all = new LinkedList<EntityAttribute>();
    public static final EntityAttribute STANDARD_TRAITS = EntityAttribute.register(StandardTraits.IS_HOSTILE);
    public static final EntityAttribute IS_MOB = EntityAttribute.register(new IsMob(EntityType.f_20510_));

    public static EntityAttribute register(EntityAttribute attribute) {
        all.add(attribute);
        return attribute;
    }

    public static EntityAttribute fromNBT(CompoundTag compound) {
        for (EntityAttribute attribute : all) {
            EntityAttribute finalAttribute = attribute.getById(new ResourceLocation(compound.m_128461_("Id")));
            if (finalAttribute == null) continue;
            return finalAttribute.read(compound);
        }
        return null;
    }

    default public EntityAttribute getById(ResourceLocation id) {
        return id.equals((Object)this.getId()) ? this : null;
    }

    public ResourceLocation getId();

    public boolean test(Entity var1);

    public EntityAttribute read(CompoundTag var1);

    default public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Id", this.getId().toString());
        return tag;
    }

    public List<EntityAttribute> listAttributesOf(ItemStack var1);

    public boolean appliesTo(ItemStack var1);

    public Component format(boolean var1);

    default public EntityAttribute register() {
        all.add(this);
        return this;
    }

    public static List<EntityType<?>> getAllEntityTypesFromStack(ItemStack stack) {
        LinkedList list = new LinkedList();
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem item2 = (SpawnEggItem)item;
            list.add(item2.m_43228_(stack.m_41783_()));
        }
        ForgeRegistries.ENTITY_TYPES.getKeys().forEach(k -> {
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(k);
        });
        for (Map.Entry<Item, List<EntityType<?>>> entry : ReverseLootTable.ALL.entrySet()) {
            if (entry.getKey() != stack.m_41720_()) continue;
            list.addAll((Collection)entry.getValue());
        }
        return list;
    }

    public static enum StandardTraits implements EntityAttribute
    {
        IS_HOSTILE(e -> e instanceof Monster, stack -> {
            boolean hostile = false;
            for (EntityType<?> type : EntityAttribute.getAllEntityTypesFromStack(stack)) {
                if (type.m_20674_() != MobCategory.MONSTER) continue;
                hostile = true;
            }
            return hostile;
        });

        Predicate<ItemStack> itemTest;
        Predicate<Entity> test;

        private StandardTraits(Predicate<Entity> test, Predicate<ItemStack> itemTest) {
            this.test = test;
            this.itemTest = itemTest;
        }

        @Override
        public ResourceLocation getId() {
            return CreateDieselGenerators.rl(this.name().toLowerCase(Locale.ROOT));
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.itemTest.test(stack);
        }

        @Override
        public boolean test(Entity entity) {
            return this.test.test(entity);
        }

        @Override
        public CompoundTag write() {
            CompoundTag tag = EntityAttribute.super.write();
            tag.m_128359_("TraitType", this.getId().toString());
            return tag;
        }

        @Override
        public EntityAttribute read(CompoundTag tag) {
            StandardTraits attribute = null;
            for (StandardTraits possibleAttribute : StandardTraits.values()) {
                if (!possibleAttribute.getId().toString().equals(tag.m_128461_("TraitType"))) continue;
                attribute = possibleAttribute;
            }
            return attribute;
        }

        @Override
        public List<EntityAttribute> listAttributesOf(ItemStack stack) {
            LinkedList<EntityAttribute> attributes = new LinkedList<EntityAttribute>();
            for (StandardTraits attribute : StandardTraits.values()) {
                if (!attribute.itemTest.test(stack)) continue;
                attributes.add(attribute);
            }
            return attributes;
        }

        @Override
        public EntityAttribute getById(ResourceLocation id) {
            for (StandardTraits attribute : StandardTraits.values()) {
                if (!attribute.getId().equals((Object)id)) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public Component format(boolean inverted) {
            return CreateDieselGenerators.lang("entity_attributes." + this.getId().m_135815_() + (inverted ? ".inverted" : ""), new Object[0]);
        }
    }

    public static class IsMob
    implements EntityAttribute {
        EntityType<?> type;

        public IsMob(EntityType<?> type) {
            this.type = type;
        }

        @Override
        public ResourceLocation getId() {
            return CreateDieselGenerators.rl("is_mob");
        }

        @Override
        public boolean test(Entity entity) {
            return entity.m_6095_() == this.type;
        }

        @Override
        public CompoundTag write() {
            CompoundTag tag = EntityAttribute.super.write();
            tag.m_128359_("Entity", ForgeRegistries.ENTITY_TYPES.getKey(this.type).toString());
            return tag;
        }

        @Override
        public EntityAttribute read(CompoundTag tag) {
            return new IsMob((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(tag.m_128461_("Entity"))));
        }

        @Override
        public List<EntityAttribute> listAttributesOf(ItemStack stack) {
            LinkedList<EntityAttribute> attributes = new LinkedList<EntityAttribute>();
            for (EntityType<?> type : EntityAttribute.getAllEntityTypesFromStack(stack)) {
                attributes.add(new IsMob(type));
            }
            return attributes;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return !EntityAttribute.getAllEntityTypesFromStack(stack).isEmpty();
        }

        @Override
        public Component format(boolean inverted) {
            return CreateDieselGenerators.lang("entity_attributes.is_mob" + (inverted ? ".inverted" : ""), this.type.m_20676_());
        }
    }
}

