/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal.common.item;

import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.chaolux.createterminal.common.menu.RemoteStockKeeperMenu;
import net.chaolux.createterminal.common.network.SyncAdvancementPacket;
import net.chaolux.createterminal.common.utility.StyleUtils;
import net.chaolux.createterminal.registry.network.ModNetwork;
import net.chaolux.createterminal.registry.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class AdvancedRemoteTerminalItem
extends Item {
    private static final int MAX_TERMINALS = 25;

    public AdvancedRemoteTerminalItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    private static int getMaxTerminals(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return 25 + tag.m_128451_("expand") * 10;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.m_43725_();
        BlockEntity be = level.m_7702_(pos = ctx.m_8083_());
        if (!(be instanceof StockTickerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.m_43722_();
        CompoundTag tag = stack.m_41784_();
        ListTag posList = tag.m_128437_("terminals", 4);
        ListTag dimList = tag.m_128437_("dims", 8);
        if (!tag.m_128441_("style")) {
            AdvancedRemoteTerminalItem.setStyle(stack, "blaze");
        }
        long newPosLong = pos.m_121878_();
        String newDim = level.m_46472_().m_135782_().toString();
        for (int i = 0; i < posList.size(); ++i) {
            long existing = ((LongTag)posList.get(i)).m_7046_();
            String dimStr = dimList.m_128778_(i);
            if (existing != newPosLong || !dimStr.equals(newDim)) continue;
            ctx.m_43725_().m_5594_(null, pos, (SoundEvent)ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            ctx.m_43723_().m_5661_((Component)Component.m_237115_((String)"tooltip.createterminal.bound_existing"), true);
            return InteractionResult.FAIL;
        }
        if (posList.size() >= AdvancedRemoteTerminalItem.getMaxTerminals(stack)) {
            ctx.m_43725_().m_5594_(null, pos, (SoundEvent)ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            ctx.m_43723_().m_5661_((Component)Component.m_237115_((String)"tooltip.createterminal.limit"), true);
            return InteractionResult.FAIL;
        }
        posList.add((Object)LongTag.m_128882_((long)newPosLong));
        dimList.add((Object)StringTag.m_129297_((String)newDim));
        tag.m_128365_("terminals", (Tag)posList);
        tag.m_128365_("dims", (Tag)dimList);
        ctx.m_43725_().m_5594_(null, pos, (SoundEvent)ModSounds.TERMINAL_ON.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        ctx.m_43723_().m_5661_((Component)Component.m_237110_((String)"tooltip.createterminal.bound_success", (Object[])new Object[]{pos.m_123344_()}), true);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("terminals") || !tag.m_128441_("dims")) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.createterminal.not_bound"), true);
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ListTag posList = tag.m_128437_("terminals", 4);
        ListTag dimList = tag.m_128437_("dims", 8);
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        for (int i = 0; i < posList.size(); ++i) {
            long raw = ((LongTag)posList.get(i)).m_7046_();
            BlockPos pos = BlockPos.m_122022_((long)raw);
            String dimStr = dimList.m_128778_(i);
            ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimStr));
            if (!level.m_46472_().equals((Object)dimKey)) continue;
            validPos.add(pos);
        }
        validPos.sort(Comparator.comparingDouble(p -> player.m_20183_().m_123331_((Vec3i)p)));
        BlockPos bestPos = null;
        for (BlockPos pos : validPos) {
            BlockEntity be;
            if (!level.m_46805_(pos) || !((be = level.m_7702_(pos)) instanceof StockTickerBlockEntity) || !level.m_8055_(pos).m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("create", "stock_ticker")))) continue;
            bestPos = pos;
            break;
        }
        if (bestPos == null) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.createterminal.lost"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        boolean unlock = StyleUtils.hasAdvancement((ServerPlayer)player, new ResourceLocation("minecraft:end/kill_dragon"));
        ModNetwork.sendToClient((ServerPlayer)player, new SyncAdvancementPacket(unlock));
        MenuType menuType = (MenuType)ForgeRegistries.MENU_TYPES.getValue(new ResourceLocation("create", "stock_keeper_request"));
        if (menuType == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockEntity blockEntity = level.m_7702_(bestPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.createterminal.lost"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        StockTickerBlockEntity stock = (StockTickerBlockEntity)blockEntity;
        MenuType finalMenuType = menuType;
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, ply) -> new RemoteStockKeeperMenu(finalMenuType, id, inv, stock), (Component)Component.m_237113_((String)"Stock Keeper"));
        BlockPos finalBestPos = bestPos;
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, data -> {
            data.writeBoolean(false);
            data.writeBoolean(false);
            data.m_130064_(finalBestPos);
        });
        player.m_5661_((Component)Component.m_237110_((String)"tooltip.createterminal.connected", (Object[])new Object[]{bestPos.m_123344_()}), true);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("terminals")) {
            ListTag posList = tag.m_128437_("terminals", 4);
            tooltip.add((Component)Component.m_237115_((String)"tooltip.createterminal.header").m_130940_(ChatFormatting.DARK_GRAY));
            int show = 0;
            boolean showAll = Screen.m_96638_();
            for (int i = 0; i < posList.size(); ++i) {
                if (show >= 5 && !showAll) {
                    tooltip.add(StyleUtils.styleBracket((Component)Component.m_237110_((String)"tooltip.createterminal.more", (Object[])new Object[]{posList.size() - show}).m_130940_(ChatFormatting.DARK_GRAY)));
                    break;
                }
                long raw = ((LongTag)posList.get(i)).m_7046_();
                BlockPos pos = BlockPos.m_122022_((long)raw);
                tooltip.add((Component)Component.m_237110_((String)"tooltip.createterminal.bound", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.GRAY));
                ++show;
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.createterminal.not_bound").m_130940_(ChatFormatting.DARK_GRAY));
        }
        boolean showExpand = Screen.m_96639_();
        if (showExpand) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.createterminal.expand", (Object[])new Object[]{AdvancedRemoteTerminalItem.getMaxTerminals(stack)}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(StyleUtils.styleBracket((Component)Component.m_237115_((String)"tooltip.createterminal.ctrl_more").m_130940_(ChatFormatting.DARK_GRAY)));
        }
        tooltip.add(StyleUtils.styleBracket((Component)Component.m_237115_((String)"tooltip.createterminal.style").m_130940_(ChatFormatting.GRAY)));
    }

    public static void setStyle(ItemStack stack, String style) {
        CompoundTag styles = stack.m_41784_();
        styles.m_128359_("style", style);
    }
}

