/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal.data.recipe;

import net.chaolux.createterminal.registry.item.ModItems;
import net.chaolux.createterminal.registry.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AdvancedRemoteTerminalRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    private final CraftingBookCategory category;
    private final Ingredient terminal;
    private final Ingredient core;
    private final ItemStack result;

    public AdvancedRemoteTerminalRecipe(ResourceLocation id, CraftingBookCategory category) {
        this.id = id;
        this.category = category;
        this.terminal = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ADVANCED_REMOTE_TERMINAL.get()});
        this.core = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MEMORY_CORE.get()});
        this.result = new ItemStack((ItemLike)ModItems.ADVANCED_REMOTE_TERMINAL.get());
    }

    public boolean matches(CraftingContainer inv, Level level) {
        int hasTerminal = 0;
        int hasCore = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.terminal.test(stack)) {
                ++hasTerminal;
                continue;
            }
            if (this.core.test(stack)) {
                ++hasCore;
                continue;
            }
            return false;
        }
        return hasTerminal == 1 && hasCore == 1;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack terminalItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!this.terminal.test(stack)) continue;
            terminalItem = stack;
            break;
        }
        if (terminalItem.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = terminalItem.m_41777_();
        CompoundTag tag = result.m_41784_();
        tag.m_128405_("expand", tag.m_128451_("expand") + 1);
        return result;
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= 2;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.TERMINAL_EXPAND_SERIALIZER.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.terminal);
        ingredients.add((Object)this.core);
        return ingredients;
    }

    public boolean m_5598_() {
        return true;
    }

    public CraftingBookCategory m_245232_() {
        return this.category;
    }
}

