/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.azure.doom.MCDoom;
import mod.azure.doom.client.gui.GunTableScreenHandler;
import mod.azure.doom.platform.Services;
import mod.azure.doom.recipes.GunTableRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GunTableScreen
extends AbstractContainerScreen<GunTableScreenHandler> {
    private static final ResourceLocation TEXTURE = MCDoom.modResource("textures/gui/gun_table_gui.png");
    private final WidgetButtonPage[] offers = new WidgetButtonPage[7];
    private int selectedIndex;
    private int indexStartOffset;
    private boolean scrolling;

    public GunTableScreen(GunTableScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 300;
        this.f_97730_ = 107;
    }

    private void syncRecipeIndex() {
        ((GunTableScreenHandler)this.f_97732_).setRecipeIndex(this.selectedIndex);
        ((GunTableScreenHandler)this.f_97732_).switchTo(this.selectedIndex);
        Services.NETWORK.sendCraftingPacket(this.selectedIndex);
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int k = j + 18;
        for (int l = 0; l < 7; ++l) {
            this.offers[l] = (WidgetButtonPage)this.m_142416_((GuiEventListener)new WidgetButtonPage(i, k, l, button -> {
                if (button instanceof WidgetButtonPage) {
                    WidgetButtonPage widgetButtonPage = (WidgetButtonPage)button;
                    this.selectedIndex = widgetButtonPage.getIndex() + this.indexStartOffset;
                    this.syncRecipeIndex();
                }
            }));
            k += 20;
        }
    }

    protected void m_280003_(GuiGraphics matrices, int mouseX, int mouseY) {
        matrices.m_280614_(this.f_96547_, this.f_96539_, 75 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int i = (this.f_96543_ - this.f_97726_) / 2 - 5;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrices.m_280398_(TEXTURE, i, j, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
    }

    private void renderScrollbar(GuiGraphics matrices, int x, int y, List<GunTableRecipe> tradeOffers) {
        int i = tradeOffers.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int m = Math.min(113, this.indexStartOffset * k);
            if (this.indexStartOffset == i - 1) {
                m = 113;
            }
            matrices.m_280398_(TEXTURE, x + 113, y + 18 + m, 0, 0.0f, 199.0f, 6, 27, 512, 256);
        } else {
            matrices.m_280398_(TEXTURE, x + 113, y + 18, 0, 6.0f, 199.0f, 6, 27, 512, 256);
        }
    }

    public void m_88315_(@NotNull GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.m_280273_(matrices);
        super.m_88315_(matrices, mouseX, mouseY, delta);
        List<GunTableRecipe> tradeOfferList = ((GunTableScreenHandler)this.f_97732_).getRecipes();
        if (!tradeOfferList.isEmpty()) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            int yPos = j + 17;
            int xPos = i + 3;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            this.renderScrollbar(matrices, i, j, tradeOfferList);
            int m = 0;
            for (GunTableRecipe gunTableRecipe : tradeOfferList) {
                if (this.canScroll(tradeOfferList.size()) && (m < this.indexStartOffset || m >= 7 + this.indexStartOffset)) {
                    ++m;
                    continue;
                }
                ItemStack output = gunTableRecipe.output();
                int n = yPos + 2;
                this.renderIngredients(matrices, gunTableRecipe, xPos, n);
                this.renderArrow();
                matrices.m_280203_(output, i + 24 + 68, n);
                matrices.m_280370_(this.f_96547_, output, i + 24 + 68, n);
                yPos += 20;
                ++m;
            }
            for (WidgetButtonPage widgetButtonPage : this.offers) {
                if (widgetButtonPage.m_274382_()) {
                    widgetButtonPage.renderToolTip(matrices, mouseX, mouseY);
                }
                widgetButtonPage.f_93624_ = widgetButtonPage.index < ((GunTableScreenHandler)this.f_97732_).getRecipes().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.m_280072_(matrices, mouseX, mouseY);
    }

    private void renderArrow() {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
    }

    private void renderIngredients(GuiGraphics matrices, GunTableRecipe gunTableRecipe, int x, int y) {
        for (int i = 0; i < 5; ++i) {
            ItemStack stack;
            ItemStack[] displayStacks = gunTableRecipe.getIngredientForSlot(i).m_43908_();
            if (displayStacks.length <= 0 || (stack = new ItemStack((ItemLike)displayStacks[0].m_41720_(), gunTableRecipe.countRequired(i))).m_41619_()) continue;
            matrices.m_280203_(stack, x, y);
            matrices.m_280370_(this.f_96547_, stack, x, y);
            x += 16;
        }
    }

    private boolean canScroll(int listSize) {
        return listSize > 7;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int i = ((GunTableScreenHandler)this.f_97732_).getRecipes().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.indexStartOffset = (int)((double)this.indexStartOffset - amount);
            this.indexStartOffset = Mth.m_14045_((int)this.indexStartOffset, (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int i = ((GunTableScreenHandler)this.f_97732_).getRecipes().size();
        if (this.scrolling) {
            int j = this.f_97736_ + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.indexStartOffset = Mth.m_14045_((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((GunTableScreenHandler)this.f_97732_).getRecipes().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.scrolling = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    class WidgetButtonPage
    extends Button {
        final int index;

        public WidgetButtonPage(int x, int y, int index, Button.OnPress onPress) {
            super(x, y, 112, 20, CommonComponents.f_237098_, onPress, f_252438_);
            this.index = index;
            this.f_93624_ = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics matrices, int mouseX, int mouseY) {
            if (this.f_93622_ && ((GunTableScreenHandler)GunTableScreen.this.f_97732_).getRecipes().size() > this.index + GunTableScreen.this.indexStartOffset) {
                ItemStack stack = ((GunTableScreenHandler)GunTableScreen.this.f_97732_).getRecipes().get(this.index + GunTableScreen.this.indexStartOffset).output();
                if (mouseX < this.m_252754_() + 20 || mouseX > this.m_252754_() + 65 || mouseX < this.m_252754_() + 50 && mouseX > this.m_252754_() + 30 && !stack.m_41619_()) {
                    GunTableScreen.this.m_280072_(matrices, mouseX, mouseY);
                }
            }
        }
    }
}

