/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoEntityRenderer;
import mod.azure.azurelib.util.RenderUtils;
import mod.azure.doom.MCDoom;
import mod.azure.doom.client.models.projectiles.MeatHookEntityModel;
import mod.azure.doom.entities.projectiles.MeatHookEntity;
import mod.azure.doom.items.weapons.DoomBaseItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MeatHookEntityRenderer
extends GeoEntityRenderer<MeatHookEntity> {
    private static final RenderType CHAIN_LAYER = RenderType.m_110476_((ResourceLocation)MCDoom.modResource("textures/entity/chain.png"));
    private static final RenderType PLASMA_LAYER = RenderType.m_110476_((ResourceLocation)MCDoom.modResource("textures/entity/plasma_beam.png"));

    public MeatHookEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new MeatHookEntityModel());
    }

    protected int getBlockLightLevel(MeatHookEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public void preRender(PoseStack poseStack, MeatHookEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderUtils.faceRotation((PoseStack)poseStack, (Entity)animatable, (float)partialTick);
        if (animatable.getVariant() == 1) {
            poseStack.m_85841_(0.0f, 0.0f, 0.0f);
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(MeatHookEntity hookshot, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource provider, int light) {
        Player player;
        super.m_7392_((Entity)hookshot, yaw, tickDelta, poseStack, provider, light);
        Entity entity = hookshot.m_19749_();
        if (entity instanceof Player && (entity = (player = (Player)entity).m_21205_().m_41720_()) instanceof DoomBaseItem) {
            DoomBaseItem gunItem = (DoomBaseItem)entity;
            poseStack.m_85836_();
            if (hookshot.getVariant() != 1) {
                double bodyYawToRads = Math.toRadians(player.f_20883_);
                double radius = MCDoom.config.enable_noncenter ? -0.8 : 0.0;
                double startX = player.m_20185_() + radius * Math.cos(bodyYawToRads);
                double startY = player.m_20186_() + (double)player.m_20206_() / 2.0;
                double startZ = player.m_20189_() + radius * Math.sin(bodyYawToRads);
                float distanceX = (float)(startX - hookshot.m_20185_());
                float distanceY = (float)(startY - hookshot.m_20186_());
                float distanceZ = (float)(startZ - hookshot.m_20189_());
                this.renderChain(hookshot, distanceX, distanceY, distanceZ, tickDelta, hookshot.f_19797_, poseStack, provider, light);
            }
            poseStack.m_85849_();
        }
    }

    public void renderChain(MeatHookEntity hookshot, float x, float y, float z, float tickDelta, int tickCount, PoseStack poseStack, MultiBufferSource provider, int light) {
        float lengthXY = Mth.m_14116_((float)(x * x + z * z));
        float squaredLength = x * x + y * y + z * z;
        float length = Mth.m_14116_((float)squaredLength);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(z, x)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(lengthXY, y)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252403_.m_252961_(25.0f));
        poseStack.m_85836_();
        poseStack.m_85837_(0.015, -0.2, 0.0);
        VertexConsumer vertexConsumer = hookshot.getVariant() == 1 ? provider.m_6299_(PLASMA_LAYER) : provider.m_6299_(CHAIN_LAYER);
        float vertX1 = 0.0f;
        float vertY1 = 0.25f;
        float vertX2 = Mth.m_14031_((float)((float)Math.PI * 2)) * 0.125f;
        float vertY2 = Mth.m_14089_((float)((float)Math.PI * 2)) * 0.125f;
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f - ((float)tickCount + tickDelta) * 0.01f;
        float maxV = Mth.m_14116_((float)squaredLength) / 8.0f - ((float)tickCount + tickDelta) * 0.01f;
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
        poseStack.m_252781_(Axis.f_252403_.m_252961_(90.0f));
        poseStack.m_85837_(-0.015, -0.2, 0.0);
        entry = poseStack.m_85850_();
        matrix4f = entry.m_252922_();
        matrix3f = entry.m_252943_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }
}

