/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles.entity;

import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.helper.CommonUtils;
import mod.azure.doom.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class RocketMobEntity
extends AbstractHurtingProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private float directHitDamage = 5.0f;
    private LivingEntity shooter;
    private int idleTicks = 0;

    public RocketMobEntity(EntityType<? extends RocketMobEntity> entity, Level level) {
        super(entity, level);
    }

    public RocketMobEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, float directHitDamage) {
        super(Services.ENTITIES_HELPER.getRocketMobEntity(), shooter, accelX, accelY, accelZ, worldIn);
        this.shooter = shooter;
        this.directHitDamage = directHitDamage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6051_() {
        return false;
    }

    protected boolean m_5931_() {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 3.0f, Level.ExplosionInteraction.NONE);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.m_5496_(Services.SOUNDS_HELPER.getROCKET_HIT(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.m_9236_().m_5776_()) {
            LivingEntity livingEntity;
            Entity entity = entityHitResult.m_82443_();
            Entity entity2 = this.m_19749_();
            entity.m_20254_(5);
            this.explode();
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof DemonEntity)) {
                    livingEntity.m_6469_(this.m_269291_().m_269299_((Entity)this, livingEntity), this.directHitDamage);
                }
            }
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                if (!(entity instanceof DemonEntity)) {
                    this.m_19970_(livingEntity, entity);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.m_5496_(Services.SOUNDS_HELPER.getROCKET_HIT(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected void explode() {
        this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20183_().m_7494_()).m_82400_(4.0)).forEach(e -> {
            if (!(e instanceof DemonEntity)) {
                e.m_6469_(this.m_269291_().m_269549_(), this.directHitDamage);
            }
        });
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    public void m_8119_() {
        int idleOpt = 100;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < 100) {
            super.m_8119_();
        }
        if (this.f_19797_ >= 80) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        boolean isInsideWaterBlock = this.m_9236_().m_46801_(this.m_20183_());
        CommonUtils.spawnLightSource((Entity)this, isInsideWaterBlock);
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_() + this.f_19796_.m_188500_() * (double)this.m_20205_() * 0.5, this.m_20227_(0.5), this.m_20189_() + this.f_19796_.m_188500_() * (double)this.m_20205_() * 0.5, 0.0, 0.0, 0.0);
        }
    }
}

