/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.task;

import java.util.function.Consumer;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.tierboss.GladiatorEntity;
import mod.azure.doom.entities.tierboss.IconofsinEntity;
import mod.azure.doom.entities.tierheavy.MancubusEntity;
import mod.azure.doom.entities.tiersuperheavy.ArchvileEntity;
import mod.azure.doom.entities.tiersuperheavy.DoomHunterEntity;
import mod.azure.doom.entities.tiersuperheavy.MarauderEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import org.jetbrains.annotations.NotNull;

public abstract class CustomDelayedRangedBehaviour<E extends DemonEntity>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    protected CustomDelayedRangedBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    protected final void start(@NotNull ServerLevel level, @NotNull E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.m_6735_(level, entity, gameTime);
        } else {
            super.m_6735_(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
        if (entity instanceof MarauderEntity) {
            MarauderEntity marauder = (MarauderEntity)((Object)entity);
            marauder.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 100, false, false));
            marauder.triggerAnim("attackController", marauder.m_217043_().m_188503_(3) == 1 ? "slash" : "ranged");
        }
        if (entity instanceof ArchvileEntity) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 100, false, false));
        }
        if (entity instanceof MancubusEntity) {
            MancubusEntity mancubusEntity = (MancubusEntity)((Object)entity);
            mancubusEntity.setAttackingState(2);
        } else if (entity instanceof GladiatorEntity) {
            GladiatorEntity gladiatorEntity = (GladiatorEntity)entity;
            if (gladiatorEntity.getDeathState() == 0) {
                entity.triggerAnim("attackController", "ranged");
                gladiatorEntity.setTextureState(2);
            } else {
                entity.triggerAnim("attackController", "mace");
            }
            gladiatorEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 100, false, false));
        } else {
            ((DemonEntity)((Object)entity)).setAttackingState(1);
        }
        if (!(entity instanceof MarauderEntity)) {
            entity.triggerAnim("livingController", "ranged");
        }
        if (!(entity instanceof DoomHunterEntity || entity instanceof GladiatorEntity || entity instanceof MarauderEntity)) {
            entity.triggerAnim("attackController", "ranged");
        }
        if (entity instanceof DoomHunterEntity) {
            DoomHunterEntity hunter = (DoomHunterEntity)((Object)entity);
            if (hunter.getDeathState() == 1) {
                hunter.triggerAnim("attackController", "flames");
            }
            if (hunter.getDeathState() == 0) {
                hunter.triggerAnim("attackController", "rocket");
            }
        }
        if (entity instanceof IconofsinEntity) {
            IconofsinEntity iconEntity = (IconofsinEntity)entity;
            if (iconEntity.getDeathState() == 0) {
                iconEntity.triggerAnim("attackController", "phaseoneranged");
            } else {
                iconEntity.triggerAnim("attackController", "phasetworanged");
            }
        }
    }

    protected final void stop(@NotNull ServerLevel level, @NotNull E entity, long gameTime) {
        super.m_6732_(level, entity, gameTime);
        this.delayFinishedAt = 0L;
        if (entity instanceof GladiatorEntity) {
            GladiatorEntity gladiatorEntity = (GladiatorEntity)entity;
            gladiatorEntity.setTextureState(0);
        }
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= entity.m_9236_().m_46467_();
    }

    protected final void tick(@NotNull ServerLevel level, @NotNull E entity, long gameTime) {
        super.m_6725_(level, entity, gameTime);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
        entity.m_21573_().m_26573_();
    }

    protected void doDelayedAction(E entity) {
    }
}

