/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierfodder;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.task.DemonMeleeAttack;
import mod.azure.doom.platform.Services;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class UnwillingEntity
extends DemonEntity
implements SmartBrainOwner<UnwillingEntity> {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public UnwillingEntity(EntityType<UnwillingEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, MCDoom.config.unwilling_health).m_22268_(Attributes.f_22281_, MCDoom.config.unwilling_melee_damage).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        boolean isDead = this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_();
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (isDead) {
                return event.setAndContinue(DoomAnimationsDefault.DEATH2);
            }
            if (event.isMoving()) {
                return event.setAndContinue(DoomAnimationsDefault.WALK);
            }
            return event.setAndContinue(DoomAnimationsDefault.IDLE);
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("walk") && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getPINKY_STEP(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
            }
        })}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).triggerableAnim("melee", DoomAnimationsDefault.ATTACK)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<UnwillingEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target.m_6084_() && entity.m_142582_((Entity)target) && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<UnwillingEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<UnwillingEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(0.7f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<UnwillingEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_()), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(0.75f)), new DemonMeleeAttack(5)});
    }

    public double m_142593_(LivingEntity livingEntity) {
        return this.m_20205_() * 1.0f * (this.m_20205_() + livingEntity.m_20205_());
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        double distance = this.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        return distance <= this.m_142593_(livingEntity);
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 4.7f;
    }

    public boolean m_6162_() {
        return false;
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return Services.SOUNDS_HELPER.getZOMBIEMAN_HURT();
    }

    protected SoundEvent m_5592_() {
        return Services.SOUNDS_HELPER.getZOMBIEMAN_DEATH();
    }

    public int m_5792_() {
        return 1;
    }
}

