/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.modintegration.curios.Curios_Base;
import shetiphian.enderchests.network.NetworkHandler;
import shetiphian.enderchests.network.PacketOpenBag;

@OnlyIn(value=Dist.CLIENT)
public class EventHandlerClient {
    public static final KeyMapping KEY_OPEN_BAG = new KeyMapping("key.enderchests.open.bag", -1, "itemGroup.enderchests");
    public static final KeyMapping KEY_OPEN_POUCH = new KeyMapping("key.enderchests.open.pouch", -1, "itemGroup.enderchests");

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register(KEY_OPEN_BAG);
        event.register(KEY_OPEN_POUCH);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (KEY_OPEN_BAG.m_90859_()) {
                this.openCarriedBag(KEY_OPEN_BAG.m_90850_(KEY_OPEN_POUCH) ? IOpenable.Type.EITHER : IOpenable.Type.BAG);
            } else if (KEY_OPEN_POUCH.m_90859_()) {
                this.openCarriedBag(KEY_OPEN_BAG.m_90850_(KEY_OPEN_POUCH) ? IOpenable.Type.EITHER : IOpenable.Type.POUCH);
            }
        }
    }

    private void openCarriedBag(IOpenable.Type type) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Pair<String, ItemStack> curioData = Curios_Base.CURIO_SCANNER.apply((LivingEntity)player, type);
            if (curioData != null && ((ItemStack)curioData.getSecond()).m_41720_() instanceof IOpenable) {
                ((IOpenable)((ItemStack)curioData.getSecond()).m_41720_()).openInventory((ItemStack)curioData.getSecond(), (Player)player);
                NetworkHandler.sendToServer(new PacketOpenBag((String)curioData.getFirst(), type));
                return;
            }
            NonNullList items = player.m_150109_().f_35974_;
            for (int index = items.size() - 1; index >= 0; --index) {
                Item item;
                ItemStack stack = (ItemStack)items.get(index);
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IOpenable)) continue;
                IOpenable openable = (IOpenable)item;
                if (!type.test(stack)) continue;
                openable.openInventory(stack, (Player)player);
                NetworkHandler.sendToServer(new PacketOpenBag(String.format("inventory|%d", index), type));
                break;
            }
        }
    }

    @SubscribeEvent
    public void drawBlockHighlightEvent(RenderHighlightEvent.Block event) {
        VoxelShape shape;
        BlockPos pos;
        if (event.getTarget() == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !player.m_6144_() || player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
            return;
        }
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos = event.getTarget().m_82425_());
        if (state.m_60734_() instanceof BlockEnderChest && world.m_6857_().m_61937_(pos) && !(shape = this.getShapeToOutline((Player)player, state, world, pos)).m_83281_()) {
            this.drawSelectionBox(event.getPoseStack(), event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), event.getCamera(), pos, shape);
        }
    }

    private VoxelShape getShapeToOutline(Player player, BlockState state, Level world, BlockPos pos) {
        for (InteractionHand hand : InteractionHand.values()) {
            Item item = player.m_21120_(hand).m_41720_();
            if (Values.listPersonal.contains(item) || Values.listTeam.contains(item) || Values.listSmallCap_Single.contains(item) || Values.listSmallCap_Multi.contains(item) || Values.listLargeCap_Single.contains(item) || Values.listLargeCap_Multi.contains(item)) {
                return state.m_60808_((BlockGetter)world, pos);
            }
            if (!DyeHelper.isDye((Item)item) || BlockEnderChest.SHAPES.isEmpty()) continue;
            VoxelShape[] shapes = BlockEnderChest.SHAPES.get(state.m_61143_((Property)BlockEnderChest.FACING));
            int subHit = Function.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])shapes);
            return subHit > 0 && subHit < 4 ? shapes[subHit] : Shapes.m_83040_();
        }
        return Shapes.m_83040_();
    }

    public void drawSelectionBox(PoseStack matrixStack, VertexConsumer buffer, Camera info, BlockPos pos, VoxelShape shape) {
        double d0 = info.m_90583_().f_82479_;
        double d1 = info.m_90583_().f_82480_;
        double d2 = info.m_90583_().f_82481_;
        float mul = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        if (mul > 1.0f) {
            mul = 2.0f - mul;
        }
        EventHandlerClient.drawShape(matrixStack, buffer, shape, (double)pos.m_123341_() - d0, (double)pos.m_123342_() - d1, (double)pos.m_123343_() - d2, mul, mul, mul, 0.4f);
    }

    private static void drawShape(PoseStack matrixStack, VertexConsumer buffer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = matrixStack.m_85850_();
        shape.m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float nX = (float)(maxX - minX);
            float nY = (float)(maxY - minY);
            float nZ = (float)(maxZ - minZ);
            float sqrt = Mth.m_14116_((float)(nX * nX + nY * nY + nZ * nZ));
            buffer.m_252986_(pose.m_252922_(), (float)(minX + x), (float)(minY + y), (float)(minZ + z)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), nX /= sqrt, nY /= sqrt, nZ /= sqrt).m_5752_();
            buffer.m_252986_(pose.m_252922_(), (float)(maxX + x), (float)(maxY + y), (float)(maxZ + z)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), nX, nY, nZ).m_5752_();
        });
    }
}

