/*
 * Decompiled with CFR 0.152.
 */
package guideme.color;

import guideme.color.ColorValue;
import guideme.color.SymbolicColor;
import guideme.compiler.PageCompiler;
import guideme.extensions.Extension;
import guideme.extensions.ExtensionPoint;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface SymbolicColorResolver
extends Extension {
    public static final ExtensionPoint<SymbolicColorResolver> EXTENSION_POINT = new ExtensionPoint<SymbolicColorResolver>(SymbolicColorResolver.class);

    @Nullable
    public ColorValue resolve(ResourceLocation var1);

    @Nullable
    public static ColorValue resolve(PageCompiler compiler, String id) {
        try {
            return SymbolicColor.valueOf(id.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ResourceLocation resourceLocation;
            try {
                resourceLocation = compiler.resolveId(id);
            }
            catch (Exception e) {
                return null;
            }
            if (resourceLocation == null) {
                return null;
            }
            for (SymbolicColorResolver resolver : compiler.getExtensions(EXTENSION_POINT)) {
                ColorValue color = resolver.resolve(resourceLocation);
                if (color == null) continue;
                return color;
            }
            return null;
        }
    }
}

