/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.model.ICustomStatueModel;
import com.github.alexthe666.iceandfire.client.model.ModelHydraBody;
import com.github.alexthe666.iceandfire.client.model.ModelStonePlayer;
import com.github.alexthe666.iceandfire.client.render.IafRenderType;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.EntityTroll;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RenderStoneStatue
extends EntityRenderer<EntityStoneStatue> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/block/destroy_stage_0.png"), new ResourceLocation("textures/block/destroy_stage_1.png"), new ResourceLocation("textures/block/destroy_stage_2.png"), new ResourceLocation("textures/block/destroy_stage_3.png"), new ResourceLocation("textures/block/destroy_stage_4.png"), new ResourceLocation("textures/block/destroy_stage_5.png"), new ResourceLocation("textures/block/destroy_stage_6.png"), new ResourceLocation("textures/block/destroy_stage_7.png"), new ResourceLocation("textures/block/destroy_stage_8.png"), new ResourceLocation("textures/block/destroy_stage_9.png")};
    private final Map<String, EntityModel> modelMap = new HashMap<String, EntityModel>();
    private final Map<String, Entity> hollowEntityMap = new HashMap<String, Entity>();
    private final EntityRendererProvider.Context context;

    public RenderStoneStatue(EntityRendererProvider.Context context) {
        super(context);
        this.context = context;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityStoneStatue entity) {
        return TextureAtlas.f_118259_;
    }

    protected void preRenderCallback(EntityStoneStatue entity, PoseStack matrixStackIn, float partialTickTime) {
        float scale = entity.m_6134_() < 0.01f ? 1.0f : entity.m_6134_();
        matrixStackIn.m_85841_(scale, scale, scale);
    }

    public void render(EntityStoneStatue entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        Object model = new PigModel(this.context.m_174023_(ModelLayers.f_171205_));
        if (this.modelMap.get(entityIn.getTrappedEntityTypeString()) != null) {
            model = this.modelMap.get(entityIn.getTrappedEntityTypeString());
        } else {
            EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(entityIn.getTrappedEntityType());
            if (renderer instanceof RenderLayerParent) {
                model = ((RenderLayerParent)renderer).m_7200_();
            } else if (entityIn.getTrappedEntityType() == EntityType.f_20532_) {
                model = new ModelStonePlayer(this.context.m_174023_(ModelLayers.f_171162_));
            }
            this.modelMap.put(entityIn.getTrappedEntityTypeString(), (EntityModel)model);
        }
        if (model == null) {
            return;
        }
        Entity fakeEntity = null;
        if (this.hollowEntityMap.get(entityIn.getTrappedEntityTypeString()) == null) {
            Entity build = entityIn.getTrappedEntityType().m_20615_((Level)Minecraft.m_91087_().f_91073_);
            if (build != null) {
                try {
                    build.m_20258_(entityIn.getTrappedTag());
                }
                catch (Exception e) {
                    IceAndFire.LOGGER.warn("Mob " + entityIn.getTrappedEntityTypeString() + " could not build statue NBT");
                }
                fakeEntity = this.hollowEntityMap.putIfAbsent(entityIn.getTrappedEntityTypeString(), build);
            }
        } else {
            fakeEntity = this.hollowEntityMap.get(entityIn.getTrappedEntityTypeString());
        }
        RenderType tex = IafRenderType.getStoneMobRenderType(200.0f, 200.0f);
        if (fakeEntity instanceof EntityTroll) {
            tex = RenderType.m_110452_((ResourceLocation)((EntityTroll)fakeEntity).getTrollType().TEXTURE_STONE);
        }
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(tex);
        matrixStackIn.m_85836_();
        float yaw = entityIn.f_19859_ + (entityIn.m_146908_() - entityIn.f_19859_) * partialTicks;
        boolean shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
        model.f_102610_ = entityIn.m_6162_();
        model.f_102609_ = shouldSit;
        model.f_102608_ = entityIn.m_21324_(partialTicks);
        if (model instanceof AdvancedEntityModel) {
            ((AdvancedEntityModel)model).resetToDefaultPose();
        } else if (fakeEntity != null) {
            model.m_6973_(fakeEntity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        }
        this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.m_252880_(0.0f, 1.5f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(yaw));
        if (model instanceof ICustomStatueModel && fakeEntity != null) {
            ((ICustomStatueModel)model).renderStatue(matrixStackIn, ivertexbuilder, packedLightIn, fakeEntity);
            if (model instanceof ModelHydraBody && fakeEntity instanceof EntityHydra) {
                LayerHydraHead.renderHydraHeads((ModelHydraBody)model, true, matrixStackIn, bufferIn, packedLightIn, (EntityHydra)fakeEntity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f);
            }
        } else {
            model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStackIn.m_85849_();
        if (entityIn.getCrackAmount() >= 1) {
            int i = Mth.m_14045_((int)(entityIn.getCrackAmount() - 1), (int)0, (int)(DESTROY_STAGES.length - 1));
            RenderType crackTex = IafRenderType.getStoneCrackRenderType(DESTROY_STAGES[i]);
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(crackTex);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85836_();
            this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
            matrixStackIn.m_252880_(0.0f, 1.5f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(yaw));
            if (model instanceof ICustomStatueModel) {
                ((ICustomStatueModel)model).renderStatue(matrixStackIn, ivertexbuilder2, packedLightIn, fakeEntity);
            } else {
                model.m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.m_85849_();
            matrixStackIn.m_85849_();
        }
    }
}

