/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ChainData {
    @Nullable
    public List<Entity> chainedTo;
    @Nullable
    private List<Integer> chainedToIds;
    @Nullable
    private List<UUID> chainedToUUIDs;
    private boolean isInitialized;
    private boolean triggerClientUpdate;

    public void tickChain(LivingEntity entity) {
        if (!this.isInitialized) {
            this.initialize(entity.m_9236_());
        }
        if (this.chainedTo == null) {
            return;
        }
        for (Entity chain : this.chainedTo) {
            double distance = chain.m_20270_((Entity)entity);
            if (!(distance > 7.0)) continue;
            double x = (chain.m_20185_() - entity.m_20185_()) / distance;
            double y = (chain.m_20186_() - entity.m_20186_()) / distance;
            double z = (chain.m_20189_() - entity.m_20189_()) / distance;
            entity.m_20256_(entity.m_20184_().m_82520_(x * Math.abs(x) * 0.4, y * Math.abs(y) * 0.2, z * Math.abs(z) * 0.4));
        }
    }

    public List<Entity> getChainedTo() {
        return Objects.requireNonNullElse(this.chainedTo, Collections.emptyList());
    }

    public void clearChains() {
        if (this.chainedTo == null) {
            return;
        }
        this.chainedTo = null;
        this.triggerClientUpdate = true;
    }

    public void attachChain(Entity chain) {
        if (this.chainedTo == null) {
            this.chainedTo = new ArrayList<Entity>();
        } else if (this.chainedTo.contains(chain)) {
            return;
        }
        this.chainedTo.add(chain);
        this.triggerClientUpdate = true;
    }

    public void removeChain(Entity chain) {
        if (this.chainedTo == null) {
            return;
        }
        this.chainedTo.remove(chain);
        this.triggerClientUpdate = true;
        if (this.chainedTo.isEmpty()) {
            this.chainedTo = null;
        }
    }

    public boolean isChainedTo(Entity toCheck) {
        if (this.chainedTo == null || this.chainedTo.isEmpty()) {
            return false;
        }
        return this.chainedTo.contains(toCheck);
    }

    public void serialize(CompoundTag tag) {
        CompoundTag chainedData = new CompoundTag();
        ListTag uuids = new ListTag();
        if (this.chainedTo != null) {
            int[] ids = new int[this.chainedTo.size()];
            for (int i = 0; i < this.chainedTo.size(); ++i) {
                Entity entity = this.chainedTo.get(i);
                ids[i] = entity.m_19879_();
                uuids.add((Object)NbtUtils.m_129226_((UUID)entity.m_20148_()));
            }
            chainedData.m_128385_("chainedToIds", ids);
            chainedData.m_128365_("chainedToUUIDs", (Tag)uuids);
        }
        tag.m_128365_("chainedData", (Tag)chainedData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag chainedData = tag.m_128469_("chainedData");
        int[] loadedChainedToIds = chainedData.m_128465_("chainedToIds");
        ListTag uuids = chainedData.m_128437_("chainedToUUIDs", 11);
        this.isInitialized = false;
        if (loadedChainedToIds.length > 0) {
            this.chainedToIds = new ArrayList<Integer>();
            for (int loadedChainedToId : loadedChainedToIds) {
                this.chainedToIds.add(loadedChainedToId);
            }
        } else {
            this.chainedToIds = null;
        }
        if (!uuids.isEmpty()) {
            this.chainedToUUIDs = new ArrayList<UUID>();
            Object object = uuids.iterator();
            while (object.hasNext()) {
                Tag uuid = (Tag)object.next();
                this.chainedToUUIDs.add(NbtUtils.m_129233_((Tag)uuid));
            }
        } else {
            this.chainedToUUIDs = null;
        }
    }

    public boolean doesClientNeedUpdate() {
        if (this.triggerClientUpdate) {
            this.triggerClientUpdate = false;
            return true;
        }
        return false;
    }

    private void initialize(Level level) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (this.chainedToUUIDs != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (UUID uuid : this.chainedToUUIDs) {
                Entity entity = serverLevel.m_8791_(uuid);
                if (entity == null) continue;
                entities.add(entity);
            }
            this.triggerClientUpdate = true;
        } else if (this.chainedToIds != null) {
            for (int id : this.chainedToIds) {
                Entity entity;
                if (id == -1 || (entity = level.m_6815_(id)) == null) continue;
                entities.add(entity);
            }
        }
        this.chainedTo = !entities.isEmpty() ? entities : null;
        this.chainedToIds = null;
        this.chainedToUUIDs = null;
        this.isInitialized = true;
    }
}

