/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.citadel.config.biome.SpawnBiomeData;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.datagen.IafPlacedFeatures;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldData;
import com.github.alexthe666.iceandfire.world.feature.SpawnDeathWorm;
import com.github.alexthe666.iceandfire.world.feature.SpawnDragonSkeleton;
import com.github.alexthe666.iceandfire.world.feature.SpawnHippocampus;
import com.github.alexthe666.iceandfire.world.feature.SpawnSeaSerpent;
import com.github.alexthe666.iceandfire.world.feature.SpawnStymphalianBird;
import com.github.alexthe666.iceandfire.world.feature.SpawnWanderingCyclops;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenPixieVillage;
import com.github.alexthe666.iceandfire.world.gen.WorldGenSirenIsland;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.storage.LevelData;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class IafWorldRegistry {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"iceandfire");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FIRE_DRAGON_ROOST = IafWorldRegistry.register("fire_dragon_roost", () -> new WorldGenFireDragonRoosts((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ICE_DRAGON_ROOST = IafWorldRegistry.register("ice_dragon_roost", () -> new WorldGenIceDragonRoosts((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> LIGHTNING_DRAGON_ROOST = IafWorldRegistry.register("lightning_dragon_roost", () -> new WorldGenLightningDragonRoosts((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FIRE_DRAGON_CAVE = IafWorldRegistry.register("fire_dragon_cave", () -> new WorldGenFireDragonCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ICE_DRAGON_CAVE = IafWorldRegistry.register("ice_dragon_cave", () -> new WorldGenIceDragonCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> LIGHTNING_DRAGON_CAVE = IafWorldRegistry.register("lightning_dragon_cave", () -> new WorldGenLightningDragonCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CYCLOPS_CAVE = IafWorldRegistry.register("cyclops_cave", () -> new WorldGenCyclopsCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PIXIE_VILLAGE = IafWorldRegistry.register("pixie_village", () -> new WorldGenPixieVillage((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SIREN_ISLAND = IafWorldRegistry.register("siren_island", () -> new WorldGenSirenIsland((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> HYDRA_CAVE = IafWorldRegistry.register("hydra_cave", () -> new WorldGenHydraCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> MYRMEX_HIVE_DESERT = IafWorldRegistry.register("myrmex_hive_desert", () -> new WorldGenMyrmexHive(false, false, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> MYRMEX_HIVE_JUNGLE = IafWorldRegistry.register("myrmex_hive_jungle", () -> new WorldGenMyrmexHive(false, true, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DEATH_WORM = IafWorldRegistry.register("spawn_death_worm", () -> new SpawnDeathWorm((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_L = IafWorldRegistry.register("spawn_dragon_skeleton_lightning", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntityRegistry.LIGHTNING_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_F = IafWorldRegistry.register("spawn_dragon_skeleton_fire", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntityRegistry.FIRE_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_I = IafWorldRegistry.register("spawn_dragon_skeleton_ice", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntityRegistry.ICE_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_HIPPOCAMPUS = IafWorldRegistry.register("spawn_hippocampus", () -> new SpawnHippocampus((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_SEA_SERPENT = IafWorldRegistry.register("spawn_sea_serpent", () -> new SpawnSeaSerpent((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_STYMPHALIAN_BIRD = IafWorldRegistry.register("spawn_stymphalian_bird", () -> new SpawnStymphalianBird((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_WANDERING_CYCLOPS = IafWorldRegistry.register("spawn_wandering_cyclops", () -> new SpawnWanderingCyclops((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static HashMap<String, Boolean> LOADED_FEATURES = new HashMap();
    private static List<String> ADDED_FEATURES;

    private static <C extends FeatureConfiguration, F extends Feature<C>> RegistryObject<F> register(String name, Supplier<? extends F> supplier) {
        return FEATURES.register(name, supplier);
    }

    public static boolean isFarEnoughFromSpawn(LevelAccessor level, BlockPos position) {
        LevelData spawnPoint = level.m_6106_();
        BlockPos spawnRelative = new BlockPos(spawnPoint.m_6789_(), position.m_123342_(), spawnPoint.m_6527_());
        return !spawnRelative.m_123314_((Vec3i)position, IafConfig.dangerousWorldGenDistanceLimit);
    }

    public static boolean isFarEnoughFromDangerousGen(ServerLevelAccessor level, BlockPos position, String id) {
        return IafWorldRegistry.isFarEnoughFromDangerousGen(level, position, id, IafWorldData.FeatureType.SURFACE);
    }

    public static boolean isFarEnoughFromDangerousGen(ServerLevelAccessor level, BlockPos position, String id, IafWorldData.FeatureType type) {
        IafWorldData data = IafWorldData.get((Level)level.m_6018_());
        return data.check(type, position, id);
    }

    public static void addFeatures(Holder<Biome> biome, HashMap<String, Holder<PlacedFeature>> features, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        ADDED_FEATURES = new ArrayList<String>();
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireLilyBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_FIRE_LILY, features, builder, GenerationStep.Decoration.VEGETAL_DECORATION);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningLilyBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_LIGHTNING_LILY, features, builder, GenerationStep.Decoration.VEGETAL_DECORATION);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.frostLilyBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_FROST_LILY, features, builder, GenerationStep.Decoration.VEGETAL_DECORATION);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.oreGenBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SILVER_ORE, features, builder, GenerationStep.Decoration.UNDERGROUND_ORES);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.sapphireBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SAPPHIRE_ORE, features, builder, GenerationStep.Decoration.UNDERGROUND_ORES);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireDragonBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_FIRE_DRAGON_ROOST, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningDragonBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_LIGHTNING_DRAGON_ROOST, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.iceDragonBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_ICE_DRAGON_ROOST, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireDragonCaveBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_FIRE_DRAGON_CAVE, features, builder, GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningDragonCaveBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_LIGHTNING_DRAGON_CAVE, features, builder, GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.iceDragonCaveBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_ICE_DRAGON_CAVE, features, builder, GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.cyclopsCaveBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_CYCLOPS_CAVE, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.pixieBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_PIXIE_VILLAGE, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.hydraBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_HYDRA_CAVE, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.desertMyrmexBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_MYRMEX_HIVE_DESERT, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.jungleMyrmexBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_MYRMEX_HIVE_JUNGLE, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.sirenBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SIREN_ISLAND, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.deathwormBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_DEATH_WORM, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.wanderingCyclopsBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_WANDERING_CYCLOPS, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningDragonSkeletonBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_DRAGON_SKELETON_L, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireDragonSkeletonBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_DRAGON_SKELETON_F, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.iceDragonSkeletonBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_DRAGON_SKELETON_I, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.hippocampusBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_HIPPOCAMPUS, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.seaSerpentBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_SEA_SERPENT, features, builder);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.stymphalianBiomes, biome)) {
            IafWorldRegistry.addFeatureToBiome(IafPlacedFeatures.PLACED_SPAWN_STYMPHALIAN_BIRD, features, builder);
        }
        if (!ADDED_FEATURES.isEmpty()) {
            StringBuilder featureList = new StringBuilder();
            for (String feature : ADDED_FEATURES) {
                featureList.append("\n").append("\t- ").append(feature);
            }
            IceAndFire.LOGGER.debug("Added the following features to the biome [{}]: {}", (Object)((ResourceKey)biome.m_203543_().get()).m_135782_(), (Object)featureList);
        }
        ADDED_FEATURES = null;
    }

    private static void addFeatureToBiome(ResourceKey<PlacedFeature> feature, HashMap<String, Holder<PlacedFeature>> features, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        IafWorldRegistry.addFeatureToBiome(feature, features, builder, GenerationStep.Decoration.SURFACE_STRUCTURES);
    }

    private static void addFeatureToBiome(ResourceKey<PlacedFeature> featureResource, HashMap<String, Holder<PlacedFeature>> features, ModifiableBiomeInfo.BiomeInfo.Builder builder, GenerationStep.Decoration step) {
        String identifier = featureResource.m_135782_().toString();
        Holder<PlacedFeature> feature = features.get(identifier);
        if (feature != null) {
            builder.getGenerationSettings().getFeatures(step).add(feature);
            LOADED_FEATURES.put(identifier, true);
            ADDED_FEATURES.add(identifier);
        } else {
            IceAndFire.LOGGER.warn("Feature [{}] could not be found", (Object)identifier);
        }
    }

    private static boolean safelyTestBiome(Pair<String, SpawnBiomeData> entry, Holder<Biome> biomeHolder) {
        try {
            return BiomeConfig.test(entry, biomeHolder);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        LOADED_FEATURES.put("iceandfire:fire_lily", false);
        LOADED_FEATURES.put("iceandfire:frost_lily", false);
        LOADED_FEATURES.put("iceandfire:lightning_lily", false);
        LOADED_FEATURES.put("iceandfire:silver_ore", false);
        LOADED_FEATURES.put("iceandfire:sapphire_ore", false);
        LOADED_FEATURES.put("iceandfire:fire_dragon_roost", false);
        LOADED_FEATURES.put("iceandfire:ice_dragon_roost", false);
        LOADED_FEATURES.put("iceandfire:lightning_dragon_roost", false);
        LOADED_FEATURES.put("iceandfire:fire_dragon_cave", false);
        LOADED_FEATURES.put("iceandfire:ice_dragon_cave", false);
        LOADED_FEATURES.put("iceandfire:lightning_dragon_cave", false);
        LOADED_FEATURES.put("iceandfire:cyclops_cave", false);
        LOADED_FEATURES.put("iceandfire:pixie_village", false);
        LOADED_FEATURES.put("iceandfire:siren_island", false);
        LOADED_FEATURES.put("iceandfire:hydra_cave", false);
        LOADED_FEATURES.put("iceandfire:myrmex_hive_desert", false);
        LOADED_FEATURES.put("iceandfire:myrmex_hive_jungle", false);
        LOADED_FEATURES.put("iceandfire:spawn_death_worm", false);
        LOADED_FEATURES.put("iceandfire:spawn_dragon_skeleton_lightning", false);
        LOADED_FEATURES.put("iceandfire:spawn_dragon_skeleton_fire", false);
        LOADED_FEATURES.put("iceandfire:spawn_dragon_skeleton_ice", false);
        LOADED_FEATURES.put("iceandfire:spawn_hippocampus", false);
        LOADED_FEATURES.put("iceandfire:spawn_sea_serpent", false);
        LOADED_FEATURES.put("iceandfire:spawn_stymphalian_bird", false);
        LOADED_FEATURES.put("iceandfire:spawn_wandering_cyclops", false);
    }
}

