/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.block.dialhomedevice.DHDAbstractBlock;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.helpers.BlockHelpers;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.multistructure.mergehelper.StargateClassicMergeHelper;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.worldgen.GeneratedStargate;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;

public class StargateGenerator {
    @Nullable
    public static GeneratedStargate generateStargate(@Nonnull PlacementConfig conf) {
        return StargateGenerator.generateStargate(conf, true);
    }

    @Nullable
    public static GeneratedStargate generateStargate(@Nonnull PlacementConfig conf, boolean replaceMemberBlocks) {
        StargateAbstractBaseBE abstractBaseBE;
        if (conf.world == null) {
            return null;
        }
        if (conf.gateBasePos == null) {
            return null;
        }
        Block dhdBlock = conf.gateType.getDHDBlock();
        BlockState gateBaseBlockState = conf.gateType.getBaseBlock().m_49966_();
        Item crystalGlyphUpgrade = conf.gateType.symbolType.getGlyphUpgrade();
        if (!conf.baseInPlace) {
            conf.world.m_7731_(conf.gateBasePos, (BlockState)((BlockState)gateBaseBlockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)conf.gateFacing)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(conf.gateVerticalFacing))), 18);
        }
        try {
            abstractBaseBE = (StargateAbstractBaseBE)conf.world.m_7702_(conf.gateBasePos);
        }
        catch (Exception e) {
            JSG.logger.error("Error while generating gate at " + BlockHelpers.blockPosToBetterString(conf.gateBasePos) + " in " + String.valueOf(conf.world.m_46472_()), (Throwable)e);
            return null;
        }
        if (!(abstractBaseBE instanceof StargateClassicBaseBE)) {
            return null;
        }
        StargateClassicBaseBE gateTile = (StargateClassicBaseBE)abstractBaseBE;
        StargateClassicMergeHelper mergeHelper = (StargateClassicMergeHelper)gateTile.getMergeHelper();
        for (Map.Entry<BlockPos, BlockState> e : mergeHelper.getBlocks(true).entrySet()) {
            if (!replaceMemberBlocks && conf.world.m_8055_(e.getKey()).m_60734_() == e.getValue().m_60734_()) continue;
            conf.world.m_7731_(e.getKey(), e.getValue(), 18);
        }
        mergeHelper.updateMemberStateAndCheck(true);
        gateTile.refresh();
        if (conf.stargateConfig != null) {
            gateTile.initConfig();
            gateTile.setConfigAndUpdate(conf.stargateConfig.apply(gateTile.getConfig()));
        }
        gateTile.getEnergyStorageForApi().setEnergyStored(conf.stargateEnergyInternal);
        int nextSlot = 0;
        boolean isTypeCrystalIn = false;
        ItemHandlerHelper.clearInventory(gateTile.getItemHandler());
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.GLYPH_CRYSTAL_STARGATE)) {
            gateTile.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_STARGATE.get(), 1), false);
        }
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.GLYPH_CRYSTAL_MW)) {
            gateTile.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_MILKYWAY.get(), 1), false);
            if (conf.gateType.symbolType.getGlyphUpgrade() == ItemRegistry.CRYSTAL_GLYPH_MILKYWAY.get()) {
                isTypeCrystalIn = true;
            }
        }
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.GLYPH_CRYSTAL_PEG)) {
            gateTile.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_PEGASUS.get(), 1), false);
            if (conf.gateType.symbolType.getGlyphUpgrade() == ItemRegistry.CRYSTAL_GLYPH_PEGASUS.get()) {
                isTypeCrystalIn = true;
            }
        }
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.GLYPH_CRYSTAL_UNI)) {
            gateTile.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_UNIVERSE.get(), 1), false);
            if (conf.gateType.symbolType.getGlyphUpgrade() == ItemRegistry.CRYSTAL_GLYPH_UNIVERSE.get()) {
                isTypeCrystalIn = true;
            }
        }
        if (!isTypeCrystalIn && nextSlot < 4 && conf.upgrades.contains((Object)StargateUpgradesEnum.GLYPH_CRYSTAL_TYPE)) {
            gateTile.getItemHandler().insertItem(nextSlot, new ItemStack((ItemLike)crystalGlyphUpgrade, 1), false);
        }
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.UPGRADE_IRIS_TITANIUM)) {
            gateTile.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_IRIS.get(), 1), false);
        }
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.UPGRADE_IRIS_TRINIUM)) {
            gateTile.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_IRIS_TRINIUM.get(), 1), false);
        }
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.UPGRADE_SHIELD)) {
            gateTile.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_SHIELD.get(), 1), false);
        }
        if (conf.upgrades.contains((Object)StargateUpgradesEnum.UPGRADE_IRIS_CREATIVE)) {
            gateTile.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_IRIS_CREATIVE.get(), 1), false);
        }
        nextSlot = 4;
        for (Pair<Integer, Boolean> e : conf.capacitors) {
            ItemStack capacitor;
            if (nextSlot >= 7) break;
            if (((Boolean)e.second()).booleanValue()) {
                capacitor = new ItemStack((ItemLike)BlockRegistry.CAPACITOR_BLOCK_CREATIVE.get());
            } else {
                if ((Integer)e.first() < 0) continue;
                capacitor = new ItemStack((ItemLike)BlockRegistry.CAPACITOR_BLOCK.get());
                IEnergyStorage storage = (IEnergyStorage)capacitor.getCapability(ForgeCapabilities.ENERGY, null).resolve().orElseThrow();
                storage.receiveEnergy(((Integer)e.first()).intValue(), false);
            }
            gateTile.getItemHandler().insertItem(nextSlot++, capacitor, false);
        }
        gateTile.setIrisMode(conf.irisMode);
        gateTile.setIrisCode(conf.irisCode);
        if (conf.dhdPos != null && dhdBlock != null) {
            BlockState dhdState = conf.world.m_8055_(conf.dhdPos);
            if (!(dhdState.m_60734_() instanceof DHDAbstractBlock)) {
                int dhdRotation = conf.dhdRotation;
                if (dhdRotation < 0) {
                    dhdRotation = BlockPosHelper.getIntDHDRotationFromFacing(conf.gateFacing, conf.gateFacing == Direction.WEST || conf.gateFacing == Direction.EAST);
                }
                BlockState dhdBlockState = (BlockState)dhdBlock.m_49966_().m_61124_((Property)JSGProperties.ROTATION_PROPERTY, (Comparable)Integer.valueOf(dhdRotation));
                conf.world.m_7731_(conf.dhdPos, dhdBlockState, 18);
            }
            DHDAbstractBE dhdTile = (DHDAbstractBE)Objects.requireNonNull(conf.world.m_7702_(conf.dhdPos));
            ItemStack crystal = new ItemStack((ItemLike)dhdTile.getControlCrystal());
            dhdTile.getItemStackHandler().setStackInSlot(0, crystal);
            if (conf.upgrades.contains((Object)StargateUpgradesEnum.GLYPH_CRYSTAL_DHD)) {
                dhdTile.getItemStackHandler().setStackInSlot(1, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_DHD.get(), 1));
            }
            if (conf.upgrades.contains((Object)StargateUpgradesEnum.UPGRADE_CAPACITY_DHD)) {
                dhdTile.getItemStackHandler().setStackInSlot(2, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_UPGRADE_CAPACITY.get(), 1));
            }
            if (conf.upgrades.contains((Object)StargateUpgradesEnum.UPGRADE_EFFICIENCY_DHD)) {
                dhdTile.getItemStackHandler().setStackInSlot(3, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_UPGRADE_EFFICIENCY.get(), 1));
            }
            if (conf.dhdFluid >= 0) {
                dhdTile.getFluidHandler().setFluid(new FluidStack(FluidRegistry.MOLTEN_NAQUADAH_REFINED.get(), conf.dhdFluid));
            }
            LinkingHelper.updateLinkedGate(conf.world, conf.gateBasePos, conf.dhdPos);
        }
        ResourceLocation biomePath = conf.world.m_204166_(conf.gateBasePos).m_203543_().orElse(Biomes.f_48205_).m_135782_();
        StargateAddress gateAddress = gateTile.getStargateAddress(conf.addressSymbolTypeToReturn);
        return new GeneratedStargate(gateAddress, biomePath.m_135815_(), true, gateTile.getOriginId());
    }

    public static class PlacementConfig {
        public Level world;
        @Nonnull
        public List<StargateUpgradesEnum> upgrades = new ArrayList<StargateUpgradesEnum>();
        @Nonnull
        public BiomeOverlayEnum overlay = BiomeOverlayEnum.NORMAL;
        @Nonnull
        public SymbolTypeEnum<?> addressSymbolTypeToReturn = SymbolTypeRegistry.MILKYWAY;
        public BlockPos gateBasePos;
        @Nonnull
        public Direction gateFacing = Direction.NORTH;
        @Nonnull
        public Direction gateVerticalFacing = Direction.SOUTH;
        @Nonnull
        public StargateTypeEnum gateType = StargateTypeEnum.MILKYWAY;
        @Nonnull
        public List<Pair<Integer, Boolean>> capacitors = new ArrayList<Pair<Integer, Boolean>>();
        public int stargateEnergyInternal = -1;
        public Function<JSGTileEntityConfig, JSGTileEntityConfig> stargateConfig = null;
        @Nonnull
        public EnumIrisMode irisMode = EnumIrisMode.OPENED;
        @Nonnull
        public String irisCode = "";
        public BlockPos dhdPos;
        public int dhdRotation = -1;
        public int dhdFluid = -1;
        public boolean baseInPlace = false;

        public void setStargateEnergyInternalSmart(int energy) {
            int stargateCapacity = (int)((float)((Integer)JSGConfig.Stargate.stargateEnergyStorage.get()).intValue() / 4.0f);
            this.stargateEnergyInternal = Math.min(stargateCapacity, energy);
            for (int toCaps = energy - this.stargateEnergyInternal; toCaps > 0; toCaps -= stargateCapacity) {
                int capacity = Math.min(stargateCapacity, toCaps);
                this.capacitors.add((Pair<Integer, Boolean>)Pair.of((Object)capacity, (Object)false));
            }
        }
    }

    public static enum StargateUpgradesEnum {
        GLYPH_CRYSTAL_TYPE,
        GLYPH_CRYSTAL_STARGATE,
        GLYPH_CRYSTAL_MW,
        GLYPH_CRYSTAL_PEG,
        GLYPH_CRYSTAL_UNI,
        UPGRADE_IRIS_TITANIUM,
        UPGRADE_IRIS_TRINIUM,
        UPGRADE_IRIS_CREATIVE,
        UPGRADE_SHIELD,
        GLYPH_CRYSTAL_DHD,
        UPGRADE_EFFICIENCY_DHD,
        UPGRADE_CAPACITY_DHD;

    }
}

