/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.controller;

import dev.tauri.jsg.api.stargate_listener.StargateListenerHandler;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.power.general.SmallEnergyStorage;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class StargateAbstractController {
    protected final StargateAbstractBaseBE gateTile;

    protected StargateAbstractController(StargateAbstractBaseBE tile) {
        this.gateTile = tile;
    }

    public StargateAbstractBaseBE getStargate() {
        return this.gateTile;
    }

    public BlockPos getGateCenter() {
        return this.getStargate().getGateCenterPos();
    }

    public EnergyRequiredToOperate getEnergyRequired(StargatePos targetGatePos) {
        return this.getStargate().getEnergyRequiredToDialForApi(targetGatePos);
    }

    public boolean isGateUnstable() {
        return this.getStargate().shouldBeUnstable;
    }

    public EnumStargateState getStargateState() {
        return this.getStargate().getStargateState();
    }

    public float getSecondsToClose() {
        return this.getStargate().getEnergySecondsToClose();
    }

    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return this.getStargate().getSupportedOverlays();
    }

    public long getOpenedSeconds() {
        return this.getStargate().getOpenedSeconds();
    }

    public String getOpenedMinutesAndSeconds() {
        return this.getStargate().getOpenedSecondsToDisplayAsMinutes();
    }

    public boolean isMerged() {
        return this.getStargate().isMerged();
    }

    @Deprecated
    public void unMergeGate() {
        this.getStargate().getMergeHelper().updateMemberStateAndCheck(false);
    }

    @Deprecated
    public void mergeGate() {
        this.getStargate().getMergeHelper().updateMemberStateAndCheck(true);
    }

    public int getEnergyTransferedLastTick() {
        return this.getStargate().getEnergyTransferredLastTick();
    }

    public SmallEnergyStorage getEnergyStorage() {
        return this.getStargate().getEnergyStorageForApi();
    }

    public int getEnergyStored() {
        return this.getStargate().getEnergyStorageForApi().getEnergyStored();
    }

    public int getEnergyMaxStored() {
        return this.getStargate().getEnergyStorageForApi().getMaxEnergyStored();
    }

    public void setEnergyStored(int energy) {
        SmallEnergyStorage storage = this.getStargate().getEnergyStorageForApi();
        storage.extractEnergy(storage.getMaxEnergyStored(), false);
        storage.receiveEnergy(energy, false);
    }

    public int receiveEnergy(int energy, boolean simulate) {
        return ((IEnergyStorage)Objects.requireNonNull(this.getStargate().getCapability(ForgeCapabilities.ENERGY, null)).resolve().orElseThrow()).receiveEnergy(energy, simulate);
    }

    public int extractEnergy(int energy, boolean simulate) {
        return ((IEnergyStorage)Objects.requireNonNull(this.getStargate().getCapability(ForgeCapabilities.ENERGY, null)).resolve().orElseThrow()).extractEnergy(energy, simulate);
    }

    public StargateAddressDynamic getDialedAddress() {
        return this.getStargate().getDialedAddress();
    }

    @Nullable
    public StargatePos getTargetGatePos() {
        return this.getStargate().targetGatePos;
    }

    @Nullable
    public StargateAbstractBaseBE getTargetGateTile() {
        if (this.getTargetGatePos() == null) {
            return null;
        }
        return this.getTargetGatePos().getBlockEntity();
    }

    public SymbolTypeEnum<?> getSymbolType() {
        return this.getStargate().getSymbolType();
    }

    public StargateAddress getStargateAddress(SymbolTypeEnum<?> symbolType) {
        return this.getStargate().getStargateAddress(symbolType);
    }

    public void setStargateAddress(StargateAddress address) {
        this.getStargate().setGateAddress(address.getSymbolType(), address);
    }

    public void renameGateInNetwork(String newName) {
        this.getStargate().renameStargatePos(newName);
    }

    public int getMaxChevrons() {
        return this.getStargate().getMaxChevronsForApi();
    }

    public boolean canAddSymbol(SymbolInterface symbol) {
        if (symbol.getSymbolType() != this.getStargate().getSymbolType()) {
            return false;
        }
        return this.getStargate().canAddSymbol(symbol);
    }

    public StargateOpenResult openGate() {
        return this.getStargate().attemptOpenAndFail();
    }

    public void closeGate(StargateClosedReasonEnum reason) {
        this.getStargate().attemptClose(reason);
    }

    public boolean canDialAddress(StargateAddressDynamic address) {
        return this.getStargate().canDialAddress(address);
    }

    public boolean isGateBurried() {
        return this.getStargate().isGateBurried();
    }

    public StargateOpenResult checkAddressAndEnergy(StargateAddressDynamic address) {
        return this.getStargate().checkAddressAndEnergy(address);
    }

    public boolean isNoxDialing() {
        return this.getStargate().isNoxDialing;
    }

    public StargateListenerHandler getListenerHandler() {
        return this.gateTile.listenerHandler;
    }

    public static StargateAbstractController getController(@Nonnull StargateAbstractBaseBE gateTile) {
        return new StargateAbstractController(gateTile);
    }
}

