/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.controller;

import dev.tauri.jsg.api.controller.StargateAbstractController;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.ingame.JSGConfigOption;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.StargateSizeEnum;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import javax.annotation.Nonnull;

public class StargateClassicController
extends StargateAbstractController {
    protected StargateClassicController(StargateClassicBaseBE tile) {
        super(tile);
    }

    @Override
    public StargateClassicBaseBE getStargate() {
        return (StargateClassicBaseBE)super.getStargate();
    }

    public boolean dialAddress(StargateAddressDynamic address, boolean noEnergy, EnumDialingType dialingType) {
        return this.getStargate().dialAddress(address, address.getSize(), noEnergy, dialingType);
    }

    public double getMaxIrisHeat() {
        return this.getStargate().getMaxIrisHeat();
    }

    public double getMaxGateHeat() {
        return this.getStargate().getMaxGateHeat();
    }

    public void heatUpGate(double intensity) {
        this.getStargate().tryHeatUp(intensity);
    }

    public void heatUpIris(double intensity) {
        this.getStargate().tryHeatUp(false, intensity);
    }

    public double getTemperatureAroundGate() {
        return this.getStargate().getTemperatureAroundGate();
    }

    public StargateSizeEnum getGateSize() {
        return this.getStargate().getStargateSizeForApi();
    }

    public boolean attemptAbortDialing() {
        return this.getStargate().abortDialingSequence();
    }

    public boolean isDialingWithoutEnergy() {
        return this.getStargate().isDialingWithoutEnergy();
    }

    public boolean addSymbolToAddress(boolean useDHD, SymbolInterface symbol) {
        if (!this.getStargate().getStargateState().idle()) {
            return false;
        }
        if (useDHD && this.getStargate().getSymbolType() != SymbolTypeRegistry.UNIVERSE) {
            this.getStargate().addSymbolToAddressDHD(symbol);
        } else {
            this.getStargate().addSymbolToAddressManual(symbol, null);
        }
        return true;
    }

    public JSGTileEntityConfig getGateConfig() {
        return this.getStargate().getConfig();
    }

    public JSGConfigOption<?> getGateConfigOption(String name) {
        return this.getStargate().getConfig().getOption(name);
    }

    public void saveGateConfig(JSGTileEntityConfig config) {
        this.getStargate().setConfigAndUpdate(config);
    }

    public int getSupportedCapacitors() {
        return this.getStargate().getSupportedCapacitors();
    }

    public boolean openIris() {
        if (this.getStargate().isIrisOpened()) {
            return false;
        }
        this.getStargate().toggleIris();
        return true;
    }

    public boolean openTargetIris() {
        StargateAbstractBaseBE t = this.getTargetGateTile();
        if (t == null) {
            return false;
        }
        if (!(t instanceof StargateClassicBaseBE)) {
            return false;
        }
        StargateClassicBaseBE c = (StargateClassicBaseBE)t;
        if (c.isIrisOpened()) {
            return false;
        }
        c.toggleIris();
        return true;
    }

    public boolean closeIris() {
        if (this.getStargate().isIrisClosed()) {
            return false;
        }
        this.getStargate().toggleIris();
        return true;
    }

    public boolean closeTargetIris() {
        StargateAbstractBaseBE t = this.getTargetGateTile();
        if (t == null) {
            return false;
        }
        if (!(t instanceof StargateClassicBaseBE)) {
            return false;
        }
        StargateClassicBaseBE c = (StargateClassicBaseBE)t;
        if (c.isIrisClosed()) {
            return false;
        }
        c.toggleIris();
        return true;
    }

    public static StargateClassicController getController(@Nonnull StargateClassicBaseBE gateTile) {
        return new StargateClassicController(gateTile);
    }
}

