/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.loader.holder;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.TextureOverlay;
import dev.tauri.jsg.api.loader.holder.ExampleTextureOverlay;
import dev.tauri.jsg.api.loader.model.APIOBJLoader;
import dev.tauri.jsg.api.loader.texture.APITextureLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum ExampleModelHolder {
    EXAMPLE_MODEL("my_model.obj", "my_texture.obj", true);

    public final ResourceLocation model;
    public final Map<TextureOverlay, ResourceLocation> biomeTextureResourceMap = new HashMap<TextureOverlay, ResourceLocation>();
    private final List<TextureOverlay> nonExistingReported = new ArrayList<TextureOverlay>();
    public final APIOBJLoader OBJ_LOADER = APIOBJLoader.createLoader("jsg", JSG.class);
    public final APITextureLoader TEXTURE_LOADER = APITextureLoader.createLoader("jsg", JSG.class);

    private ExampleModelHolder(String modelPath, String texturePath, boolean byOverlay) {
        this.model = this.OBJ_LOADER.getModelResource(modelPath);
        for (ExampleTextureOverlay texOverlay : ExampleTextureOverlay.values()) {
            if (!byOverlay) {
                this.biomeTextureResourceMap.put(texOverlay, this.TEXTURE_LOADER.getTextureResource(texturePath));
                continue;
            }
            String[] split = texturePath.split("\\.");
            this.biomeTextureResourceMap.put(texOverlay, this.TEXTURE_LOADER.getTextureResource(split[0] + texOverlay.getSuffix() + "." + split[1]));
        }
    }

    public void render(PoseStack ps) {
        this.OBJ_LOADER.getModel(this.model).render(ps);
    }

    public void bindTexture(TextureOverlay overlay) {
        ResourceLocation resourceLocation = this.biomeTextureResourceMap.get(overlay);
        this.bindTexture(overlay, resourceLocation);
    }

    private void bindTexture(TextureOverlay overlay, ResourceLocation resourceLocation) {
        if (!this.TEXTURE_LOADER.isTextureLoaded(resourceLocation)) {
            if (!this.nonExistingReported.contains(overlay)) {
                JSG.logger.error(String.valueOf((Object)this) + " tried to use BiomeOverlay " + String.valueOf(overlay) + " but it doesn't exist. (" + String.valueOf(resourceLocation) + ")");
                this.nonExistingReported.add(overlay);
            }
            resourceLocation = this.biomeTextureResourceMap.get(ExampleTextureOverlay.NORMAL);
        }
        this.TEXTURE_LOADER.getTexture(resourceLocation).bindTexture();
    }

    public void bindTextureAndRender(PoseStack ps) {
        this.bindTextureAndRender(ExampleTextureOverlay.NORMAL, ps);
    }

    public void bindTextureAndRender(TextureOverlay biomeOverlay, PoseStack ps) {
        this.bindTexture(biomeOverlay);
        this.render(ps);
    }
}

