/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate_listener;

import dev.tauri.jsg.api.stargate_listener.IStargateListener;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.codesender.CodeSender;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StargateListenerHandler {
    private final Map<BlockPos, IStargateListener> LISTENERS = new HashMap<BlockPos, IStargateListener>();
    public final StargateAbstractBaseBE gateEntity;

    public StargateListenerHandler(StargateAbstractBaseBE gateEntity) {
        this.gateEntity = gateEntity;
    }

    public void addListener(IStargateListener listener) {
        this.LISTENERS.put(listener.getListenerBlockPos(), listener);
    }

    public void removeListener(IStargateListener listener) {
        this.LISTENERS.remove(listener.getListenerBlockPos());
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        CompoundTag ent = new CompoundTag();
        ent.m_128405_("size", this.LISTENERS.keySet().size());
        int i = 0;
        for (BlockPos pos : this.LISTENERS.keySet()) {
            ent.m_128356_("pos_" + i, pos.m_121878_());
            ++i;
        }
        compound.m_128365_("listeners", (Tag)ent);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.LISTENERS.clear();
        CompoundTag ent = compound.m_128469_("listeners");
        int size = ent.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            this.LISTENERS.put(BlockPos.m_122022_((long)ent.m_128454_("pos_" + i)), null);
        }
        this.reloadStargateListeners();
    }

    private void reloadStargateListeners() {
        Level level = this.gateEntity.m_58904_();
        if (level == null) {
            return;
        }
        List poses = this.LISTENERS.keySet().stream().toList();
        for (BlockPos pos : poses) {
            BlockEntity entity = level.m_7702_(pos);
            Block block = level.m_8055_(pos).m_60734_();
            if (entity instanceof IStargateListener) {
                IStargateListener listener = (IStargateListener)entity;
                this.LISTENERS.put(pos, listener);
                continue;
            }
            if (!(block instanceof IStargateListener)) continue;
            IStargateListener listener = (IStargateListener)block;
            this.LISTENERS.put(pos, listener);
        }
    }

    public void gateOpen() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateOpen();
        }
    }

    public void gateClose(StargateClosedReasonEnum reason) {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateClose(reason);
        }
    }

    public void gateDisconnect() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateDisconnect();
        }
    }

    public void gateSymbolEngage(SymbolInterface symbol) {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateSymbolEngage(symbol);
        }
    }

    public void gateFail(StargateOpenResult result) {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateFail(result);
        }
    }

    public void gateIncoming(int dialedAddressSize) {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateIncoming(dialedAddressSize);
        }
    }

    public void gateBeginDial() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateBeginDial();
        }
    }

    public void irisCloses() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.irisCloses();
        }
    }

    public void irisOpens() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.irisOpens();
        }
    }

    public void irisHit() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.irisHit();
        }
    }

    public boolean receiveIDC(CodeSender sender, String code) {
        boolean result = false;
        for (IStargateListener l : this.LISTENERS.values()) {
            result |= l.receiveIDC(sender, code);
        }
        return result;
    }

    public void gateRingSpin() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateRingSpin();
        }
    }

    public void gateDialAbort() {
        for (IStargateListener l : this.LISTENERS.values()) {
            l.gateDialAbort();
        }
    }
}

