/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.capacitor;

import dev.tauri.jsg.block.IItemBlock;
import dev.tauri.jsg.block.TickableBEBlock;
import dev.tauri.jsg.blockentity.capacitor.CapacitorBE;
import dev.tauri.jsg.blockentity.capacitor.CapacitorBECreative;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.item.JSGBlockItem;
import dev.tauri.jsg.item.energy.CapacitorItemBlock;
import dev.tauri.jsg.power.general.ItemEnergyStorage;
import dev.tauri.jsg.power.general.SmallEnergyStorage;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.screen.inventory.energy.capacitor.CapacitorContainer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapacitorBlock
extends TickableBEBlock
implements IItemBlock {
    public final boolean creative;

    public CapacitorBlock(boolean creative) {
        super(BlockBehaviour.Properties.m_284310_().m_60924_((blockState, blockGetter, pos) -> true).m_155956_(30.0f).m_155954_(creative ? -1.0f : 3.0f).m_60999_());
        this.creative = creative;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)Direction.NORTH)).m_61124_((Property)JSGProperties.LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.rotateDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), rotation));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.flipDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), mirror));
    }

    @Override
    public JSGBlockItem getItemBlock() {
        return new CapacitorItemBlock(this, this.creative);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        if (this.creative) {
            return new CapacitorBECreative(blockPos, blockState);
        }
        return new CapacitorBE(blockPos, blockState);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{JSGProperties.FACING_HORIZONTAL_PROPERTY});
        builder.m_61104_(new Property[]{JSGProperties.LEVEL});
        super.m_7926_(builder);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean shift = player.m_6144_();
        boolean guiDisplayed = false;
        if (!level.f_46443_ && !shift) {
            guiDisplayed = this.showGui(player, hand, level, pos);
        }
        return !shift && guiDisplayed ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    protected boolean showGui(Player player, InteractionHand hand, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CapacitorBE) {
            CapacitorBE capTile = (CapacitorBE)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new SimpleMenuProvider((id, pInv, p) -> new CapacitorContainer(id, pInv, capTile), (Component)Component.m_237119_()), (BlockPos)pos);
                return true;
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(level, pos, state, placer, itemStack);
        if (level.f_46443_) {
            return;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (tile == null) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(ForgeCapabilities.ENERGY, null).resolve().get();
        SmallEnergyStorage capacitorEnergyStorage = (SmallEnergyStorage)((Object)tile.getCapability(ForgeCapabilities.ENERGY, null).resolve().get());
        capacitorEnergyStorage.setEnergyStored(energyStorage.getEnergyStored());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Player placer = ctx.m_43723_();
        if (placer == null) {
            return this.m_49966_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)placer.m_6350_().m_122424_());
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        ServerLevel level = params.m_287258_();
        Vec3 vec = (Vec3)params.m_287261_(LootContextParams.f_81460_);
        BlockPos pos = new BlockPos((int)(vec.f_82479_ - 0.5), (int)(vec.f_82480_ - 0.5), (int)(vec.f_82481_ - 0.5));
        SmallEnergyStorage capacitorEnergyStorage = (SmallEnergyStorage)((Object)level.m_7702_(pos).getCapability(ForgeCapabilities.ENERGY, null).resolve().get());
        ItemStack stack = new ItemStack((ItemLike)this);
        ((ItemEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).resolve().get()).setEnergyStored(capacitorEnergyStorage.getEnergyStored());
        return Arrays.asList(stack);
    }
}

