/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.crystal;

import dev.tauri.jsg.block.crystal.CrystalColor;
import dev.tauri.jsg.item.ITabbedItem;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.RegistryObject;

public class CrystalBuddingBlock
extends BuddingAmethystBlock
implements ITabbedItem {
    public final CrystalColor color;

    public CrystalBuddingBlock(CrystalColor color) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152491_).m_284268_(color.color));
        this.color = color;
    }

    @ParametersAreNonnullByDefault
    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188503_(5) == 0) {
            this.tryGrow(pLevel, pPos, pRandom);
        }
    }

    public void tryGrow(ServerLevel level, BlockPos buddingPos, RandomSource random) {
        Direction direction = Direction.values()[random.m_188503_(Direction.values().length)];
        BlockPos blockpos = buddingPos.m_121945_(direction);
        BlockState currentState = level.m_8055_(blockpos);
        Block block = null;
        if (CrystalBuddingBlock.m_152734_((BlockState)currentState)) {
            block = (Block)BlockRegistry.CRYSTAL_BUD_SMALL.get((Object)this.color).get();
        } else if (currentState.m_60713_((Block)BlockRegistry.CRYSTAL_BUD_SMALL.get((Object)this.color).get()) && currentState.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
            block = (Block)BlockRegistry.CRYSTAL_BUD_MEDIUM.get((Object)this.color).get();
        } else if (currentState.m_60713_((Block)BlockRegistry.CRYSTAL_BUD_MEDIUM.get((Object)this.color).get()) && currentState.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
            block = (Block)BlockRegistry.CRYSTAL_BUD_LARGE.get((Object)this.color).get();
        } else if (currentState.m_60713_((Block)BlockRegistry.CRYSTAL_BUD_LARGE.get((Object)this.color).get()) && currentState.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
            block = (Block)BlockRegistry.CRYSTAL_CLUSTER.get((Object)this.color).get();
        }
        if (block != null) {
            BlockState newState = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)AmethystClusterBlock.f_152006_, (Comparable)direction)).m_61124_((Property)AmethystClusterBlock.f_152005_, (Comparable)Boolean.valueOf(currentState.m_60819_().m_76152_() == Fluids.f_76193_));
            level.m_46597_(blockpos, newState);
        }
    }

    @Override
    public RegistryObject<CreativeModeTab> getTab() {
        return TabRegistry.TAB_RESOURCES;
    }
}

