/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.stargate;

import dev.tauri.jsg.block.stargate.StargateAbstractBaseBlock;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.property.JSGProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StargateOrlinBaseBlock
extends StargateAbstractBaseBlock {
    public StargateOrlinBaseBlock() {
        super(STARGATE_BASE_PROPS.m_60924_((pState, level, pos) -> true));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.ORLIN_BROKEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JSGProperties.ORLIN_BROKEN});
    }

    @Override
    protected boolean showGateInfo(Player player, InteractionHand hand, Level world, BlockPos pos) {
        if (world.f_46443_) {
            return false;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof StargateOrlinBaseBE)) {
            return false;
        }
        StargateOrlinBaseBE baseTile = (StargateOrlinBaseBE)blockEntity;
        Optional energyStorage = baseTile.getCapability(ForgeCapabilities.ENERGY).resolve();
        if (energyStorage.isEmpty()) {
            return false;
        }
        int energyStored = baseTile.getEnergyStored();
        String energyString = String.format("%,d", energyStored);
        EnergyRequiredToOperate energyNeeded = baseTile.getEnergyRequiredToDial();
        if (energyNeeded == null) {
            return false;
        }
        String neededString = String.format("%,d", energyNeeded.energyToOpen);
        boolean hasEnergy = energyStored >= energyNeeded.energyToOpen;
        int missing = energyNeeded.energyToOpen - energyStored;
        float secondsLeft = 0.0f;
        if (missing > 0 && baseTile.getEnergyTransferredLastTick() > 0) {
            secondsLeft = (float)missing / (float)baseTile.getEnergyTransferredLastTick() / 20.0f;
        }
        String secondsLeftString = String.format("%.2f", Float.valueOf(secondsLeft));
        player.m_213846_((Component)Component.m_237110_((String)"chat.orlins.energyStored", (Object[])new Object[]{(hasEnergy ? "\u00a7a" : "\u00a7c") + energyString, "\u00a72" + neededString, "\u00a72" + secondsLeftString}));
        return true;
    }

    @Override
    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        if (itemStack.m_41782_()) {
            CompoundTag page;
            CompoundTag compound = itemStack.m_41784_();
            if (compound.m_128441_("openCount")) {
                components.add((Component)Component.m_237110_((String)"block.jsg.stargate_orlin_base_block.open_count", (Object[])new Object[]{compound.m_128451_("openCount"), JSGConfig.Stargate.stargateOrlinMaxOpenCount.get()}));
            }
            if (compound.m_128441_("notebook_page") && (page = (CompoundTag)compound.m_128423_("notebook_page")) != null) {
                String name = PageNotebookItemFilled.getNameFromCompound(page);
                components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + name)));
            }
        }
        super.m_5871_(itemStack, blockGetter, components, tooltipFlag);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new StargateOrlinBaseBE(pPos, pState);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof StargateOrlinBaseBE) {
            StargateOrlinBaseBE baseTile = (StargateOrlinBaseBE)blockEntity;
            baseTile.initializeFromItemStack(itemStack);
        }
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        Object object = pParams.m_287159_(LootContextParams.f_81462_);
        if (object instanceof StargateOrlinBaseBE) {
            StargateOrlinBaseBE baseTile = (StargateOrlinBaseBE)object;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            baseTile.addDrops(drops);
            return drops;
        }
        return super.m_49635_(pState, pParams);
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof StargateOrlinBaseBE) {
            StargateOrlinBaseBE baseTile = (StargateOrlinBaseBE)blockEntity;
            baseTile.redstonePowerUpdate(pLevel.m_276867_(pPos));
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (((Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY)).booleanValue()) {
            return Shapes.m_83144_();
        }
        if (JSGProperties.getDirectionByVerticalFacing((Integer)blockState.m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY)) == null) {
            return Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.4, (double)1.0);
        }
        return Shapes.m_166049_((double)0.0, (double)0.25, (double)0.0, (double)1.0, (double)0.75, (double)1.0);
    }

    @ParametersAreNonnullByDefault
    public boolean m_7899_(BlockState pState) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_7278_(BlockState pState) {
        return true;
    }
}

