/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.capacitor;

import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.power.general.SmallEnergyStorage;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.screen.inventory.energy.capacitor.CapacitorContainerGuiUpdate;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.energy.CapacitorPowerLevelUpdate;
import dev.tauri.jsg.util.ITickable;
import dev.tauri.jsg.util.JSGItemStackHandler;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CapacitorBE
extends BlockEntity
implements ITickable,
ICapabilityProvider,
StateProviderInterface {
    protected final ItemStackHandler itemStackHandler = new JSGItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.getCapability(ForgeCapabilities.ENERGY, null).isPresent();
            }
            return true;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CapacitorBE.this.m_6596_();
        }
    };
    private final SmallEnergyStorage energyStorage = new SmallEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            CapacitorBE.this.m_6596_();
        }
    };
    protected int energyStoredLastTick = 0;
    protected int energyTransferedLastTick = 0;
    private PacketDistributor.TargetPoint targetPoint;
    private int powerLevel;
    private int lastPowerLevel;

    public CapacitorBE(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    public CapacitorBE(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.CAPACITOR_BLOCK.get(), pos, state);
    }

    public PacketDistributor.TargetPoint getTargetPoint() {
        return this.targetPoint;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public SmallEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void onLoad() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.targetPoint = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 512.0, this.f_58857_.m_46472_());
        } else {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateTypeEnum.RENDERER_UPDATE));
        }
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            for (Direction facing : Direction.values()) {
                Optional cap;
                BlockEntity tile = this.f_58857_.m_7702_(this.m_58899_().m_121955_(facing.m_122436_()));
                if (tile == null || (cap = tile.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).resolve()).isEmpty()) continue;
                int extracted = this.getEnergyStorage().extractEnergy((Integer)JSGConfig.Stargate.stargateMaxEnergyTransfer.get(), true);
                extracted = ((IEnergyStorage)cap.get()).receiveEnergy(extracted, false);
                this.getEnergyStorage().extractEnergy(extracted, false);
            }
            ItemStack stack = this.itemStackHandler.getStackInSlot(0);
            if (!stack.m_41619_() && stack.getCapability(ForgeCapabilities.ENERGY, null).isPresent()) {
                IEnergyStorage targetEnergyStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).resolve().get();
                int extracted = this.getEnergyStorage().extractEnergy((Integer)JSGConfig.Stargate.stargateMaxEnergyTransfer.get(), true);
                extracted = targetEnergyStorage.receiveEnergy(extracted, false);
                this.getEnergyStorage().extractEnergy(extracted, false);
            }
            this.powerLevel = Math.round((float)this.getEnergyStorage().getEnergyStored() / (float)this.getEnergyStorage().getMaxEnergyStored() * 10.0f);
            if (this.powerLevel != this.lastPowerLevel) {
                this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)JSGProperties.LEVEL, (Comparable)Integer.valueOf(this.powerLevel)), 3);
                JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE)), this.targetPoint);
                this.lastPowerLevel = this.powerLevel;
            }
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("energyStorage", (Tag)this.getEnergyStorage().serializeNBT());
        compound.m_128365_("itemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.getEnergyStorage().deserializeNBT(compound.m_128469_("energyStorage"));
        this.itemStackHandler.deserializeNBT(compound.m_128469_("itemStackHandler"));
        super.m_142466_(compound);
    }

    public int getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(this::getEnergyStorage).cast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemStackHandler).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new CapacitorPowerLevelUpdate(this.powerLevel);
            }
            case GUI_UPDATE: {
                return new CapacitorContainerGuiUpdate(this.getEnergyStorage().getEnergyStored(), this.energyTransferedLastTick);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new CapacitorPowerLevelUpdate();
            }
            case GUI_UPDATE: {
                return new CapacitorContainerGuiUpdate();
            }
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                this.powerLevel = ((CapacitorPowerLevelUpdate)state).powerLevel;
                this.m_6596_();
                this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)JSGProperties.LEVEL, (Comparable)Integer.valueOf(this.powerLevel)), 3);
                this.f_58857_.m_151543_(this.m_58899_());
                break;
            }
            case GUI_UPDATE: {
                CapacitorContainerGuiUpdate guiUpdate = (CapacitorContainerGuiUpdate)state;
                this.getEnergyStorage().setEnergyStored(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                break;
            }
        }
    }

    @Override
    public void sendState(StateTypeEnum type, State state) {
    }
}

