/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.dialhomedevice;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.config.ingame.JSGBooleanConfigOption;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.dialhomedevice.DHDMilkyWayRendererState;
import dev.tauri.jsg.screen.util.DHDScreenHelper;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolMilkyWayEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.dialhomedevice.DHDActivateButtonState;
import dev.tauri.jsg.state.stargate.StargateBiomeOverrideState;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class DHDMilkyWayBE
extends DHDAbstractBE {
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.SOOTY, BiomeOverlayEnum.AGED);

    public DHDMilkyWayBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.DHD_MILKYWAY.get(), pos, state);
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    public void tick() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 40L == 0L && this.rendererStateClient != null && this.getRendererStateClient().biomeOverride == null) {
            this.rendererStateClient.setBiomeOverlay(BiomeOverlayEnum.updateBiomeOverlay(this.f_58857_, this.m_58899_(), SUPPORTED_OVERLAYS));
        }
        super.tick();
    }

    @Override
    public DHDScreenHelper getScreenHelper() {
        return DHDScreenHelper.getMilkyWay();
    }

    @Override
    public SymbolTypeEnum<?> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    @Override
    public Item getControlCrystal() {
        return (Item)ItemRegistry.CRYSTAL_CONTROL_MILKYWAY_DHD.get();
    }

    @Override
    public void activateSymbol(SymbolInterface symbolInt) {
        if (this.f_58857_ == null) {
            return;
        }
        StargateAbstractBaseBE gateTile = this.getLinkedDevice();
        if (gateTile == null) {
            return;
        }
        SymbolMilkyWayEnum symbol = SymbolTypeRegistry.MILKYWAY.valueOf(symbolInt.getId());
        if (!gateTile.getStargateState().dialingComputer() || ((Boolean)((JSGBooleanConfigOption)((StargateClassicBaseBE)gateTile).getConfig().getOption("dhdPressSound")).getValue()).booleanValue()) {
            if (symbol.brb()) {
                JSGSoundHelper.playSoundEvent(this.f_58857_, this.m_58899_(), SoundEventEnum.DHD_MILKYWAY_PRESS_BRB);
            } else {
                JSGSoundHelper.playSoundEvent(this.f_58857_, this.m_58899_(), SoundEventEnum.DHD_MILKYWAY_PRESS);
            }
        }
        this.f_58857_.m_151543_(this.m_58899_());
        this.sendState(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(symbol));
    }

    @Override
    public void pushSymbolButton(SymbolInterface symbol, @Nullable ServerPlayer player, boolean force) {
        if (((IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().orElseThrow()).getStackInSlot(0).m_41619_()) {
            if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.no_crystal_warn"), true);
            }
            return;
        }
        if (!this.isLinked()) {
            if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.not_linked_warn"), true);
            }
            return;
        }
        StargateClassicBaseBE gateTile = (StargateClassicBaseBE)this.getLinkedDevice();
        EnumStargateState gateState = Objects.requireNonNull(gateTile).getStargateState();
        if (gateState.engaged() && symbol.brb()) {
            if (gateState.initiating()) {
                gateTile.attemptClose(StargateClosedReasonEnum.REQUESTED);
            } else if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.incoming_wormhole_warn"), true);
            }
        } else if (gateState.idle()) {
            if (symbol.brb()) {
                StargateOpenResult openResult = gateTile.attemptOpenAndFail();
                if (openResult.ok()) {
                    JSGAdvancements.CHEVRON_SEVEN_LOCKED.trigger(player);
                }
                if (openResult == StargateOpenResult.NOT_ENOUGH_POWER && player != null) {
                    player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.not_enough_power"), true);
                }
            } else if (gateTile.canAddSymbol(symbol)) {
                gateTile.addSymbolToAddressDHD(symbol);
            }
        }
    }

    @Override
    public void updateLinkStatus(Level world, BlockPos pos) {
        StargateMilkyWayBaseBE gateTile;
        world = this.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos closestGate = LinkingHelper.findClosestUnlinked(world, pos, LinkingHelper.getDhdRange(), BlockRegistry.STARGATE_MILKYWAY_BASE_BLOCKS);
        if (closestGate != null && (gateTile = (StargateMilkyWayBaseBE)world.m_7702_(closestGate)) != null) {
            gateTile.setLinkedDevice(pos);
            this.setLinkedDevice(closestGate);
        }
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            StargateAbstractBaseBE gateTile;
            StargateAddressDynamic address = new StargateAddressDynamic(SymbolTypeRegistry.MILKYWAY);
            JSGTileEntityConfig config = new JSGTileEntityConfig();
            if (this.isLinked() && (gateTile = this.getLinkedDevice()) != null) {
                address.addAll(gateTile.getDialedAddress());
                boolean brbActive = false;
                switch (gateTile.getStargateState()) {
                    case ENGAGED_INITIATING: {
                        brbActive = true;
                        break;
                    }
                    case ENGAGED: {
                        address.clear();
                        brbActive = true;
                        break;
                    }
                }
                if (gateTile instanceof StargateClassicBaseBE) {
                    config = ((StargateClassicBaseBE)gateTile).getConfig();
                }
                return new DHDMilkyWayRendererState(address, brbActive, this.determineBiomeOverride(), gateTile.connectedToGate, config);
            }
            return new DHDMilkyWayRendererState(address, false, this.determineBiomeOverride(), false, config);
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            return new DHDMilkyWayRendererState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        StargateAbstractBaseBE gateTile;
        if (this.f_58857_ == null) {
            return;
        }
        boolean connected = false;
        if (this.isLinked() && (gateTile = this.getLinkedDevice()) != null) {
            connected = gateTile.connectedToGate;
        }
        switch (stateType) {
            case RENDERER_STATE: {
                this.rendererStateClient = ((DHDMilkyWayRendererState)state).initClient(this.m_58899_(), BiomeOverlayEnum.updateBiomeOverlay(this.f_58857_, this.m_58899_(), SUPPORTED_OVERLAYS), connected);
                break;
            }
            case DHD_ACTIVATE_BUTTON: {
                if (state == null) break;
                DHDActivateButtonState activateState = (DHDActivateButtonState)state;
                this.getRendererStateClient().setIsConnected(connected);
                if (activateState.clearAll) {
                    ((DHDMilkyWayRendererState)this.getRendererStateClient()).clearSymbols(this.f_58857_.m_46467_());
                    break;
                }
                ((DHDMilkyWayRendererState)this.getRendererStateClient()).activateSymbol(this.f_58857_.m_46467_(), SymbolTypeRegistry.MILKYWAY.valueOf(activateState.symbol));
                break;
            }
            case BIOME_OVERRIDE_STATE: {
                StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
                if (this.rendererStateClient == null) break;
                this.getRendererStateClient().biomeOverride = overrideState.biomeOverride;
                break;
            }
            default: {
                super.setState(stateType, state);
            }
        }
    }
}

