/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.StargateGenerator;
import dev.tauri.jsg.block.stargate.redstone.AbstractStargateRedstoneIO;
import dev.tauri.jsg.blockentity.IPreparable;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargatePegasusBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.blockentity.util.IUpgradable;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.ingame.ITileConfig;
import dev.tauri.jsg.config.ingame.JSGBooleanConfigOption;
import dev.tauri.jsg.config.ingame.JSGConfigOption;
import dev.tauri.jsg.config.ingame.JSGIntRangeConfigOption;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfigEntry;
import dev.tauri.jsg.config.util.JSGConfigUtil;
import dev.tauri.jsg.helpers.BlockHelpers;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.FluidHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.helpers.StargateTemperatureHelper;
import dev.tauri.jsg.integration.create.CreateIntegrationManager;
import dev.tauri.jsg.item.energy.CapacitorItemBlock;
import dev.tauri.jsg.item.linkable.gdo.GDOMessages;
import dev.tauri.jsg.item.stargate.IrisItem;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.power.general.LargeEnergyStorage;
import dev.tauri.jsg.power.general.SmallEnergyStorage;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGuiState;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGuiUpdate;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.stargate.EnumIrisState;
import dev.tauri.jsg.stargate.EnumIrisType;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumSpinDirection;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.NearbyGate;
import dev.tauri.jsg.stargate.StargateClassicSpinHelper;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargateSizeEnum;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.codesender.CodeSender;
import dev.tauri.jsg.stargate.codesender.CodeSenderType;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.stargate.StargateBiomeOverrideState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.state.stargate.StargateSpinState;
import dev.tauri.jsg.util.EnumKeyInterface;
import dev.tauri.jsg.util.EnumKeyMap;
import dev.tauri.jsg.util.ILinkable;
import dev.tauri.jsg.util.JSGAdvancementsUtil;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import dev.tauri.jsg.util.JSGItemStackHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class StargateClassicBaseBE
extends StargateAbstractBaseBE
implements IUpgradable,
ITileConfig,
IPreparable {
    private EnumIrisState irisState = EnumIrisState.OPENED;
    private EnumIrisType irisType = EnumIrisType.NULL;
    private String irisCode = "";
    protected EnumIrisMode irisMode = EnumIrisMode.OPENED;
    private long irisAnimation = 0L;
    public int shieldKeepAlive = 0;
    public int irisDurability = 0;
    public int irisMaxDurability = 0;
    protected boolean isFinalActive;
    public boolean isFastDialing;
    public boolean isFastDialingOverride;
    protected double lastIrisHeat = -2.0;
    protected double lastGateHeat = -2.0;
    public double irisHeat;
    public double gateHeat;
    public static final double IRIS_MAX_HEAT_TITANIUM = (Double)JSGConfig.Stargate.irisTitaniumMaxHeat.get();
    public static final double IRIS_MAX_HEAT_TRINIUM = (Double)JSGConfig.Stargate.irisTriniumMaxHeat.get();
    public static final double GATE_MAX_HEAT = (Double)JSGConfig.Stargate.gateMaxHeat.get();
    protected StargateSizeEnum stargateSize = (StargateSizeEnum)((Object)JSGConfig.Stargate.stargateSize.get());
    protected boolean dialingWithoutEnergy = false;
    public boolean needRegenerate = false;
    private BlockPos lastPos = BlockPos.f_121853_;
    protected int incomingAddressSize = -1;
    protected int incomingPeriod = -1;
    protected int incomingLastChevronLightUp = -1;
    protected JSGTileEntityConfig config;
    protected long lastSpinFinishedIn = 0L;
    protected boolean isSpinning;
    protected long spinStartTime;
    protected SymbolInterface currentRingSymbol = this.getSymbolType().getTopSymbol();
    protected SymbolInterface targetRingSymbol = this.getSymbolType().getTopSymbol();
    protected EnumSpinDirection spinDirection = EnumSpinDirection.COUNTER_CLOCKWISE;
    protected Object ringSpinContext;
    private short pageProgress = 0;
    private int pageSlotId;
    private boolean doPageProgress;
    private ScheduledTask givePageTask;
    private boolean lockPage;
    public static final int BIOME_OVERRIDE_SLOT = 10;
    private final JSGItemStackHandler itemStackHandler = new JSGItemStackHandler(12){

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.m_41720_();
            boolean isItemCapacitor = item instanceof CapacitorItemBlock;
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return StargateUpgradeEnum.contains(item) && !StargateClassicBaseBE.this.hasUpgrade(item);
                }
                case 4: {
                    return isItemCapacitor && StargateClassicBaseBE.this.getSupportedCapacitors() >= 1;
                }
                case 5: {
                    return isItemCapacitor && StargateClassicBaseBE.this.getSupportedCapacitors() >= 2;
                }
                case 6: {
                    return isItemCapacitor && StargateClassicBaseBE.this.getSupportedCapacitors() >= 3;
                }
                case 7: 
                case 8: {
                    return item == ItemRegistry.NOTEBOOK_PAGE_EMPTY.get() || item == ItemRegistry.NOTEBOOK_PAGE_FILLED.get();
                }
                case 9: {
                    return item == ItemRegistry.NOTEBOOK_PAGE_EMPTY.get() || item == ItemRegistry.NOTEBOOK_PAGE_FILLED.get() || item == ItemRegistry.UNIVERSE_DIALER.get();
                }
                case 10: {
                    BiomeOverlayEnum override = JSGConfigUtil.getBiomeOverrideItemMetaPairs().get(Block.m_49814_((Item)stack.m_41720_()));
                    if (override == null) {
                        return false;
                    }
                    return StargateClassicBaseBE.this.getSupportedOverlays().contains(override);
                }
                case 11: {
                    return StargateClassicBaseBE.this.canInsertItemAsIris(item);
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            switch (slot) {
                case 4: 
                case 5: 
                case 6: {
                    StargateClassicBaseBE.this.updatePowerTier();
                    break;
                }
                case 10: {
                    StargateClassicBaseBE.this.sendState(StateTypeEnum.BIOME_OVERRIDE_STATE, new StargateBiomeOverrideState(StargateClassicBaseBE.this.determineBiomeOverride()));
                    break;
                }
                case 11: {
                    StargateClassicBaseBE.this.updateIrisType();
                    break;
                }
            }
            StargateClassicBaseBE.this.m_6596_();
        }
    };
    public CodeSender codeSender;
    private Runnable afterIrisDone = null;
    private static final List<Integer> UPGRADE_SLOTS_IDS = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 11));
    private final LargeEnergyStorage energyStorage = new LargeEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            StargateClassicBaseBE.this.m_6596_();
        }
    };
    public int currentPowerTier = 1;
    protected ResourceKey<Level> lastFakeWorld = null;
    protected BlockPos lastFakePos = this.getFakePos();
    protected final List<BlockPos> REDSTONE_IO_BLOCKS = new ArrayList<BlockPos>();

    public StargateClassicBaseBE(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public boolean isFinalActive() {
        return this.isFinalActive;
    }

    public boolean getFastDialState() {
        return this.isFastDialing;
    }

    public void setFastDial(boolean state) {
        if (this.stargateState.idle()) {
            this.isFastDialing = state;
        }
        this.m_6596_();
    }

    public void tryHeatUp(boolean byIrisHit, double irisHeatUpCoefficient) {
        this.tryHeatUp(byIrisHit, false, 1.0, irisHeatUpCoefficient, 1.0, -1.0, -1.0);
    }

    public void tryHeatUp(double gateHeatUpCoefficient) {
        this.tryHeatUp(false, true, gateHeatUpCoefficient, 1.0, 1.0, -1.0, -1.0);
    }

    public double getMaxIrisHeat() {
        if (this.hasShieldIris() || this.hasCreativeIris()) {
            return Double.MAX_VALUE;
        }
        return this.getIrisType() == EnumIrisType.IRIS_TRINIUM ? IRIS_MAX_HEAT_TRINIUM : IRIS_MAX_HEAT_TITANIUM;
    }

    public double getMaxGateHeat() {
        return GATE_MAX_HEAT;
    }

    public void tryHeatUp(boolean heatUpIris, boolean heatUpGate, double gateHeatUpCoefficient, double irisHeatUpCoefficient, double coolDownCoefficient, double maxHeatByAround, double minHeatByAround) {
        double heatUpCoefficientConst = 0.7;
        double coolDownCoefficientConst = 0.3;
        if ((heatUpGate || Math.abs(this.gateHeat - this.irisHeat) >= 50.0) && (maxHeatByAround == -1.0 || this.gateHeat + 0.7 * gateHeatUpCoefficient <= maxHeatByAround)) {
            this.gateHeat += 0.7 * gateHeatUpCoefficient;
        }
        if (minHeatByAround == -1.0 || this.gateHeat - 0.3 * coolDownCoefficient > minHeatByAround) {
            this.gateHeat -= 0.3 * coolDownCoefficient;
        }
        if ((heatUpIris || Math.abs(this.gateHeat - this.irisHeat) >= 25.0) && (maxHeatByAround == -1.0 || this.irisHeat + 0.7 * irisHeatUpCoefficient <= maxHeatByAround)) {
            this.irisHeat += 0.7 * irisHeatUpCoefficient;
        }
        if (minHeatByAround == -1.0 || this.irisHeat - 0.3 * coolDownCoefficient > minHeatByAround) {
            this.irisHeat -= 0.3 * coolDownCoefficient;
        }
        ItemStack irisItem = this.getItemHandler().getStackInSlot(11);
        double maxHeat = this.getMaxIrisHeat();
        if (this.irisHeat >= maxHeat) {
            int heatCoefficient = (int)Math.round(Math.abs(this.irisHeat - maxHeat));
            if (((Boolean)JSGConfig.Stargate.enableIrisOverHeatCollapse.get()).booleanValue() && this.getTime() % (long)((int)(Math.random() * 70.0) + 1) == 0L && this.hasPhysicalIris() && irisItem.m_41763_()) {
                irisItem.m_41720_().setDamage(irisItem, irisItem.m_41720_().getDamage(irisItem) + (new Random().nextInt(heatCoefficient) + 1));
                if (irisItem.m_41613_() == 0) {
                    this.updateIrisType();
                }
                JSGSoundHelper.playSoundEvent(this.getLevelNotNull(), this.getGateCenterPos(), SoundEventEnum.IRIS_HIT);
            }
        }
        if (this.gateHeat >= GATE_MAX_HEAT && ((Boolean)JSGConfig.Stargate.enableGateOverHeatExplosion.get()).booleanValue()) {
            this.getLevelNotNull().m_255391_(null, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), 60.0f, false, Level.ExplosionInteraction.BLOCK);
        }
        if (this.getTime() % 20L == 0L && (this.lastIrisHeat != this.irisHeat || this.lastGateHeat != this.gateHeat)) {
            this.lastIrisHeat = this.irisHeat;
            this.lastGateHeat = this.gateHeat;
            this.m_6596_();
            this.sendState(StateTypeEnum.RENDERER_UPDATE, new StargateRendererActionState(this.irisHeat, this.gateHeat));
        }
        this.m_6596_();
    }

    public double getTemperatureAroundGate() {
        return StargateTemperatureHelper.getTemperatureAroundGate(this);
    }

    public void setStargateSize(StargateSizeEnum size) {
        this.stargateSize = size;
    }

    protected StargateSizeEnum getStargateSizeConfig(boolean server) {
        return server ? (StargateSizeEnum)((Object)JSGConfig.Stargate.stargateSize.get()) : this.getRendererStateClient().stargateSize;
    }

    @Override
    public BlockPos getGateCenterPos() {
        return BlockPosHelper.rotate(new BlockPos(0, 4, 0), this.getFacing(), this.getFacingVertical()).m_121955_((Vec3i)this.m_58899_());
    }

    @Nonnull
    protected StargateSizeEnum getStargateSize() {
        return this.stargateSize;
    }

    public StargateSizeEnum getStargateSizeForApi() {
        return this.getStargateSize();
    }

    @Override
    protected JSGAxisAlignedBB getHorizonKillingBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).killingBox;
    }

    @Override
    protected int getHorizonSegmentCount(boolean server) {
        return this.getStargateSizeConfig((boolean)server).horizonSegmentCount;
    }

    @Override
    protected List<JSGAxisAlignedBB> getGateVaporizingBoxes(boolean server) {
        return this.getStargateSizeConfig((boolean)server).gateVaporizingBoxes;
    }

    @Override
    protected JSGAxisAlignedBB getHorizonTeleportBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).teleportBox;
    }

    @Override
    public void closeGate(StargateClosedReasonEnum reason) {
        super.closeGate(reason);
        CreateIntegrationManager.removeTeleportTracksAroundStargate(this);
        this.resetACPreferences();
        this.m_6596_();
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        if (this.irisMode == EnumIrisMode.AUTO && this.isIrisClosed()) {
            this.toggleIris();
        }
        this.isFinalActive = false;
        if (this.codeSender != null) {
            this.codeSender = null;
        }
        this.updateChevronLight(0, false);
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, this.dialedAddress.size(), this.isFinalActive);
        this.resetACPreferences();
        this.m_6596_();
    }

    @Override
    public boolean isGateBurried() {
        if (!((Boolean)((JSGBooleanConfigOption)this.getConfig().getOption("enableBuryState")).getValue()).booleanValue()) {
            return false;
        }
        for (BlockPos targetPos : Objects.requireNonNull(StargateSizeEnum.getIrisBlocksPattern(this.getStargateSize()))) {
            BlockPos newPos = BlockPosHelper.rotate(targetPos, this.getFacing(), this.getFacingVertical()).m_121955_((Vec3i)this.pos);
            BlockState state = this.getLevelNotNull().m_8055_(newPos);
            if (state.m_60734_() instanceof LiquidBlock || FluidHelper.isLiquidBlock(state)) {
                return false;
            }
            if (state.m_60734_() instanceof AirBlock || state.m_60734_() == Blocks.f_152480_ || state.m_60734_() == BlockRegistry.IRIS_BLOCK.get() || state.m_60734_() == BlockRegistry.INVISIBLE_BLOCK.get()) {
                return false;
            }
            if (!state.m_247087_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void failGate() {
        super.failGate();
        this.resetTargetIncomingAnimation();
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        this.isFinalActive = false;
        this.resetACPreferences();
        this.m_6596_();
        if (this.stargateState != EnumStargateState.INCOMING && !this.isIncoming) {
            this.updateChevronLight(0, false);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, this.dialedAddress.size(), this.isFinalActive);
        }
    }

    @Override
    protected StargateAbstractBaseBE.ResultTargetValid attemptOpenDialed() {
        StargateOpenResult result = this.checkAddressAndEnergy(this.dialedAddress);
        boolean targetValid = result.ok();
        if (this.connectedToGatePos == null) {
            return new StargateAbstractBaseBE.ResultTargetValid(StargateOpenResult.ADDRESS_MALFORMED, targetValid, "connectedToGatePos == null");
        }
        if (!this.connectedToGatePos.getBlockEntity().stargateState.incoming()) {
            return new StargateAbstractBaseBE.ResultTargetValid(StargateOpenResult.CALLER_HUNG_UP, targetValid, "target not incoming");
        }
        if (this.isGateBurried()) {
            return new StargateAbstractBaseBE.ResultTargetValid(StargateOpenResult.GATE_BURRIED, targetValid, "target burried");
        }
        return super.attemptOpenDialed();
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating, boolean noxDialing) {
        super.openGate(targetGatePos, isInitiating, noxDialing);
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        this.tryHeatUp(8.0);
        this.resetACPreferences(false);
        this.m_6596_();
        this.isFinalActive = true;
    }

    public boolean canAbortDialing() {
        if (this.stargateState.incoming()) {
            return false;
        }
        if (this.isIncoming) {
            return false;
        }
        return this.stargateState.dialingComputer() || this.stargateState.idle() || this.stargateState.dialing();
    }

    public boolean abortDialingSequence() {
        if (this.stargateState.incoming()) {
            return false;
        }
        if (this.isIncoming) {
            return false;
        }
        if (this.stargateState.dialingComputer() || this.stargateState.idle() || this.stargateState.dialing()) {
            this.spinStartTime = this.getTime() + 3000L;
            this.isSpinning = false;
            this.currentRingSymbol = this.targetRingSymbol;
            this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, true, 0));
            this.addFailedTaskAndPlaySound();
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
            if (this.lastSpinFinished != null && this.scheduledTasks.contains(this.lastSpinFinished)) {
                this.removeTask(this.lastSpinFinished);
            }
            this.failGate();
            if (!this.isIncoming) {
                this.disconnectGate();
            }
            this.resetACPreferences();
            this.m_6596_();
            this.resetTargetIncomingAnimation();
            this.listenerHandler.gateDialAbort();
            return true;
        }
        return false;
    }

    public boolean isDialingWithoutEnergy() {
        return this.dialingWithoutEnergy;
    }

    protected void resetACPreferences() {
        this.resetACPreferences(true);
    }

    protected void resetACPreferences(boolean resetNox) {
        this.dialingWithoutEnergy = false;
        this.isFastDialingOverride = false;
        if (resetNox) {
            this.isNoxDialing = false;
        }
        this.m_6596_();
    }

    public boolean dialAddress(StargateAddress address, int maxSymbols, boolean withoutEnergy, EnumDialingType dialingType) {
        this.dialingWithoutEnergy = withoutEnergy;
        if (dialingType == EnumDialingType.FAST) {
            this.isFastDialingOverride = true;
            this.setFastDial(true);
        } else if (dialingType == EnumDialingType.NOX) {
            this.isNoxDialing = true;
        }
        this.listenerHandler.gateBeginDial();
        this.m_6596_();
        return true;
    }

    protected void addSymbolToAddressByNox(SymbolInterface symbol) {
        if (symbol != this.getSymbolType().getBRB() && !this.canAddSymbol(symbol)) {
            return;
        }
        if (symbol == this.getSymbolType().getBRB()) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_OPEN_NOX));
            return;
        }
        this.addSymbolToAddressDHD(symbol);
        this.sendSignal("stargate_dhd_chevron_engaged", new Object[]{this.dialedAddress.size(), this.isFinalActive, symbol.getEnglishName()});
    }

    @Override
    public EnergyRequiredToOperate getEnergyRequiredToDial(StargatePos targetGatePos) {
        if (this.dialingWithoutEnergy) {
            return EnergyRequiredToOperate.free();
        }
        return super.getEnergyRequiredToDial(targetGatePos);
    }

    public abstract void addSymbolToAddressDHD(SymbolInterface var1);

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        this.incomingWormhole(dialedAddressSize, true);
    }

    public void incomingWormhole(int dialedAddressSize, boolean toggleIris) {
        if (this.irisMode == EnumIrisMode.AUTO && this.isIrisOpened() && toggleIris) {
            this.toggleIris();
        }
        super.incomingWormhole(dialedAddressSize);
        this.isFinalActive = true;
        this.updateChevronLight(dialedAddressSize, true);
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        this.updateChevronLight(0, false);
        if (this.irisType != EnumIrisType.NULL && this.irisState == EnumIrisState.CLOSED) {
            this.setIrisBlocks(false);
        }
        this.isSpinning = false;
        this.irisState = EnumIrisState.OPENED;
        this.irisType = EnumIrisType.NULL;
        this.currentRingSymbol = this.getSymbolType().getTopSymbol();
        this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.currentRingSymbol, this.spinDirection, true, 0));
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        ItemHandlerHelper.dropInventoryItems(this.world, this.pos, (IItemHandler)this.itemStackHandler);
    }

    @Override
    public void onGateMerged() {
        double heat;
        super.onGateMerged();
        this.updateIrisType();
        this.gateHeat = heat = this.getTemperatureAroundGate();
        this.irisHeat = heat;
        this.m_6596_();
    }

    @Override
    public boolean prepareBE() {
        this.needRegenerate = true;
        this.m_6596_();
        return true;
    }

    public void regenerateStargate(StargateGenerator.PlacementConfig pConfig) {
        ILinkable linkable;
        if (this.world == null) {
            return;
        }
        if (this.world.f_46443_) {
            return;
        }
        JSG.logger.info("Regenerating stargate at {} in {}", (Object)this.m_58899_(), (Object)this.world.m_46472_().m_135782_());
        this.updateLinkStatus();
        pConfig.world = this.world;
        pConfig.gateBasePos = this.m_58899_();
        pConfig.stargateConfig = c -> this.getConfig();
        pConfig.gateFacing = this.mergeHelper.horizontalFacing;
        pConfig.gateVerticalFacing = this.mergeHelper.verticalFacing;
        pConfig.gateType = this.getStargateType();
        pConfig.overlay = this.getBiomeOverlayWithOverride(true);
        if (this.world.f_46441_.m_188501_() < 0.3f) {
            pConfig.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_TYPE);
        }
        pConfig.setStargateEnergyInternalSmart((int)((float)((Integer)JSGConfig.Stargate.stargateEnergyStorage.get()).intValue() * this.world.f_46441_.m_188501_()));
        StargateClassicBaseBE stargateClassicBaseBE = this;
        if (stargateClassicBaseBE instanceof ILinkable && (linkable = (ILinkable)((Object)stargateClassicBaseBE)).isLinked()) {
            pConfig.dhdPos = linkable.getLinkedPos();
            if (this.world.f_46441_.m_188501_() < 0.3f) {
                pConfig.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_DHD);
            }
            pConfig.dhdFluid = (int)(((float)((Integer)JSGConfig.DialHomeDevice.fluidCapacity.get()).intValue() - (float)((Integer)JSGConfig.DialHomeDevice.fluidCapacity.get()).intValue() * 0.1f) * this.world.f_46441_.m_188501_() + (float)((Integer)JSGConfig.DialHomeDevice.fluidCapacity.get()).intValue() * 0.1f);
        }
        StargateGenerator.generateStargate(pConfig, false);
        this.generateAddresses(true);
        this.updateLinkStatus();
        this.m_6596_();
    }

    @Override
    public void onLoad() {
        if (!this.world.f_46443_ && this.needRegenerate) {
            StargateGenerator.PlacementConfig pConfig = new StargateGenerator.PlacementConfig();
            pConfig.baseInPlace = true;
            pConfig.stargateEnergyInternal = 10000;
            this.regenerateStargate(pConfig);
            this.needRegenerate = false;
            this.m_6596_();
        }
        super.onLoad();
        if (!this.world.f_46443_) {
            boolean set;
            this.updatePowerTier();
            this.updateIrisType();
            boolean bl = set = this.irisType != EnumIrisType.NULL;
            if (this.isMerged()) {
                this.setIrisBlocks(set && this.irisState == EnumIrisState.CLOSED);
            }
            this.lastFakeWorld = this.getFakeWorld();
            this.lastFakePos = this.getFakePos();
            this.m_6596_();
        }
    }

    public abstract void updateLinkStatus();

    public void startIncomingAnimation(int addressSize, int period) {
        double ticks = (double)(period * 20) / 1000.0;
        this.incomingPeriod = (int)Math.round(ticks);
        this.incomingAddressSize = addressSize;
        this.incomingLastChevronLightUp = 0;
        this.stargateState = EnumStargateState.INCOMING;
        this.isIncoming = true;
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
        if (this.stargateState == EnumStargateState.DIALING_COMPUTER) {
            this.abortDialingSequence();
        }
        this.m_6596_();
    }

    public void resetIncomingAnimation() {
        this.incomingAddressSize = -1;
        this.incomingPeriod = -1;
        this.incomingLastChevronLightUp = -1;
        this.m_6596_();
    }

    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        if (!this.isIncoming) {
            if (this.incomingPeriod != -1) {
                this.stargateState = EnumStargateState.IDLE;
            }
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
            this.resetIncomingAnimation();
            this.m_6596_();
            return;
        }
        if (this.stargateState.idle()) {
            this.stargateState = EnumStargateState.IDLE;
            this.m_6596_();
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
            this.resetIncomingAnimation();
            return;
        }
        ++this.incomingLastChevronLightUp;
    }

    @Override
    public boolean isRIGAllowed() {
        return (Boolean)((JSGBooleanConfigOption)this.getConfig().getOption("allowRig")).getValue();
    }

    @Override
    public boolean isIncomingAnimationAllowed(boolean spinning) {
        if (spinning) {
            return (Boolean)((JSGBooleanConfigOption)this.getConfig().getOption("incomingSpin")).getValue();
        }
        return (Boolean)((JSGBooleanConfigOption)this.getConfig().getOption("allowIncomingAnim")).getValue();
    }

    public void tryRunIncoming(long ticks) {
        if (this.incomingPeriod == 0) {
            this.incomingPeriod = 1;
        }
        if (this.incomingPeriod != -1 && ticks % (long)this.incomingPeriod == 0L) {
            this.lightUpChevronByIncoming(!this.isIncomingAnimationAllowed(false));
        }
    }

    @Override
    public boolean getForceUnstable() {
        StargateClassicBaseBE castedBE;
        StargateAbstractBaseBE stargateAbstractBaseBE;
        return (Boolean)((JSGBooleanConfigOption)this.getConfig().getOption("forceUnstable")).getValue() != false || this.targetGatePos != null && (stargateAbstractBaseBE = this.targetGatePos.getBlockEntity()) instanceof StargateClassicBaseBE && (Boolean)((JSGBooleanConfigOption)(castedBE = (StargateClassicBaseBE)stargateAbstractBaseBE).getConfig().getOption("forceUnstable")).getValue() != false;
    }

    @Override
    public void tick() {
        block40: {
            block37: {
                block39: {
                    block38: {
                        BlockPos topBlock;
                        this.updateDevices();
                        if (this.lastFakeWorld == null) {
                            this.lastFakeWorld = this.getFakeWorld();
                        }
                        if (this.lastFakePos == null) {
                            this.lastFakePos = this.getFakePos();
                        }
                        this.pos = this.m_58899_();
                        if (this.getLevelNotNull().f_46443_ && (this.getConfig() == null || this.getConfig().getOptions().isEmpty())) {
                            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.pos, StateTypeEnum.GUI_STATE));
                        }
                        if (!(this.world.f_46443_ || this.lastFakePos == this.getFakePos() && this.lastFakeWorld == this.getFakeWorld())) {
                            if (!(this.getStargateState().engaged() || this.getStargateState().unstable() || this.getStargateState().idle() || !this.connectedToGate && !this.connectingToGate)) {
                                this.abortDialingSequence();
                                this.lastFakePos = this.getFakePos();
                                this.lastFakeWorld = this.getFakeWorld();
                                this.m_6596_();
                            } else if (this.getStargateState().engaged() || this.getStargateState().unstable()) {
                                JSG.logger.info("A stargateState indicates the Gate should be open, but gate was warped! Closing gate...");
                                this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                                this.lastFakePos = this.getFakePos();
                                this.lastFakeWorld = this.getFakeWorld();
                                this.m_6596_();
                            } else {
                                this.lastFakePos = this.getFakePos();
                                this.lastFakeWorld = this.getFakeWorld();
                                this.m_6596_();
                            }
                        }
                        if (!this.world.f_46443_ && this.getConfig().has("enableFastDial")) {
                            boolean shouldBeFast = (Boolean)((JSGBooleanConfigOption)this.getConfig().getOption("enableFastDial")).getValue();
                            if (!this.isFastDialingOverride && this.isFastDialing != shouldBeFast && this.getStargateState().idle()) {
                                this.setFastDial(shouldBeFast);
                            }
                        }
                        if (!this.world.f_46443_ && this.isMerged() && (topBlock = this.getMergeHelper().getTopBlock()) != null && this.world.m_46470_() && this.world.m_46471_() && this.world.m_46758_(topBlock.m_7494_())) {
                            Random rand = new Random();
                            float chance = rand.nextFloat();
                            StargateDimensionConfigEntry entry = StargateDimensionConfig.INSTANCE.getConfigEntry((ResourceKey<Level>)this.world.m_46472_());
                            if (entry != null && (double)chance < entry.lightingBoltChance && BlockHelpers.isBlockDirectlyUnderSky(this.world, topBlock)) {
                                int max = (Integer)JSGConfig.Stargate.stargateEnergyStorage.get() / 17;
                                int min = max / 6;
                                int energy = (int)(rand.nextFloat() * (float)(max - min) + (float)min);
                                this.getEnergyStorage().receiveEnergy(energy, false);
                                LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.getLevelNotNull());
                                if (lightningbolt != null) {
                                    lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)this.pos));
                                    this.getLevelNotNull().m_7967_((Entity)lightningbolt);
                                }
                            }
                        }
                        if (!this.world.f_46443_ && this.isMerged() && this.world.m_46467_() % 20L == 0L) {
                            double middleTemperature = this.getTemperatureAroundGate();
                            double c = Math.min(1.0, Math.abs(this.gateHeat - middleTemperature) / 20.0);
                            this.tryHeatUp(false, true, c, c, c, middleTemperature, middleTemperature);
                            if (!this.hasIris()) {
                                this.irisHeat = -1.0;
                                this.m_6596_();
                            }
                        }
                        if (!this.world.f_46443_) {
                            this.tryRunIncoming(this.getTime());
                        }
                        this.extractEnergyByShield(0);
                        if (!this.world.f_46443_ && this.hasShieldIris()) {
                            this.shieldKeepAlive = (Integer)JSGConfig.Stargate.irisShieldPowerDraw.get();
                            this.shieldKeepAlive += (int)(this.irisHeat * (this.irisHeat / IRIS_MAX_HEAT_TRINIUM));
                            if (this.isIrisClosed()) {
                                this.extractEnergyByShield(this.shieldKeepAlive);
                            }
                            if (this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive) {
                                this.toggleIris();
                                this.sendSignal("stargate_iris_out_of_power", new Object[]{"Shield runs out of power! Opening shield..."});
                            } else if (this.irisMode == EnumIrisMode.CLOSED && this.isIrisOpened()) {
                                this.toggleIris();
                            }
                        }
                        super.tick();
                        if (this.world.f_46443_) break block37;
                        if (!this.lastPos.equals((Object)this.pos)) {
                            this.lastPos = this.pos;
                            if (this.isMerged()) {
                                this.getMergeHelper().updateMemberStateAndCheck(null);
                            }
                        }
                        if (this.givePageTask != null && this.givePageTask.update(this.getTime())) {
                            this.givePageTask = null;
                        }
                        if (!this.doPageProgress) break block38;
                        if (this.getTime() % 2L == 0L) {
                            this.pageProgress = (short)(this.pageProgress + 1);
                            if (this.pageProgress > 18) {
                                this.pageProgress = 0;
                                this.doPageProgress = false;
                            }
                        }
                        if (!this.itemStackHandler.getStackInSlot(this.pageSlotId).m_41619_()) break block39;
                        this.lockPage = false;
                        this.doPageProgress = false;
                        this.pageProgress = 0;
                        this.givePageTask = null;
                        break block39;
                    }
                    if (this.lockPage && this.itemStackHandler.getStackInSlot(this.pageSlotId).m_41619_()) {
                        this.lockPage = false;
                    }
                    if (!this.lockPage) {
                        for (int i = 7; i < 10; ++i) {
                            if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
                            this.doPageProgress = true;
                            this.lockPage = true;
                            this.pageSlotId = i;
                            this.givePageTask = new ScheduledTask(EnumScheduledTask.STARGATE_GIVE_PAGE, 36);
                            this.givePageTask.setTaskCreated(this.getTime());
                            this.givePageTask.setExecutor(this);
                            break;
                        }
                    }
                }
                if (!this.isIrisClosed() && !this.isIrisOpened() && this.getTime() - this.irisAnimation > (long)(this.hasPhysicalIris() ? 60 : 10)) {
                    switch (this.irisState) {
                        case OPENING: {
                            this.irisState = EnumIrisState.OPENED;
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
                            if (this.afterIrisDone != null) {
                                this.afterIrisDone.run();
                            }
                            this.afterIrisDone = null;
                            this.sendSignal("stargate_iris_opened", new Object[]{"Iris is opened"});
                            break;
                        }
                        case CLOSING: {
                            this.irisState = EnumIrisState.CLOSED;
                            this.setIrisBlocks(true);
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
                            if (this.afterIrisDone != null) {
                                this.afterIrisDone.run();
                            }
                            this.afterIrisDone = null;
                            this.sendSignal("stargate_iris_closed", new Object[]{"Iris is closed"});
                            break;
                        }
                    }
                    this.m_6596_();
                }
                break block40;
            }
            if (this.getTime() % 40L == 0L && this.rendererStateClient != null && this.getRendererStateClient().biomeOverride == null) {
                this.rendererStateClient.setBiomeOverlay(this.getBiomeOverlayWithOverride(false));
            }
        }
        CreateIntegrationManager.tickTracksAroundStargate(this);
    }

    @Override
    protected void kawooshDestruction() {
        if (!this.isIrisClosed() || this.irisType == EnumIrisType.NULL) {
            super.kawooshDestruction();
        }
    }

    private BiomeOverlayEnum determineBiomeOverride() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(10);
        if (stack.m_41619_()) {
            return null;
        }
        BiomeOverlayEnum biomeOverlay = JSGConfigUtil.getBiomeOverrideItemMetaPairs().get(Block.m_49814_((Item)stack.m_41720_()));
        if (this.getSupportedOverlays().contains(biomeOverlay)) {
            return biomeOverlay;
        }
        return null;
    }

    @Override
    public BiomeOverlayEnum getBiomeOverlayWithOverride(boolean override) {
        BiomeOverlayEnum overlay = null;
        if (override) {
            overlay = this.determineBiomeOverride();
        }
        if (overlay == null) {
            return super.getBiomeOverlayWithOverride(override);
        }
        return overlay;
    }

    @Override
    protected boolean canAddSymbolInternal(SymbolInterface symbol) {
        if (this.isFinalActive) {
            return false;
        }
        return super.canAddSymbolInternal(symbol);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        compound.m_128379_("needRegenerate", this.needRegenerate);
        compound.m_128405_("stargateSize", this.stargateSize.id);
        compound.m_128365_("itemHandler", (Tag)this.itemStackHandler.serializeNBT());
        compound.m_128379_("isFinalActive", this.isFinalActive);
        compound.m_128379_("isSpinning", this.isSpinning);
        compound.m_128356_("spinStartTime", this.spinStartTime);
        compound.m_128405_("currentRingSymbol", this.currentRingSymbol.getId());
        compound.m_128405_("targetRingSymbol", this.targetRingSymbol.getId());
        compound.m_128405_("spinDirection", this.spinDirection.id);
        if (this.irisState == null) {
            if (this.codeSender != null) {
                this.codeSender.sendMessage(GDOMessages.OPENED.textComponent);
                this.codeSender = null;
            }
            this.irisState = EnumIrisState.OPENED;
        }
        compound.m_128344_("irisState", this.irisState.id);
        compound.m_128359_("irisCode", this.irisCode);
        compound.m_128344_("irisMode", this.irisMode.id);
        compound.m_128344_("irisType", this.irisType.id);
        if (this.codeSender != null && !this.world.f_46443_) {
            compound.m_128365_("codeSender", (Tag)this.codeSender.serializeNBT());
        }
        compound.m_128405_("powerTier", this.currentPowerTier);
        compound.m_128405_("incomingLastChevronLightUp", this.incomingLastChevronLightUp);
        compound.m_128405_("incomingPeriod", this.incomingPeriod);
        compound.m_128405_("incomingAddressSize", this.incomingAddressSize);
        compound.m_128365_("config", (Tag)this.getConfig().serializeNBT());
        compound.m_128347_("irisHeat", this.irisHeat);
        compound.m_128347_("lastIrisHeat", this.lastIrisHeat);
        compound.m_128347_("gateHeat", this.gateHeat);
        compound.m_128347_("lastGateHeat", this.lastGateHeat);
        compound.m_128379_("fastDialing", this.isFastDialing);
        compound.m_128379_("isFastDialingOverride", this.isFastDialingOverride);
        compound.m_128379_("isNoxDialing", this.isNoxDialing);
        if (this.lastFakePos != null) {
            compound.m_128356_("lastFakePos", this.lastFakePos.m_121878_());
        }
        if (this.lastFakeWorld != null) {
            compound.m_128359_("lastFakeWorld", this.lastFakeWorld.m_135782_().toString());
        }
        compound.m_128405_("redstoneIODevice_size", this.REDSTONE_IO_BLOCKS.size());
        for (int i = 0; i < this.REDSTONE_IO_BLOCKS.size(); ++i) {
            compound.m_128356_("redstoneIODevice_pos" + i, this.REDSTONE_IO_BLOCKS.get(i).m_121878_());
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.needRegenerate = compound.m_128471_("needRegenerate");
        if (compound.m_128441_("stargateSize")) {
            this.setStargateSize(StargateSizeEnum.fromId(compound.m_128451_("stargateSize")));
        } else {
            this.setStargateSize((StargateSizeEnum)((Object)JSGConfig.Stargate.stargateSize.get()));
        }
        this.itemStackHandler.deserializeNBT(compound.m_128469_("itemHandler"));
        this.isFinalActive = compound.m_128471_("isFinalActive");
        this.isSpinning = compound.m_128471_("isSpinning");
        this.spinStartTime = compound.m_128454_("spinStartTime");
        this.currentRingSymbol = this.getSymbolType().valueOf(compound.m_128451_("currentRingSymbol"));
        this.targetRingSymbol = this.getSymbolType().valueOf(compound.m_128451_("targetRingSymbol"));
        this.spinDirection = EnumSpinDirection.valueOf(compound.m_128451_("spinDirection"));
        this.irisState = EnumIrisState.getValue(compound.m_128445_("irisState"));
        this.irisCode = !compound.m_128461_("irisCode").isEmpty() ? compound.m_128461_("irisCode") : "";
        this.irisMode = EnumIrisMode.getValue(compound.m_128445_("irisMode"));
        this.irisType = EnumIrisType.byId(compound.m_128445_("irisType"));
        if (compound.m_128441_("codeSender") && !this.world.f_46443_) {
            CompoundTag nbt = compound.m_128469_("codeSender");
            this.codeSender = this.codeSenderFromNBT(nbt);
        }
        this.currentPowerTier = compound.m_128451_("powerTier");
        this.incomingPeriod = compound.m_128451_("incomingPeriod");
        this.incomingLastChevronLightUp = compound.m_128451_("incomingLastChevronLightUp");
        this.incomingAddressSize = compound.m_128451_("incomingAddressSize");
        if (this.getConfig() == null) {
            this.config = new JSGTileEntityConfig(this.getStargateType().configType);
        }
        this.getConfig().deserializeNBT(compound.m_128469_("config"));
        this.irisHeat = compound.m_128459_("irisHeat");
        this.lastIrisHeat = compound.m_128459_("lastIrisHeat");
        this.gateHeat = compound.m_128459_("gateHeat");
        this.lastGateHeat = compound.m_128459_("lastGateHeat");
        this.isFastDialing = compound.m_128471_("fastDialing");
        this.isFastDialingOverride = compound.m_128471_("isFastDialingOverride");
        this.isNoxDialing = compound.m_128471_("isNoxDialing");
        if (compound.m_128441_("lastFakePos")) {
            this.lastFakePos = BlockPos.m_122022_((long)compound.m_128454_("lastFakePos"));
        }
        if (compound.m_128441_("lastFakeWorld")) {
            this.lastFakeWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("lastFakeWorld")));
        }
        int size = compound.m_128451_("redstoneIODevice_size");
        this.REDSTONE_IO_BLOCKS.clear();
        for (int i = 0; i < size; ++i) {
            this.REDSTONE_IO_BLOCKS.add(BlockPos.m_122022_((long)compound.m_128454_("redstoneIODevice_pos" + i)));
        }
    }

    private CodeSender codeSenderFromNBT(CompoundTag compound) {
        this.codeSender = CodeSenderType.fromId((int)compound.m_128451_((String)"type")).constructor.get();
        switch (this.codeSender.getType()) {
            case PLAYER: {
                this.codeSender.prepareToLoad(new Object[]{this.world});
                break;
            }
            case COMPUTER: {
                this.codeSender.prepareToLoad(null);
            }
        }
        this.codeSender.deserializeNBT((Tag)compound);
        return this.codeSender;
    }

    @Override
    public JSGTileEntityConfig getConfig() {
        if (this.config == null) {
            this.initConfig();
        }
        return this.config;
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        boolean changed = false;
        for (JSGConfigOption<?> o : config.getOptions()) {
            changed = changed || this.config.getOption(o.getLabel()).setValue(o.getValue().toString());
        }
        if (changed) {
            this.m_6596_();
        }
    }

    @Override
    public void setConfigAndUpdate(JSGTileEntityConfig config) {
        this.setConfig(config);
        this.sendState(StateTypeEnum.GUI_STATE, this.getState(StateTypeEnum.GUI_STATE));
    }

    @Override
    public void initConfig() {
        this.initConfig(this.getStargateType().configType);
    }

    protected final void initConfig(ResourceLocation gateType) {
        this.config = new JSGTileEntityConfig(gateType);
    }

    protected void updateChevronLight(int lightUp, boolean isFinalActive) {
    }

    @Override
    protected StargateClassicRendererState.StargateClassicRendererStateBuilder getRendererStateServer() {
        return new StargateClassicRendererState.StargateClassicRendererStateBuilder(super.getRendererStateServer()).setSymbolType(this.getSymbolType()).setActiveChevrons(this.dialedAddress.size()).setFinalActive(this.isFinalActive).setCurrentRingSymbol(this.currentRingSymbol).setSpinDirection(this.spinDirection).setSpinning(this.isSpinning).setTargetRingSymbol(this.targetRingSymbol).setSpinStartTime(this.spinStartTime).setBiomeOverride(this.determineBiomeOverride()).setIrisState(this.irisState).setIrisType(this.irisType).setIrisMode(this.irisMode).setIrisCode(this.irisCode).setIrisAnimation(this.irisAnimation);
    }

    @Override
    public StargateClassicRendererState getRendererStateClient() {
        return (StargateClassicRendererState)super.getRendererStateClient();
    }

    protected long getSpinStartOffset() {
        return 0L;
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        return switch (stateType) {
            case StateTypeEnum.GUI_STATE -> new StargateContainerGuiState(this.gateAddressMap, this.getConfig());
            case StateTypeEnum.GUI_UPDATE -> new StargateContainerGuiUpdate(this.energyStorage.getEnergyStoredInternally(), this.energyTransferredLastTick, this.energySecondsToClose, this.irisMode, this.irisCode, this.openedSince, this.gateHeat, this.irisHeat, this.pageProgress);
            default -> super.getState(stateType);
        };
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        return switch (stateType) {
            case StateTypeEnum.GUI_STATE -> new StargateContainerGuiState();
            case StateTypeEnum.GUI_UPDATE -> new StargateContainerGuiUpdate();
            case StateTypeEnum.SPIN_STATE -> new StargateSpinState();
            case StateTypeEnum.BIOME_OVERRIDE_STATE -> new StargateBiomeOverrideState();
            default -> super.createState(stateType);
        };
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        block0 : switch (stateType) {
            case RENDERER_UPDATE: {
                if (this.getRendererStateClient() == null) break;
                StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                switch (gateActionState.action) {
                    case CHEVRON_ACTIVATE: {
                        if (gateActionState.modifyFinal) {
                            this.getRendererStateClient().chevronTextureList.activateFinalChevron(this.getTime());
                            break block0;
                        }
                        this.getRendererStateClient().chevronTextureList.activateNextChevron(this.getTime(), gateActionState.chevronCount);
                        break block0;
                    }
                    case CLEAR_CHEVRONS: {
                        this.getRendererStateClient().clearChevrons(this.getTime());
                        break block0;
                    }
                    case LIGHT_UP_CHEVRONS: {
                        this.getRendererStateClient().chevronTextureList.lightUpChevrons(this.getTime(), gateActionState.chevronCount);
                        break block0;
                    }
                    case CHEVRON_ACTIVATE_BOTH: {
                        this.getRendererStateClient().chevronTextureList.activateNextChevron(this.getTime());
                        this.getRendererStateClient().chevronTextureList.activateFinalChevron(this.getTime());
                        break block0;
                    }
                    case CHEVRON_DIM: {
                        this.getRendererStateClient().chevronTextureList.deactivateFinalChevron(this.getTime());
                        break block0;
                    }
                    case IRIS_UPDATE: {
                        this.getRendererStateClient().irisState = gateActionState.irisState;
                        this.getRendererStateClient().irisType = gateActionState.irisType;
                        if (gateActionState.irisState != EnumIrisState.CLOSING && gateActionState.irisState != EnumIrisState.OPENING) break block0;
                        this.getRendererStateClient().irisAnimation = this.getTime();
                        break block0;
                    }
                    case HEAT_UPDATE: {
                        this.getRendererStateClient().irisHeat = gateActionState.irisHeat;
                        this.getRendererStateClient().gateHeat = gateActionState.gateHeat;
                        this.irisHeat = gateActionState.irisHeat;
                        this.gateHeat = gateActionState.gateHeat;
                        this.m_6596_();
                        break block0;
                    }
                }
                break;
            }
            case GUI_STATE: {
                StargateContainerGuiState guiState = (StargateContainerGuiState)state;
                this.gateAddressMap = guiState.gateAdddressMap;
                this.config = guiState.config;
                this.m_6596_();
                break;
            }
            case GUI_UPDATE: {
                StargateContainerGuiUpdate guiUpdate = (StargateContainerGuiUpdate)state;
                this.energyStorage.setEnergyStoredInternally(guiUpdate.energyStored);
                this.energyTransferredLastTick = guiUpdate.transferedLastTick;
                this.energySecondsToClose = guiUpdate.secondsToClose;
                this.irisMode = guiUpdate.irisMode;
                this.irisCode = guiUpdate.irisCode;
                this.openedSince = guiUpdate.openedSince;
                this.gateHeat = guiUpdate.gateTemp;
                this.irisHeat = guiUpdate.irisTemp;
                this.pageProgress = (short)guiUpdate.pageProgress;
                this.m_6596_();
                break;
            }
            case SPIN_STATE: {
                if (this.getRendererStateClient() == null) break;
                StargateSpinState spinState = (StargateSpinState)state;
                if (spinState.setOnly) {
                    this.getRendererStateClient().spinHelper.setIsSpinning(false);
                    this.getRendererStateClient().spinHelper.setCurrentSymbol(spinState.targetSymbol);
                    break;
                }
                int speed = (Integer)((JSGIntRangeConfigOption)this.getConfig().getOption("spinSpeed")).getValue();
                this.getRendererStateClient().spinHelper.initRotation((float)speed / 100.0f, this.getTime(), spinState.targetSymbol, spinState.direction, this.getSpinStartOffset(), spinState.plusRounds);
                break;
            }
            case BIOME_OVERRIDE_STATE: {
                StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
                if (this.rendererStateClient == null) break;
                this.getRendererStateClient().biomeOverride = overrideState.biomeOverride;
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        boolean fastDial = false;
        boolean onlySpin = false;
        if (customData != null) {
            if (customData.m_128441_("fastDial")) {
                fastDial = customData.m_128471_("fastDial");
            }
            if (customData.m_128441_("onlySpin")) {
                onlySpin = customData.m_128471_("onlySpin");
            }
        }
        switch (scheduledTask) {
            case STARGATE_HORIZON_LIGHT_BLOCK: {
                if (this.irisType != EnumIrisType.NULL && this.irisType != EnumIrisType.SHIELD && this.isIrisClosed()) break;
                super.executeTask(scheduledTask, customData);
                break;
            }
            case STARGATE_CLOSE: {
                if (this.irisType == EnumIrisType.NULL || !this.isIrisClosed()) {
                    super.executeTask(scheduledTask, customData);
                    break;
                }
                if (!this.isIrisClosed()) break;
                this.disconnectGate();
                break;
            }
            case STARGATE_OPEN_NOX: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, this.dialedAddress.size(), false);
                this.attemptOpenAndFail();
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                this.lastSpinFinishedIn = this.getTime();
                if (fastDial) break;
                this.isSpinning = false;
                this.currentRingSymbol = this.targetRingSymbol;
                if (!(this instanceof StargatePegasusBaseBE) || !((StargatePegasusBaseBE)this).continueDialing) {
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                }
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, false);
                this.m_6596_();
                break;
            }
            case STARGATE_GIVE_PAGE: {
                int[] nArray;
                SymbolTypeEnum<?> symbolType = SymbolTypeEnum.byId(this.pageSlotId - 7);
                ItemStack stack = this.itemStackHandler.getStackInSlot(this.pageSlotId);
                if (this.hasUpgrade(StargateUpgradeEnum.CHEVRON_UPGRADE)) {
                    int[] nArray2 = new int[9];
                    nArray2[0] = 1;
                    nArray2[1] = 2;
                    nArray2[2] = 3;
                    nArray2[3] = 4;
                    nArray2[4] = 5;
                    nArray2[5] = 6;
                    nArray2[6] = 7;
                    nArray2[7] = 8;
                    nArray = nArray2;
                    nArray2[8] = 9;
                } else {
                    int[] nArray3 = new int[7];
                    nArray3[0] = 1;
                    nArray3[1] = 2;
                    nArray3[2] = 3;
                    nArray3[3] = 4;
                    nArray3[4] = 5;
                    nArray3[5] = 6;
                    nArray = nArray3;
                    nArray3[6] = 9;
                }
                stack = this.getAddressPage(symbolType, stack, nArray);
                this.itemStackHandler.setStackInSlot(this.pageSlotId, stack);
                break;
            }
            case GATE_RING_ROLL: {
                if (this.stargateState.idle() && !onlySpin) break;
                this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
                break;
            }
            default: {
                super.executeTask(scheduledTask, customData);
            }
        }
    }

    public static int getOriginId(BiomeOverlayEnum overlay, ResourceKey<Level> dim, int configOrigin) {
        int override;
        if (configOrigin >= 0) {
            return configOrigin;
        }
        if (overlay == null) {
            overlay = BiomeOverlayEnum.NORMAL;
        }
        if ((override = StargateDimensionConfig.INSTANCE.getOrigin(dim, overlay)) >= 0) {
            return override;
        }
        return switch (overlay) {
            case BiomeOverlayEnum.FROST -> 3;
            case BiomeOverlayEnum.AGED -> 4;
            case BiomeOverlayEnum.SOOTY -> 2;
            case BiomeOverlayEnum.NORMAL -> {
                if (dim == Level.f_46428_) {
                    yield 5;
                }
                yield 0;
            }
            default -> 0;
        };
    }

    @Override
    public int getOriginId() {
        return StargateClassicBaseBE.getOriginId(this.getBiomeOverlayWithOverride(true), this.getFakeWorld(), -1);
    }

    public int getOriginId(StargateTypeEnum gateType) {
        if (gateType == this.getStargateType()) {
            return this.getOriginId();
        }
        return StargateClassicBaseBE.getOriginId(this.getBiomeOverlayWithOverride(true), this.getFakeWorld(), -1);
    }

    @Override
    public boolean isSpinning() {
        return this.isSpinning;
    }

    protected float getSpeedFactor() {
        return (float)((Integer)((JSGIntRangeConfigOption)this.getConfig().getOption("spinSpeed")).getValue()).intValue() / 100.0f;
    }

    public void addSymbolToAddressManual(SymbolInterface targetSymbol, @Nullable Object context) {
        this.listenerHandler.gateRingSpin();
        int soundSpinWait = 5;
        if (this instanceof StargateUniverseBaseBE) {
            soundSpinWait = 10;
        }
        this.targetRingSymbol = targetSymbol;
        boolean moveOnly = this.targetRingSymbol == this.currentRingSymbol;
        int plusRounds = 0;
        this.spinDirection = this.spinDirection.opposite();
        float distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
        if (moveOnly) {
            ++plusRounds;
        }
        if (!((Boolean)JSGConfig.Stargate.fasterMWGateDial.get()).booleanValue()) {
            if (distance < 90.0f && plusRounds == 0) {
                ++plusRounds;
            }
            if (distance < 270.0f && plusRounds == 0 && this.targetRingSymbol == this.targetRingSymbol.getSymbolType().getOrigin()) {
                ++plusRounds;
            }
        } else if (distance > 180.0f) {
            this.spinDirection = this.spinDirection.opposite();
            distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
            plusRounds = 0;
        }
        int duration = StargateClassicSpinHelper.getAnimationDuration(this.getSpeedFactor(), distance += (float)(plusRounds * 360));
        this.doIncomingAnimation(duration, true, this.targetRingSymbol);
        this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, plusRounds));
        this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5);
        this.addTask(this.lastSpinFinished);
        this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, soundSpinWait));
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
        this.isSpinning = true;
        this.spinStartTime = this.getTime();
        this.ringSpinContext = context;
        if (context != null) {
            this.sendSignal("stargate_spin_start", new Object[]{this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName()});
        }
        this.m_6596_();
    }

    public void spinRing(int rounds, boolean changeState, boolean findNearest, int time) {
        this.listenerHandler.gateRingSpin();
        if (time < 0) {
            time *= -1;
        }
        time -= 20;
        this.targetRingSymbol = this.currentRingSymbol;
        this.spinDirection = EnumSpinDirection.CLOCKWISE;
        if (changeState) {
            this.stargateState = EnumStargateState.DIALING_COMPUTER;
        }
        if (rounds == 0) {
            rounds = 1;
        }
        if (rounds < 0) {
            this.spinDirection = EnumSpinDirection.COUNTER_CLOCKWISE;
            rounds *= -1;
        }
        float distance = 360 * rounds;
        if (findNearest) {
            rounds = 0;
            float currentAngle = this.currentRingSymbol.getAngle();
            float angle = StargateClassicSpinHelper.getAnimationDistance(this.getSpeedFactor(), time);
            if (angle > 360.0f) {
                rounds = (int)Math.floor(angle / 360.0f);
                angle -= (float)(rounds * 360);
            }
            float finalAngle = currentAngle - angle;
            if (this.spinDirection == EnumSpinDirection.CLOCKWISE) {
                finalAngle = angle + currentAngle;
            }
            if (finalAngle > 360.0f) {
                finalAngle -= 360.0f;
            } else if (finalAngle < 0.0f) {
                finalAngle += 360.0f;
            }
            if (finalAngle < 15.0f && rounds == 0) {
                finalAngle += 15.0f;
            }
            float nearestAngle = this.getSymbolType().getAngleOfNearest(finalAngle);
            this.targetRingSymbol = this.getSymbolType().getSymbolByAngle(nearestAngle);
            distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
            distance += (float)(360 * rounds);
        }
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("onlySpin", true);
        int duration = StargateClassicSpinHelper.getAnimationDuration(this.getSpeedFactor(), distance);
        if (this.targetPoint != null) {
            this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, rounds));
        }
        if (this.stargateState.incoming()) {
            this.stargateState = EnumStargateState.INCOMING;
            this.m_6596_();
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5, compound));
        } else {
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5, compound);
            this.addTask(this.lastSpinFinished);
        }
        this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 5));
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
        this.isSpinning = true;
        this.spinStartTime = this.getTime();
        this.ringSpinContext = null;
        this.sendSignal("stargate_spin_start", new Object[]{this.dialedAddress.size(), false, this.targetRingSymbol.getEnglishName()});
        this.m_6596_();
    }

    public short getPageProgress() {
        return this.pageProgress;
    }

    public void setPageProgress(int pageProgress) {
        this.pageProgress = (short)pageProgress;
    }

    public int getSupportedCapacitors() {
        return (Integer)((JSGIntRangeConfigOption)this.getConfig().getOption("maxCapacitors")).getValue();
    }

    public boolean canInsertItemAsIris(Item item) {
        return StargateIrisUpgradeEnum.contains(item);
    }

    public void updateIrisType() {
        this.updateIrisType(true);
    }

    public void updateIrisType(boolean setChanged) {
        this.irisType = EnumIrisType.byItem(this.itemStackHandler.getStackInSlot(11).m_41720_());
        this.irisAnimation = this.getTime();
        if (this.irisType == EnumIrisType.NULL) {
            this.irisState = EnumIrisState.OPENED;
        }
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
        this.updateIrisDurability();
        if (setChanged) {
            this.m_6596_();
        }
        if (!this.getLevelNotNull().f_46443_ && this.isIrisOpened()) {
            this.setIrisBlocks(false);
        }
    }

    public void updateIrisDurability() {
        this.irisDurability = 0;
        this.irisMaxDurability = 0;
        if (this.hasPhysicalIris()) {
            this.irisMaxDurability = this.irisType == EnumIrisType.IRIS_TITANIUM ? (Integer)JSGConfig.Stargate.titaniumIrisDurability.get() : (Integer)JSGConfig.Stargate.triniumIrisDurability.get();
            this.irisDurability = this.irisMaxDurability - this.itemStackHandler.getStackInSlot(11).m_41720_().getDamage(this.itemStackHandler.getStackInSlot(11));
        }
    }

    public EnumIrisType getIrisType() {
        return this.irisType;
    }

    public EnumIrisState getIrisState() {
        return this.irisState;
    }

    public boolean isIrisClosed() {
        return this.irisState == EnumIrisState.CLOSED;
    }

    public boolean isIrisOpened() {
        return this.irisState == EnumIrisState.OPENED;
    }

    public boolean hasCreativeIris() {
        return this.irisType == EnumIrisType.IRIS_CREATIVE;
    }

    public boolean hasPhysicalIris() {
        return switch (this.irisType) {
            case EnumIrisType.IRIS_TITANIUM, EnumIrisType.IRIS_TRINIUM, EnumIrisType.IRIS_CREATIVE -> true;
            default -> false;
        };
    }

    public boolean hasIris() {
        return this.irisType != EnumIrisType.NULL;
    }

    public boolean hasShieldIris() {
        return this.irisType == EnumIrisType.SHIELD;
    }

    public boolean toggleIris() {
        SoundEventEnum closeSound;
        SoundEventEnum openSound;
        if (this.irisType == EnumIrisType.NULL) {
            return false;
        }
        if (this.isIrisClosed() || this.isIrisOpened()) {
            this.irisAnimation = this.getTime();
        }
        if (this.hasPhysicalIris()) {
            openSound = SoundEventEnum.IRIS_OPENING;
            closeSound = SoundEventEnum.IRIS_CLOSING;
        } else {
            openSound = SoundEventEnum.SHIELD_OPENING;
            closeSound = SoundEventEnum.SHIELD_CLOSING;
        }
        switch (this.irisState) {
            case OPENING: 
            case OPENED: {
                if (this.hasShieldIris() && this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive * 3) {
                    return false;
                }
                this.irisState = EnumIrisState.CLOSING;
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.irisType, this.irisState, this.irisAnimation);
                this.sendSignal("stargate_iris_closing", new Object[]{"Iris is closing"});
                this.m_6596_();
                this.playSoundEvent(closeSound);
                if (this.targetGatePos != null) {
                    this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
                }
                this.listenerHandler.irisCloses();
                break;
            }
            case CLOSING: 
            case CLOSED: {
                this.irisState = EnumIrisState.OPENING;
                this.setIrisBlocks(false);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.irisType, this.irisState, this.irisAnimation);
                this.sendSignal("stargate_iris_opening", new Object[]{"Iris is opening"});
                this.m_6596_();
                this.playSoundEvent(openSound);
                if (this.targetGatePos != null) {
                    this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
                }
                this.listenerHandler.irisOpens();
                break;
            }
            default: {
                return false;
            }
        }
        this.m_6596_();
        return true;
    }

    public void hitIris() {
        if (!this.hasIris()) {
            return;
        }
        JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.IRIS_IMPACT);
        this.listenerHandler.irisHit();
        ItemStack irisItem = this.getItemHandler().getStackInSlot(11);
        if (!this.hasCreativeIris() && irisItem.m_41720_() instanceof IrisItem && irisItem.m_41763_()) {
            int chance = EnchantmentHelper.m_44831_((ItemStack)irisItem).containsKey(Enchantments.f_44986_) ? (Integer)JSGConfig.Stargate.irisUnbreakingChance.get() * irisItem.getEnchantmentLevel(Enchantments.f_44986_) : 0;
            int random = new Random().nextInt(100);
            if (random > chance) {
                irisItem.m_41720_().setDamage(irisItem, irisItem.m_41720_().getDamage(irisItem) + 1);
            }
            if (irisItem.m_41613_() == 0) {
                this.updateIrisType();
            }
            this.tryHeatUp(true, 2.0);
        } else if (!this.hasCreativeIris()) {
            this.getCapability(ForgeCapabilities.ENERGY, null).resolve().ifPresent(energyStorage -> energyStorage.extractEnergy(500, false));
        }
        if (this.hasPhysicalIris()) {
            JSGSoundHelper.playSoundEvent(this.f_58857_, this.getGateCenterPos(), SoundEventEnum.IRIS_HIT);
        } else if (this.hasShieldIris()) {
            JSGSoundHelper.playSoundEvent(this.f_58857_, this.getGateCenterPos(), SoundEventEnum.SHIELD_HIT);
        }
        this.sendSignal("stargate_event_iris_hit", new Object[]{"Something just hit the IRIS!"});
    }

    public boolean receiveIrisCode(CodeSender sender, String code) {
        this.sendSignal("received_code", new Object[]{code});
        if (this.irisMode != EnumIrisMode.AUTO) {
            if (this.listenerHandler.receiveIDC(sender, code)) {
                return true;
            }
            sender.sendMessage(GDOMessages.SEND_TO_COMPUTER.textComponent);
            this.codeSender = sender;
            return false;
        }
        if (Objects.equals(code, this.irisCode)) {
            switch (this.irisState) {
                case OPENED: {
                    sender.sendMessage(GDOMessages.OPENED.textComponent);
                    break;
                }
                case CLOSED: {
                    sender.sendMessage(GDOMessages.CODE_ACCEPTED.textComponent);
                    this.codeSender = sender;
                    this.toggleIris();
                    break;
                }
                case OPENING: 
                case CLOSING: {
                    sender.sendMessage(GDOMessages.BUSY.textComponent);
                    break;
                }
            }
        } else {
            if (this.listenerHandler.receiveIDC(sender, code)) {
                return true;
            }
            sender.sendMessage(GDOMessages.CODE_REJECTED.textComponent);
            return false;
        }
        this.m_6596_();
        return true;
    }

    public void setIrisCode(String code) {
        this.irisCode = code;
        this.m_6596_();
    }

    public void setIrisMode(EnumIrisMode irisMode) {
        if (this.irisMode != irisMode && this.hasIris()) {
            switch (irisMode) {
                case OPENED: 
                case CLOSED: {
                    this.irisModeAction(irisMode);
                    break;
                }
                case AUTO: {
                    if (this.getStargateState().notInitiating() || this.getStargateState().incoming()) {
                        if (this.irisState != EnumIrisState.OPENED) break;
                        this.toggleIris();
                        break;
                    }
                    if (!this.isIrisClosed()) break;
                    this.toggleIris();
                    break;
                }
            }
        }
        this.irisMode = irisMode;
        this.m_6596_();
    }

    private void irisModeAction(EnumIrisMode mode) {
        EnumIrisState p2;
        EnumIrisState p;
        if (mode == EnumIrisMode.OPENED) {
            p = EnumIrisState.CLOSED;
            p2 = EnumIrisState.CLOSING;
        } else if (mode == EnumIrisMode.CLOSED) {
            p = EnumIrisState.OPENED;
            p2 = EnumIrisState.OPENING;
        } else {
            return;
        }
        if (this.irisState == p) {
            this.toggleIris();
        } else if (this.irisState == p2) {
            this.afterIrisDone = this::toggleIris;
        }
    }

    public String getIrisCode() {
        return this.irisCode;
    }

    public EnumIrisMode getIrisMode() {
        return this.irisMode;
    }

    private void setIrisBlocks(boolean set) {
        BlockState invBlockState = ((Block)BlockRegistry.IRIS_BLOCK.get()).m_49966_();
        if (set) {
            invBlockState = (BlockState)((BlockState)((Block)BlockRegistry.IRIS_BLOCK.get()).m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)this.getFacing())).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(this.getFacingVertical())));
        }
        BlockPos startPos = this.pos;
        for (BlockPos invPos : Objects.requireNonNull(StargateSizeEnum.getIrisBlocksPattern(this.getStargateSize()))) {
            BlockPos newPos = BlockPosHelper.rotate(invPos, this.getFacing(), this.getFacingVertical()).m_121955_((Vec3i)startPos);
            if (set) {
                if (this.world.m_8055_(newPos).m_60734_() != Blocks.f_50016_) {
                    if (!((Boolean)JSGConfig.Stargate.irisDestroysBlocks.get()).booleanValue() || this.world.m_8055_(newPos).m_60734_() == Blocks.f_152480_ && newPos == this.getGateCenterPos()) continue;
                    this.world.m_46961_(newPos, true);
                }
                this.world.m_7731_(newPos, invBlockState, 3);
                continue;
            }
            if (newPos == this.getGateCenterPos() && this.targetGatePos != null) {
                this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
            }
            if (this.world.m_8055_(newPos).m_60734_() != BlockRegistry.IRIS_BLOCK.get()) continue;
            this.world.m_7731_(newPos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @Override
    public Iterator<Integer> getUpgradeSlotsIterator() {
        return UPGRADE_SLOTS_IDS.iterator();
    }

    @Override
    public SmallEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public int getEnergyStored() {
        return this.getEnergyStorage().getEnergyStored();
    }

    public int getPowerTier() {
        return this.currentPowerTier;
    }

    private void updatePowerTier() {
        int i;
        int powerTier = 1;
        for (i = 4; i < 7; ++i) {
            if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
            ++powerTier;
        }
        if (powerTier != this.currentPowerTier) {
            this.currentPowerTier = powerTier;
            this.energyStorage.clearStorages();
            for (i = 4; i < 7; ++i) {
                LazyOptional capCapability;
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.m_41619_() || !(capCapability = stack.getCapability(ForgeCapabilities.ENERGY, null)).isPresent() || !capCapability.resolve().isPresent()) continue;
                this.energyStorage.addStorage((IEnergyStorage)capCapability.resolve().get());
            }
            JSG.logger.debug("Updated to power tier: {}", (Object)powerTier);
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemStackHandler).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.lastFakeWorld = this.getFakeWorld();
        this.lastFakePos = this.getFakePos();
        this.m_6596_();
    }

    public ResourceKey<Level> getFakeWorld() {
        if (this.m_58904_() == null) {
            return null;
        }
        return this.m_58904_().m_46472_();
    }

    public void setFakeWorld(Level world) {
    }

    public BlockPos getFakePos() {
        return this.pos;
    }

    public void setFakePos(BlockPos pos) {
    }

    public ArrayList<NearbyGate> getNearbyGates() {
        return this.getNearbyGates(null, false, true);
    }

    public ArrayList<NearbyGate> getNearbyGates(@Nullable StargateTypeEnum gateType, boolean ignoreIfInstance, boolean checkAddressAndEnergy) {
        if (gateType == null) {
            gateType = this.getStargateType();
        }
        double squaredGate = (double)((Integer)JSGConfig.Stargate.universeGateNearbyReach.get()).intValue() * (double)((Integer)JSGConfig.Stargate.universeGateNearbyReach.get()).intValue();
        ArrayList<NearbyGate> addresses = new ArrayList<NearbyGate>();
        Class<? extends BlockEntity> tileClass = gateType.baseBlockEntityClass;
        for (Map.Entry<StargatePos, Map<SymbolTypeEnum<?>, StargateAddress>> entry : StargateNetwork.INSTANCE.getAll().entrySet()) {
            StargateClassicBaseBE classicTile;
            StargatePos stargatePos = entry.getKey();
            StargateAbstractBaseBE targetGateTile = stargatePos.getBlockEntity();
            if (!(targetGateTile instanceof StargateClassicBaseBE) || !(classicTile = (StargateClassicBaseBE)targetGateTile).isMerged() || !ignoreIfInstance && !tileClass.isInstance(classicTile)) continue;
            ResourceKey<Level> targetDim = classicTile.getFakeWorld();
            BlockPos targetFoundPos = classicTile.getFakePos();
            if (targetDim != this.getFakeWorld() || targetFoundPos.m_123331_((Vec3i)this.getFakePos()) > squaredGate || stargatePos.gatePos.equals((Object)this.pos) && stargatePos.dimension == this.world.m_46472_()) continue;
            int symbolsNeeded = this.getMinimalSymbolsToDial(targetGateTile.getSymbolType(), stargatePos);
            if (checkAddressAndEnergy) {
                StargateAddressDynamic checkingAddress = new StargateAddressDynamic(gateType.symbolType);
                checkingAddress.addAll(entry.getValue().get(this.getSymbolType()).subList(0, symbolsNeeded - 1));
                checkingAddress.addSymbol((SymbolInterface)targetGateTile.getSymbolType().getOrigin());
                if (!this.checkAddressAndEnergy(checkingAddress).ok()) continue;
                addresses.add(new NearbyGate(entry.getValue().get(this.getSymbolType()), symbolsNeeded, targetGateTile.getSymbolType()));
                continue;
            }
            addresses.add(new NearbyGate(entry.getValue().get(this.getSymbolType()), symbolsNeeded, targetGateTile.getSymbolType()));
        }
        return addresses;
    }

    public void addRedstoneDevice(BlockPos pos) {
        this.REDSTONE_IO_BLOCKS.add(pos);
        this.m_6596_();
    }

    public void removeRedstoneDevice(BlockPos pos) {
        this.REDSTONE_IO_BLOCKS.remove(pos);
        this.m_6596_();
    }

    public void updateDevices() {
        if (this.getLevelNotNull().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)this.getLevelNotNull();
        for (BlockPos pos : this.REDSTONE_IO_BLOCKS) {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof AbstractStargateRedstoneIO)) continue;
            AbstractStargateRedstoneIO ioBlock = (AbstractStargateRedstoneIO)block;
            ioBlock.tickFromStargate(state, level, pos, this);
        }
    }

    @Override
    public String getDeviceType() {
        return "STARGATE_CLASSIC";
    }

    public static enum StargateUpgradeEnum implements EnumKeyInterface<Item>
    {
        MILKYWAY_GLYPHS((Item)ItemRegistry.CRYSTAL_GLYPH_MILKYWAY.get()),
        PEGASUS_GLYPHS((Item)ItemRegistry.CRYSTAL_GLYPH_PEGASUS.get()),
        UNIVERSE_GLYPHS((Item)ItemRegistry.CRYSTAL_GLYPH_UNIVERSE.get()),
        CHEVRON_UPGRADE((Item)ItemRegistry.CRYSTAL_GLYPH_STARGATE.get());

        public final Item item;
        private static final EnumKeyMap<Item, StargateUpgradeEnum> idMap;

        private StargateUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        public static StargateUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])StargateUpgradeEnum.values());
        }
    }

    public static enum StargateIrisUpgradeEnum implements EnumKeyInterface<Item>
    {
        IRIS_UPGRADE_CLASSIC((Item)ItemRegistry.UPGRADE_IRIS.get()),
        IRIS_UPGRADE_TRINIUM((Item)ItemRegistry.UPGRADE_IRIS_TRINIUM.get()),
        IRIS_UPGRADE_CREATIVE((Item)ItemRegistry.UPGRADE_IRIS_CREATIVE.get()),
        IRIS_UPGRADE_SHIELD((Item)ItemRegistry.UPGRADE_SHIELD.get());

        public final Item item;
        private static final EnumKeyMap<Item, StargateIrisUpgradeEnum> idMap;

        private StargateIrisUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        public static StargateIrisUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])StargateIrisUpgradeEnum.values());
        }
    }
}

