/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.multistructure.mergehelper.StargateMovieMergeHelper;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.StargateMovieRendererState;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.sound.StargateSoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StargateMovieBaseBE
extends StargateMilkyWayBaseBE {
    public int lastChevronAnimated = 0;
    public boolean lastChevronAnimatedIsFinal = false;

    public StargateMovieBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_MOVIE_BASE_BE.get(), pos, state);
    }

    @Override
    public StargateTypeEnum getStargateType() {
        return StargateTypeEnum.MOVIE;
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateMovieMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    public void addSymbolToAddressDHD(SymbolInterface symbol) {
        this.stargateState = EnumStargateState.DIALING;
        this.m_6596_();
        if (symbol.brb()) {
            this.attemptOpenAndFail();
            this.m_6596_();
            return;
        }
        this.addSymbolToAddress(symbol);
        this.doIncomingAnimation(this.isNoxDialing ? 1 : 10, false);
        int plusTime = new Random().nextInt(5);
        if (!this.isNoxDialing) {
            if (this.stargateWillLock(symbol)) {
                this.isFinalActive = true;
            }
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 5 + plusTime));
        }
        this.m_6596_();
    }

    @Override
    protected StargateMovieRendererState.StargateMovieRendererStateBuilder getRendererStateServer() {
        return (StargateMovieRendererState.StargateMovieRendererStateBuilder)new StargateMovieRendererState.StargateMovieRendererStateBuilder(super.getRendererStateServer()).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargateMovieRendererState();
    }

    @Override
    public StargateMovieRendererState getRendererStateClient() {
        return (StargateMovieRendererState)super.getRendererStateClient();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        if (this.getRendererStateClient() != null && stateType == StateTypeEnum.RENDERER_UPDATE) {
            StargateRendererActionState gateActionState = (StargateRendererActionState)state;
            switch (gateActionState.action) {
                case CHEVRON_OPEN: {
                    this.getRendererStateClient().openChevron(this.getTime(), gateActionState.chevronCount, gateActionState.modifyFinal);
                    break;
                }
                case CHEVRON_CLOSE: {
                    this.getRendererStateClient().closeChevron(this.getTime(), gateActionState.chevronCount, gateActionState.modifyFinal);
                    break;
                }
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        switch (scheduledTask) {
            case STARGATE_CHEVRON_LIGHT_UP: {
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.isIncoming) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 20));
                    return;
                }
                if (!this.stargateState.dialingDHD()) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, this.stargateWillLock(this.targetRingSymbol));
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 20));
                } else {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, this.isFinalActive);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 5));
                }
                return;
            }
            case STARGATE_CHEVRON_OPEN: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.lastChevronAnimated = this.dialedAddress.size();
                if (this.stargateState.dialingDHD()) {
                    --this.lastChevronAnimated;
                }
                this.lastChevronAnimatedIsFinal = this.stargateWillLock(this.targetRingSymbol, true);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_OPEN, this.lastChevronAnimated, this.lastChevronAnimatedIsFinal);
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    return;
                }
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol);
                    if (this.stargateWillLock(this.targetRingSymbol)) {
                        if (this.checkAddressAndEnergy(this.dialedAddress).ok()) {
                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 13));
                        } else {
                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                        }
                    } else {
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    }
                } else {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                }
                return;
            }
            case STARGATE_CHEVRON_OPEN_SECOND: {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 3));
                return;
            }
            case STARGATE_CHEVRON_CLOSE: {
                if (this.stargateState.dialingDHD()) {
                    this.stargateState = EnumStargateState.IDLE;
                    this.m_6596_();
                    return;
                }
                if (this.stargateState.incoming() || this.isIncoming) {
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, this.lastChevronAnimated, this.lastChevronAnimatedIsFinal);
                    this.m_6596_();
                    return;
                }
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, this.lastChevronAnimated, this.lastChevronAnimatedIsFinal);
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.stargateState = EnumStargateState.IDLE;
                } else {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_DIM, 10));
                }
                return;
            }
            case STARGATE_CHEVRON_FAIL: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, -this.dialedAddress.size(), true);
                this.dialingFailed(this.checkAddressAndEnergy(this.dialedAddress));
                return;
            }
        }
        super.executeTask(scheduledTask, customData);
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> SoundPositionedEnum.MILKYWAY_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> SoundPositionedEnum.MILKYWAY_RING_ROLL_START;
        };
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEventEnum.GATE_MILKYWAY_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEventEnum.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEventEnum.GATE_MILKYWAY_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> {
                if (this.stargateState.dialingComputer()) {
                    yield SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED_COMPUTER;
                }
                yield SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED;
            }
            case StargateSoundEventEnum.INCOMING, StargateSoundEventEnum.CHEVRON_OPEN -> SoundEventEnum.GATE_MOVIE_CHEVRON_HOLD;
            case StargateSoundEventEnum.CHEVRON_SHUT -> SoundEventEnum.GATE_MOVIE_CHEVRON_ENGAGE;
            default -> null;
        };
    }
}

