/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.util;

import dev.tauri.jsg.blockentity.util.ScheduledTaskExecutorInterface;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class ScheduledTask
implements INBTSerializable<CompoundTag> {
    private ScheduledTaskExecutorInterface executor;
    private long taskCreated;
    private EnumScheduledTask scheduledTask;
    private boolean active;
    private boolean customWaitTime;
    private int waitTime;
    private CompoundTag customData = null;

    public ScheduledTask(EnumScheduledTask scheduledTask) {
        this.scheduledTask = scheduledTask;
        this.active = true;
        this.customWaitTime = false;
    }

    public ScheduledTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        this(scheduledTask);
        this.customData = customData;
    }

    public ScheduledTask(EnumScheduledTask scheduledTask, int waitTime) {
        this(scheduledTask);
        this.customWaitTime = true;
        this.waitTime = waitTime;
    }

    public ScheduledTask(EnumScheduledTask scheduledTask, int waitTime, CompoundTag customData) {
        this(scheduledTask, waitTime);
        this.customData = customData;
    }

    public ScheduledTask(CompoundTag compound) {
        this.deserializeNBT(compound);
    }

    public ScheduledTask setExecutor(ScheduledTaskExecutorInterface executor) {
        this.executor = executor;
        return this;
    }

    public void setTaskCreated(long taskCreated) {
        this.taskCreated = taskCreated;
    }

    public ScheduledTask inactive() {
        this.active = false;
        return this;
    }

    public ScheduledTask active() {
        this.active = true;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean update(long worldTicks) {
        boolean call;
        int waitTime = this.customWaitTime ? this.waitTime : this.scheduledTask.waitTicks;
        long effTick = worldTicks - this.taskCreated;
        boolean bl = call = effTick == (long)waitTime;
        if (this.scheduledTask.overtime) {
            boolean bl2 = call = effTick >= (long)waitTime;
        }
        if (call) {
            try {
                this.executor.executeTask(this.scheduledTask, this.customData);
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("taskCreated", this.taskCreated);
        compound.m_128405_("scheduledTask", this.scheduledTask.id);
        compound.m_128379_("active", this.active);
        compound.m_128379_("customWaitTime", this.customWaitTime);
        compound.m_128405_("waitTime", this.waitTime);
        if (this.customData != null) {
            compound.m_128365_("customData", (Tag)this.customData);
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.taskCreated = compound.m_128454_("taskCreated");
        this.scheduledTask = EnumScheduledTask.valueOf(compound.m_128451_("scheduledTask"));
        this.active = compound.m_128471_("active");
        this.customWaitTime = compound.m_128471_("customWaitTime");
        this.waitTime = compound.m_128451_("waitTime");
        if (compound.m_128441_("customData")) {
            this.customData = compound.m_128469_("customData");
        }
    }

    public String toString() {
        return this.scheduledTask.toString() + (String)(this.customWaitTime ? ", custom time=" + this.waitTime : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scheduledTask == null ? 0 : this.scheduledTask.hashCode());
        result = 31 * result + (int)(this.taskCreated ^ this.taskCreated >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduledTask other = (ScheduledTask)obj;
        if (this.scheduledTask != other.scheduledTask) {
            return false;
        }
        return this.taskCreated == other.taskCreated;
    }

    public static void iterate(List<ScheduledTask> scheduledTasks, long worldTicks) {
        int i = 0;
        while (i < scheduledTasks.size()) {
            ScheduledTask scheduledTask = scheduledTasks.get(i);
            if (scheduledTask.isActive()) {
                if (scheduledTask.update(worldTicks)) {
                    scheduledTasks.remove(scheduledTask);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    public static CompoundTag serializeList(List<ScheduledTask> scheduledTasks) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("size", scheduledTasks.size());
        for (int i = 0; i < scheduledTasks.size(); ++i) {
            compound.m_128365_("scheduledTask" + i, (Tag)scheduledTasks.get(i).serializeNBT());
        }
        return compound;
    }

    public static void deserializeList(CompoundTag compound, List<ScheduledTask> scheduledTasks, ScheduledTaskExecutorInterface executor) {
        int size = compound.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            scheduledTasks.add(new ScheduledTask(compound.m_128469_("scheduledTask" + i)).setExecutor(executor));
        }
    }
}

