/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config;

import com.google.gson.GsonBuilder;
import dev.tauri.jsg.config.IJSONConfigEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractJSONConfig<E extends IJSONConfigEntry> {
    public final Collection<E> defaults;
    public final Map<String, E> configEntries = new HashMap<String, E>();
    public final String name;
    private File file;
    protected boolean shouldWriteToFile;

    public AbstractJSONConfig(String name, Collection<E> defaults) {
        this.defaults = defaults;
        this.name = name;
    }

    @Nullable
    public E getConfigEntry(String id) {
        if (this.configEntries.isEmpty()) {
            return null;
        }
        return (E)((IJSONConfigEntry)this.configEntries.get(id));
    }

    public abstract Type getJSONType();

    public void reload(@Nullable MinecraftServer server) throws IOException {
        this.load(null);
        this.update(server);
    }

    public void load(File modConfigDir) {
        this.configEntries.clear();
        if (modConfigDir != null) {
            this.file = new File(modConfigDir, "jsg/" + this.name + ".json");
        }
        if (this.file == null) {
            return;
        }
        try {
            Type typeOfHashMap = this.getJSONType();
            Map configMap = (Map)new GsonBuilder().create().fromJson((Reader)new FileReader(this.file), typeOfHashMap);
            if (configMap != null) {
                this.configEntries.putAll(configMap);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected void update(@Nullable MinecraftServer server) throws IOException {
        if (this.configEntries.isEmpty()) {
            this.defaults.forEach(e -> this.configEntries.put(e.getId(), e));
            this.shouldWriteToFile = true;
        }
        if (!this.shouldWriteToFile) {
            return;
        }
        if (this.file == null) {
            return;
        }
        FileWriter writer = new FileWriter(this.file);
        writer.write(new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2, 4}).create().toJson(this.configEntries, this.getJSONType()));
        writer.close();
        this.shouldWriteToFile = false;
    }
}

