/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config;

import dev.tauri.jsg.config.util.StargateTimeLimitModeEnum;
import dev.tauri.jsg.helpers.TemperatureHelper;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.StargateSizeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class JSGConfig {
    private static final String CONFIG_FILE_NAME = "jsg/jsgConfig_2.0/";
    private static final ArrayList<JSGConfigChild> LIST = new ArrayList();

    public static void register() {
        LIST.clear();
        LIST.add(new JSGConfigChild(General.BUILDER, "General"));
        LIST.add(new JSGConfigChild(Debug.BUILDER, "Debug"));
        LIST.add(new JSGConfigChild(DialHomeDevice.BUILDER, "DialHomeDevice"));
        LIST.add(new JSGConfigChild(Stargate.BUILDER, "Stargate"));
        for (JSGConfigChild child : LIST) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)child.builder.build(), CONFIG_FILE_NAME + child.name + ".toml");
        }
    }

    public static void load() {
    }

    public static class JSGConfigChild {
        public ForgeConfigSpec.Builder builder;
        public String name;

        public JSGConfigChild setBuilder(ForgeConfigSpec.Builder b) {
            this.builder = b;
            return this;
        }

        public JSGConfigChild setName(String name) {
            this.name = name;
            return this;
        }

        public JSGConfigChild(ForgeConfigSpec.Builder b, String n) {
            this.setBuilder(b);
            this.setName(n);
        }
    }

    public static class General {
        private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec.BooleanValue enableAutoUpdater = BUILDER.comment(new String[]{"Should JSG check for update on startup?", "SIDE: CLIENT"}).define("Check for updates", true);
        public static final ForgeConfigSpec.DoubleValue volume = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("JSG sounds volume", 1.0, 0.0, 3.0);
        public static final ForgeConfigSpec.ConfigValue<Double> visualGlyphTransparency = BUILDER.comment(new String[]{"Specifies transparency of glyphs on notebook page", "SIDE: CLIENT"}).defineInRange("Notebook page Glyph transparency", 0.75, 0.0, 1.0);
        public static final ForgeConfigSpec.EnumValue<TemperatureHelper.EnumTemperatureUnit> temperatureUnit = BUILDER.comment(new String[]{"Specifies what unit will be used to display temperatures", "SIDE: CLIENT"}).defineEnum("Temperature unit", (Enum)TemperatureHelper.EnumTemperatureUnit.CELSIUS);
        public static final ForgeConfigSpec.BooleanValue disableJSGMainMenu = BUILDER.comment(new String[]{"Disables showing custom main menu", "WARNING! - Requires reloading!", "SIDE: CLIENT"}).define("Disable JSG main menu", false);
        public static final ForgeConfigSpec.ConfigValue<Integer> backgroundImagesCount = BUILDER.comment(new String[]{"Specifies how many images can be used as background of mainmenu. (starts from 0)", "DO NOT CHANGE THIS IF YOU DO NOT KNOW WHAT ARE YOU DOING!", "WARNING! - Requires reloading!", "SIDE: CLIENT"}).define("Main menu background images count", (Object)7);
        public static final ForgeConfigSpec.BooleanValue enableLogo = BUILDER.comment(new String[]{"WARNING! - Requires reloading!", "SIDE: CLIENT"}).define("Enable Tau'ri logo on startup", true);
        public static final ForgeConfigSpec.BooleanValue mainMenuDebugMode = BUILDER.comment("SIDE: CLIENT").define("Enable debug mode in main menu", false);
        public static final ForgeConfigSpec.BooleanValue playMusic = BUILDER.comment("SIDE: CLIENT").define("Play music in main menu", true);
    }

    public static class Debug {
        private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec.BooleanValue renderInvisibleBlocks = BUILDER.comment(new String[0]).define("Render invisible blocks", false);
        public static final ForgeConfigSpec.BooleanValue renderBoundingBoxes = BUILDER.comment(new String[0]).define("Render bounding boxes", false);
        public static final ForgeConfigSpec.BooleanValue logLoadingTextures = BUILDER.comment(new String[0]).define("Log loading textures and models", false);
    }

    public static class DialHomeDevice {
        private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec.IntValue rangeFlat = BUILDER.comment("SIDE: SERVER").defineInRange("DHD range's radius horizontal", 25, 1, 64);
        public static final ForgeConfigSpec.IntValue rangeVertical = BUILDER.comment("SIDE: SERVER").defineInRange("DHD range's radius vertical", 15, 1, 64);
        public static final ForgeConfigSpec.IntValue universeDialerReach = BUILDER.comment("SIDE: SERVER").defineInRange("Universe dialer max horizontal reach radius", 10, 1, 64);
        public static final ForgeConfigSpec.IntValue fluidCapacity = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("DHD's max fluid capacity", 16000, 1, 128000);
        public static final ForgeConfigSpec.DoubleValue capacityUpgradeMultiplier = BUILDER.comment(new String[]{"When capacity upgrade is placed in the DHD,", "then multiply internal capacity by this number", "SIDE: SERVER/CLIENT"}).defineInRange("Capacity upgrade multiplier", 2.0, 1.0, 5.0);
        public static final ForgeConfigSpec.IntValue energyPerNaquadah = BUILDER.comment("SIDE: SERVER").defineInRange("Energy per 1mB Naquadah", 10240, 1, 50000);
        public static final ForgeConfigSpec.DoubleValue efficiencyUpgradeMultiplier = BUILDER.comment(new String[]{"Energy per 1mB is multiplied by this", "when efficiency upgrade is placed in the DHD", "SIDE: SERVER"}).defineInRange("Efficiency upgrade multiplier", 1.4, 1.0, 5.0);
        public static final ForgeConfigSpec.DoubleValue activationLevel = BUILDER.comment("SIDE: SERVER").defineInRange("Cold fusion reactor activation energy level", 0.9, 0.0, 1.0);
        public static final ForgeConfigSpec.DoubleValue deactivationLevel = BUILDER.comment("SIDE: SERVER").defineInRange("Cold fusion reactor deactivation energy level", 0.98, 0.0, 1.0);
        public static final ForgeConfigSpec.BooleanValue computerDialSound = BUILDER.comment(new String[]{"THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).define("Enable press sound when dialing with computer", false);
        public static final ForgeConfigSpec.BooleanValue dhdLastOpen = BUILDER.comment(new String[]{"Enable opening last chevron while dialing milkyway gate with dhd", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).define("Enable opening last chevron while dialing with dhd", true);
        public static final ForgeConfigSpec.BooleanValue enablePageHint = BUILDER.comment("SIDE: CLIENT").define("Enable hint when dialing on DHDs with notebook page", true);
        public static final ForgeConfigSpec.ConfigValue<String> pageHintColorNormal = BUILDER.comment(new String[]{"Set colors of each dial helper button", "You should use HEX values", "SIDE: CLIENT"}).define("Dialing helper colors.Normal", (Object)"#7FFFFF");
        public static final ForgeConfigSpec.ConfigValue<String> pageHintColorExtra = BUILDER.comment(new String[]{"Set colors of each dial helper button", "You should use HEX values", "SIDE: CLIENT"}).define("Dialing helper colors.ExtraSymbols", (Object)"#E56BEE");
        public static final ForgeConfigSpec.ConfigValue<String> pageHintColorOrigin = BUILDER.comment(new String[]{"Set colors of each dial helper button", "You should use HEX values", "SIDE: CLIENT"}).define("Dialing helper colors.Origin", (Object)"#7FFF7F");
    }

    public static class Stargate {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec.EnumValue<StargateSizeEnum> stargateSize = BUILDER.comment(new String[]{"Defines size of stargate's model", "SIDE: SERVER/CLIENT"}).defineEnum("Stargate size", (Enum)StargateSizeEnum.MEDIUM);
        public static final ForgeConfigSpec.BooleanValue enableBurriedState = BUILDER.comment(new String[]{"THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).define("Mechanics.Enable burried state for gates", true);
        public static final ForgeConfigSpec.IntValue stargateOrlinMaxOpenCount = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Mechanics.Orlin's gate max open count", 2, 0, 15000);
        public static final ForgeConfigSpec.IntValue universeGateNearbyReach = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Mechanics.Universe dialer nearby radius", 1024, 5, Integer.MAX_VALUE);
        public static final ForgeConfigSpec.BooleanValue enableGateOverHeatExplosion = BUILDER.comment(new String[]{"Should gate explode when its overheated?", "SIDE: SERVER"}).define("Mechanics.Enable gate overheat with explosion", true);
        public static final ForgeConfigSpec.DoubleValue gateMaxHeat = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Mechanics.Max stargate heat", 4340.0, 0.0, Double.MAX_VALUE);
        public static final ForgeConfigSpec.BooleanValue allowConnectToDialing = BUILDER.comment(new String[]{"If target gate is dialing and this option is set to true,", "the target gate will stop dialing and open incoming wormhole.", "If this is set to false and the dialed gate dialing address,", "the connection will not established.", "If it cause issues, set it to false.", "SIDE: SERVER"}).define("Mechanics.Connect to dialing gate", true);
        public static final ForgeConfigSpec.BooleanValue pegAndMilkUseEightChevrons = BUILDER.comment(new String[]{"Change this to true, if you want to use 8 chevrons between pegasus and milkyway gates", "SIDE: SERVER"}).define("Mechanics.Use 8 chevrons between MW and PG gates", true);
        public static final ForgeConfigSpec.BooleanValue useStrictSevenSymbolsUniGate = BUILDER.comment(new String[]{"If you want to dial UNI-UNI only with seven symbols (interdimensional for example), set this to true", "SIDE: SERVER"}).define("Mechanics.Need only 7 symbols between Uni gates", false);
        public static final ForgeConfigSpec.BooleanValue killAtDestination = BUILDER.comment(new String[]{"If set to 'false' player get killed by iris on entering event horizon", "SIDE: SERVER"}).define("Iris.Iris kills at destination", true);
        public static final ForgeConfigSpec.BooleanValue allowCreative = BUILDER.comment(new String[]{"Set it to true, if u want to bypass", "shield/iris damage by creative gamemode", "SIDE: SERVER"}).define("Iris.Allow creative bypass", true);
        public static final ForgeConfigSpec.BooleanValue irisDestroysBlocks = BUILDER.comment("SIDE: SERVER").define("Iris.Can iris destroy blocks", false);
        public static final ForgeConfigSpec.BooleanValue enableIrisOverHeatCollapse = BUILDER.comment(new String[]{"Should iris break when its overheated?", "SIDE: SERVER"}).define("Iris.Enable iris overheat collapse", true);
        public static final ForgeConfigSpec.IntValue titaniumIrisDurability = BUILDER.comment(new String[]{"Durability of Titanium iris", "set it to 0, if u want to make it unbreakable", "SIDE: SERVER/CLIENT"}).defineInRange("Iris.Titanium iris durability", 500, 0, 500000);
        public static final ForgeConfigSpec.IntValue triniumIrisDurability = BUILDER.comment(new String[]{"Durability of Trinium iris", "set it to 0, if u want to make it unbreakable", "SIDE: SERVER/CLIENT"}).defineInRange("Iris.Trinium iris durability", 1000, 0, 500000);
        public static final ForgeConfigSpec.IntValue irisShieldPowerDraw = BUILDER.comment(new String[]{"Energy/tick used for make shield closed", "SIDE: SERVER"}).defineInRange("Iris.Shield power draw", 500, 0, 500000);
        public static final ForgeConfigSpec.IntValue irisCodeLength = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Iris.Maximum iris code length", 9, 1, 32);
        public static final ForgeConfigSpec.IntValue irisUnbreakingChance = BUILDER.comment(new String[]{"0 - disables unbreaking on iris", "100 - unbreaking makes iris unbreakable", "SIDE: SERVER"}).defineInRange("Iris.Unbreaking chance per level", 10, 0, 100);
        public static final ForgeConfigSpec.DoubleValue irisTitaniumMaxHeat = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Iris.Max titanium iris heat", 1668.0, 0.0, Double.MAX_VALUE);
        public static final ForgeConfigSpec.DoubleValue irisTriniumMaxHeat = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Iris.Max trinium iris heat", 2336.0, 0.0, Double.MAX_VALUE);
        public static final ForgeConfigSpec.IntValue stargateEnergyStorage = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Power.Stargate's internal buffer size", 71280000, 4608, Integer.MAX_VALUE);
        public static final ForgeConfigSpec.IntValue stargateMaxEnergyTransfer = BUILDER.comment("SIDE: SERVER").defineInRange("Power.Stargate's max power throughput", 26360, 1, 500000);
        public static final ForgeConfigSpec.IntValue openingBlockToEnergyRatio = BUILDER.comment("SIDE: SERVER").defineInRange("Power.Stargate wormhole open power draw", 4608, 0, 500000);
        public static final ForgeConfigSpec.IntValue keepAliveBlockToEnergyRatioPerTick = BUILDER.comment("SIDE: SERVER").defineInRange("Power.Stargate wormhole sustain power draw", 2, 0, 50);
        public static final ForgeConfigSpec.IntValue instabilitySeconds = BUILDER.comment(new String[]{"Seconds of energy left before gate becomes unstable", "SIDE: SERVER"}).defineInRange("Power.Stargate instability threshold", 20, 1, 120);
        public static final ForgeConfigSpec.DoubleValue stargateOrlinEnergyMul = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Power.Orlin's gate energy multiplier", 2.0, 0.0, 100.0);
        public static final ForgeConfigSpec.DoubleValue stargateUniverseEnergyMul = BUILDER.comment("SIDE: SERVER/CLIENT").defineInRange("Power.Universe gate energy multiplier", 2.0, 0.0, 100.0);
        public static final ForgeConfigSpec.IntValue universeCapacitors = BUILDER.comment(new String[]{"THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER/CLIENT"}).defineInRange("Power.Capacitors supported by Universe gates", 1, 0, 3);
        public static final ForgeConfigSpec.DoubleValue eightSymbolAddressMul = BUILDER.comment(new String[]{"Specifies the multiplier of power needed to keep the gate alive", "when 8-symbols address is dialed", "SIDE: SERVER"}).defineInRange("Power.Stargate eight symbols address power mul", (double)1.3f, 0.0, 100.0);
        public static final ForgeConfigSpec.DoubleValue nineSymbolAddressMul = BUILDER.comment(new String[]{"Specifies the multiplier of power needed to keep the gate alive", "when 9-symbols address is dialed", "SIDE: SERVER"}).defineInRange("Power.Stargate nine symbols address power mul", (double)1.7f, 0.0, 100.0);
        public static final ForgeConfigSpec.ConfigValue<List<? extends String>> camoBlacklist = BUILDER.comment(new String[]{"Specify what blocks can not be used as camo for gates.", "These blocks are only additional. There are also blocks that are internally coded", "and can not be deleted from the blacklist!", "Format: \"modid:block\", for example: ", "\"minecraft:stone\"", "\"minecraft:cobblestone\"", "SIDE: SERVER/CLIENT"}).defineList("Visual.Camo blocks blacklist", List.of("minecraft:barrier", "minecraft:structure_block", "minecraft:structure_void", "minecraft:command_block"), String.class::isInstance);
        public static final ForgeConfigSpec.BooleanValue allowIncomingAnimations = BUILDER.comment(new String[]{"If the incoming animations of gates generate issues, set it to false", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).define("Visual.Allow incoming animations", true);
        public static final ForgeConfigSpec.BooleanValue fasterMWGateDial = BUILDER.comment(new String[]{"Speed up dialing with computer on MW and UNI gates", "SIDE: SERVER/CLIENT"}).define("Visual.Faster MilkyWay and Universe gates computer dial", false);
        public static final ForgeConfigSpec.BooleanValue enableFastDialing = BUILDER.comment(new String[]{"Enable fast dialing on gates by default", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER/CLIENT"}).define("Visual.Enable fast dialing of gates", false);
        public static final Map<BiomeOverlayEnum, ForgeConfigSpec.ConfigValue<List<? extends String>>> biomeMatches = new HashMap<BiomeOverlayEnum, ForgeConfigSpec.ConfigValue<List<? extends String>>>(){
            {
                this.put(BiomeOverlayEnum.NORMAL, BUILDER.comment(new String[]{"This check comes last (after block is directly under sky (except Nether) and temperature is high enough).", "You can disable the temperature check by setting it to a negative value.", "Format: \"modid:biomename\", for example: ", "\"minecraft:dark_forest\"", "\"minecraft:forest\"", "SIDE: SERVER/CLIENT"}).defineList("Visual.Biome overlay biome matches.NORMAL", new ArrayList(), String.class::isInstance));
                this.put(BiomeOverlayEnum.FROST, BUILDER.defineList("Visual.Biome overlay biome matches.FROST", new ArrayList(), String.class::isInstance));
                this.put(BiomeOverlayEnum.MOSSY, BUILDER.defineList("Visual.Biome overlay biome matches.MOSSY", List.of("minecraft:jungle", "minecraft:jungle_hills", "minecraft:jungle_edge", "minecraft:mutated_jungle", "minecraft:mutated_jungle_edge"), String.class::isInstance));
                this.put(BiomeOverlayEnum.AGED, BUILDER.defineList("Visual.Biome overlay biome matches.AGED", List.of("jsg:abydos"), String.class::isInstance));
                this.put(BiomeOverlayEnum.SOOTY, BUILDER.defineList("Visual.Biome overlay biome matches.SOOTY", List.of("minecraft:hell"), String.class::isInstance));
            }
        };
        public static final Map<BiomeOverlayEnum, ForgeConfigSpec.ConfigValue<List<? extends String>>> biomeOverrideBlocks = new HashMap<BiomeOverlayEnum, ForgeConfigSpec.ConfigValue<List<? extends String>>>(){
            {
                this.put(BiomeOverlayEnum.NORMAL, BUILDER.comment(new String[]{"Format: \"modid:blockid\", for example: ", "\"minecraft:red_wool\"", "\"minecraft:stone\"", "SIDE: SERVER/CLIENT"}).defineList("Visual.Biome overlay override blocks.NORMAL", List.of("minecraft:stone"), String.class::isInstance));
                this.put(BiomeOverlayEnum.FROST, BUILDER.defineList("Visual.Biome overlay override blocks.FROST", List.of("minecraft:ice"), String.class::isInstance));
                this.put(BiomeOverlayEnum.MOSSY, BUILDER.defineList("Visual.Biome overlay override blocks.MOSSY", List.of("minecraft:vine"), String.class::isInstance));
                this.put(BiomeOverlayEnum.AGED, BUILDER.defineList("Visual.Biome overlay override blocks.AGED", List.of("minecraft:cobblestone"), String.class::isInstance));
                this.put(BiomeOverlayEnum.SOOTY, BUILDER.defineList("Visual.Biome overlay override blocks.SOOTY", List.of("minecraft:coal_block"), String.class::isInstance));
            }
        };
        public static final ForgeConfigSpec.BooleanValue enableDiffOrigins = BUILDER.comment("SIDE: CLIENT").define("PointOfOrigins.Enable different Point Of Origins for MW gate", true);
        public static final ForgeConfigSpec.ConfigValue<List<? extends String>> additionalOrigins = BUILDER.comment(new String[]{"Specifies Point Of Origins that were added by any resource pack.", "This options is required to load all models of added origins!", "Format: \"id:name\", for example: ", "\"6:Tollan\"", "\"7:P4X-256\"", "!DO NOT CHANGE ANYTHING IF YOU DON'T KNOW WHAT ARE YOU DOING!", "SIDE: CLIENT/SERVER"}).defineList("PointOfOrigins.Custom added points of origin", new ArrayList(), String.class::isInstance);
        public static final ForgeConfigSpec.BooleanValue wrongSideKilling = BUILDER.comment("SIDE: SERVER").define("EventHorizon.Enable wrong side killing", true);
        public static final ForgeConfigSpec.DoubleValue ehDeathChance = BUILDER.comment("SIDE: SERVER").defineInRange("EventHorizon.Unstable Event Horizon chance of death", (double)0.07f, 0.0, 1.0);
        public static final ForgeConfigSpec.BooleanValue renderEHifTheyNot = BUILDER.comment("SIDE: CLIENT").define("EventHorizon.Render EHs even if they are not rendering", true);
        public static final ForgeConfigSpec.IntValue eventHorizonRenderSections = BUILDER.comment(new String[]{"Defines how many sections should be used to render EH kawoosh", "DO NOT CHANGE THIS UNLESS YOU KNOW WHAT YOU ARE DOING!", "SIDE: CLIENT"}).defineInRange("EventHorizon.Rendering.Number of EH sections", 72, 12, 288);
        public static final ForgeConfigSpec.IntValue eventHorizonRenderQuads = BUILDER.comment(new String[]{"Defines how many quads should be used to render EH circle", "DO NOT CHANGE THIS UNLESS YOU KNOW WHAT YOU ARE DOING!", "SIDE: CLIENT"}).defineInRange("EventHorizon.Rendering.Number of EH quads", 16, 8, 64);
        public static final ForgeConfigSpec.BooleanValue autocloseEnabled = BUILDER.comment("SIDE: SERVER").define("AutoClose.Autoclose enabled", true);
        public static final ForgeConfigSpec.IntValue secondsToAutoclose = BUILDER.comment("SIDE: SERVER").defineInRange("AutoClose.Seconds to autoclose with no players nearby", 5, 1, 300);
        public static final ForgeConfigSpec.IntValue maxOpenedSeconds = BUILDER.comment(new String[]{"In seconds (2280 = 38 minutes)", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).defineInRange("OpenTimeLimit.Maximum seconds of gate should be open", 240, 5, 3000);
        public static final ForgeConfigSpec.EnumValue<StargateTimeLimitModeEnum> maxOpenedWhat = BUILDER.comment(new String[]{"What happens after gate's open time reaches limit?", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).defineEnum("OpenTimeLimit.Gate open time limit mode", (Enum)StargateTimeLimitModeEnum.DRAW_MORE_POWER);
        public static final ForgeConfigSpec.IntValue maxOpenedPowerDrawAfterLimit = BUILDER.comment(new String[]{"THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).defineInRange("OpenTimeLimit.Power draw after opened time limit", 10000, 0, 50000);
        public static final ForgeConfigSpec.BooleanValue enableRandomIncoming = BUILDER.comment(new String[]{"Enable random incoming wormholes generator", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"}).define("RandomIncomingGenerator.Enable random incoming wormholes", true);
        public static final ForgeConfigSpec.DoubleValue rigChance = BUILDER.comment("SIDE: SERVER").defineInRange("RandomIncomingGenerator.Chance to generate RIG on gate", 1.0, 0.0, 50.0);
    }
}

