/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.ingame;

import dev.tauri.jsg.JSG;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class JSGConfigOption<T> {
    protected static final int X = -25;
    public final List<String> comment;
    protected T value;
    public final T defaultValue;
    protected final String label;

    public JSGConfigOption(String label, @Nonnull T defaultValue, String ... comment) {
        this(label, defaultValue, defaultValue, comment);
    }

    public JSGConfigOption(String label, @Nonnull T defaultValue, @Nonnull T value, String ... comment) {
        this.label = label;
        this.defaultValue = defaultValue;
        this.value = value;
        this.comment = Arrays.asList(comment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract AbstractWidget createGUIComponent(int var1, int var2);

    public String getLabel() {
        return this.label;
    }

    protected T getDefaultValue() {
        return this.defaultValue;
    }

    protected List<String> additionalCommentInfo() {
        return List.of();
    }

    public List<Component> getCommentToRender() {
        ArrayList<String> c = new ArrayList<String>(this.getComment());
        c.add("---------------------------------");
        c.addAll(this.additionalCommentInfo());
        c.add("Default: " + String.valueOf(this.getDefaultValue()));
        c.add("---------------------------------");
        ArrayList<Component> cc = new ArrayList<Component>();
        for (String s : c) {
            cc.add((Component)Component.m_237113_((String)s));
        }
        return cc;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public abstract boolean setValue(String var1);

    public boolean setValue(T newValue) {
        if (!this.value.equals(newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public boolean setValue(Tag newValue) {
        if (newValue == null) {
            return this.setValue(this.defaultValue);
        }
        if (newValue instanceof IntTag) {
            IntTag i = (IntTag)newValue;
            if (this.defaultValue instanceof Integer) {
                return this.setValue(i.m_7047_());
            }
        }
        if (newValue instanceof ByteTag) {
            ByteTag b = (ByteTag)newValue;
            if (this.defaultValue instanceof Boolean) {
                return this.setValue(b.m_7063_() == 1);
            }
        }
        if (newValue instanceof StringTag) {
            StringTag s = (StringTag)newValue;
            return this.setValue(s.m_7916_());
        }
        JSG.logger.warn("invalid tag read for config option %s expected tag containing %s, got tag of %s type with value \"%s\"".formatted(this.label, this.defaultValue.getClass().getSimpleName(), newValue.m_6458_(), newValue.m_7916_()));
        return false;
    }

    @Nonnull
    public T getValue() {
        return this.value;
    }

    public Tag valueAsNBT() {
        T t = this.value;
        if (t instanceof Integer) {
            Integer i = (Integer)t;
            return IntTag.m_128679_((int)i);
        }
        t = this.value;
        if (t instanceof Boolean) {
            Boolean b = (Boolean)t;
            return ByteTag.m_128273_((boolean)b);
        }
        return StringTag.m_129297_((String)this.value.toString());
    }

    public void writeBytes(ByteBuf buf) {
        T t = this.value;
        if (t instanceof Integer) {
            Integer i = (Integer)t;
            buf.writeInt(i.intValue());
        } else {
            t = this.value;
            if (t instanceof Boolean) {
                Boolean b = (Boolean)t;
                buf.writeByte(b != false ? 1 : 0);
            } else {
                String val = this.value.toString();
                buf.writeInt(val.length());
                buf.writeCharSequence((CharSequence)val, StandardCharsets.UTF_8);
            }
        }
    }

    public void readBytes(ByteBuf buf) {
        if (this.defaultValue instanceof Integer) {
            this.value = buf.readInt();
        } else if (this.defaultValue instanceof Boolean) {
            this.value = buf.readByte() == 1;
        } else {
            String val = buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString();
            buf.writeCharSequence((CharSequence)val, StandardCharsets.UTF_8);
        }
    }
}

