/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.ingame;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.ingame.JSGConfigOption;
import dev.tauri.jsg.screen.element.NumberOnlyTextField;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JSGIntRangeConfigOption
extends JSGConfigOption<Integer> {
    public final Optional<Integer> min;
    public final Optional<Integer> max;

    public JSGIntRangeConfigOption(String label, @Nullable Integer min, @Nullable Integer max, @Nonnull Integer defaultValue, @Nonnull Integer value, String ... comment) {
        super(label, defaultValue, value, comment);
        this.min = Optional.ofNullable(min);
        this.max = Optional.ofNullable(max);
    }

    public JSGIntRangeConfigOption(String label, @Nullable Integer min, @Nullable Integer max, @Nonnull Integer defaultValue, String ... comment) {
        this(label, min, max, defaultValue, defaultValue, comment);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AbstractWidget createGUIComponent(int y, int id) {
        NumberOnlyTextField field = new NumberOnlyTextField(-25, y, 90, 15);
        field.m_94144_(((Integer)this.value).toString());
        return field;
    }

    @Override
    public boolean setValue(String value) {
        try {
            return this.setValue(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            JSG.logger.warn("\"%s\" is not a valid integer as required by %s".formatted(value, this.label));
            return false;
        }
    }

    @Override
    public boolean setValue(Integer newValue) {
        if (this.min.isPresent() && newValue < this.min.get() || this.max.isPresent() && newValue > this.max.get()) {
            JSG.logger.warn("\"%d\" is not within the valid range of %d to %d for %s".formatted(newValue, this.min, this.max, this.label));
            return false;
        }
        return super.setValue(newValue);
    }

    @Override
    protected List<String> additionalCommentInfo() {
        List<String> addComment = Stream.concat(this.min.map(i -> "Min: " + i).stream(), this.max.map(i -> "Max " + i).stream()).toList();
        return addComment;
    }

    @Override
    public Tag valueAsNBT() {
        return IntTag.m_128679_((int)((Integer)this.value));
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        buf.writeInt(((Integer)this.value).intValue());
    }
}

